/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.StaticSgConfig;
import com.floragunn.searchguard.configuration.validation.ConfigModificationValidators;
import com.floragunn.searchguard.dlic.rest.api.AbstractApiAction;
import com.floragunn.searchguard.dlic.rest.api.Endpoint;
import com.floragunn.searchguard.dlic.rest.validation.AbstractConfigurationValidator;
import com.floragunn.searchguard.dlic.rest.validation.LicenseValidator;
import com.floragunn.searchguard.license.LicenseHelper;
import com.floragunn.searchguard.license.SearchGuardLicense;
import com.floragunn.searchguard.license.SearchGuardLicenseKey;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentType;

public class LicenseApiAction
extends AbstractApiAction {
    public static final String CONFIG_LICENSE_KEY = "searchguard.dynamic.license";

    protected LicenseApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, StaticSgConfig staticSgConfig, ClusterService cs, PrincipalExtractor principalExtractor, AuthorizationService authorizationService, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, ThreadPool threadPool, AuditLog auditLog, ConfigModificationValidators configModificationValidators) {
        super(settings, configPath, controller, client, adminDNs, cl, staticSgConfig, cs, principalExtractor, authorizationService, specialPrivilegesEvaluationContextProviderRegistry, threadPool, auditLog, configModificationValidators);
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_searchguard/api/license"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_searchguard/api/license"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/_searchguard/api/license"));
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.LICENSE;
    }

    @Override
    protected void handlePut(final RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        String plaintextLicense;
        String licenseString = content.getAsString("sg_license");
        if (licenseString == null || licenseString.length() == 0) {
            this.badRequestResponse(channel, "License must not be null.");
            return;
        }
        try {
            plaintextLicense = LicenseHelper.validateLicense((String)licenseString);
        }
        catch (Exception e) {
            this.log.error("Could not decode license {} due to", (Object)licenseString, (Object)e);
            this.badRequestResponse(channel, "License could not be decoded due to: " + e.getMessage());
            return;
        }
        SearchGuardLicense license = new SearchGuardLicense(XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (String)plaintextLicense, (boolean)true));
        license.dynamicValidate(this.cs);
        if (!license.isValid() && !this.acceptInvalidLicense.booleanValue()) {
            this.badRequestResponse(channel, "License invalid due to: " + String.join((CharSequence)",", license.getMsgs()));
            return;
        }
        ValidationResult key = SearchGuardLicenseKey.parse((DocNode)DocNode.of((String)"key", (Object)licenseString), null);
        try {
            SgDynamicConfiguration newConfig = SgDynamicConfiguration.of((CType)CType.LICENSE_KEY, (String)"default", (Object)((SearchGuardLicenseKey)key.get()));
            this.saveAnUpdateConfigs(client, request, CType.LICENSE_KEY, newConfig, new AbstractApiAction.OnSucessActionListener<DocWriteResponse>(channel){

                public void onResponse(DocWriteResponse response) {
                    LicenseApiAction.this.successResponse(channel, "License updated.");
                }
            });
        }
        catch (ConfigValidationException e) {
            this.badRequestResponse(channel, "License invalid due to: " + e.getValidationErrors());
            return;
        }
    }

    protected void handlePost(RestChannel channel, RestRequest request, Client client, Settings.Builder additionalSettings) throws IOException {
        this.notImplemented(channel, RestRequest.Method.POST);
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new LicenseValidator(request, ref, this.settings, param);
    }

    @Override
    protected String getResourceName() {
        return null;
    }

    @Override
    protected CType<?> getConfigName() {
        return CType.LICENSE_KEY;
    }
}

