/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.ldap;

import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.enterprise.auth.ldap.LDAP;
import com.floragunn.searchsupport.PrivilegedCode;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Count;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.google.common.primitives.Ints;
import com.unboundid.ldap.sdk.AggregateLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.EXTERNALBindRequest;
import com.unboundid.ldap.sdk.FailoverServerSet;
import com.unboundid.ldap.sdk.FastestConnectServerSet;
import com.unboundid.ldap.sdk.FewestConnectionsServerSet;
import com.unboundid.ldap.sdk.GetEntryLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.PruneUnneededConnectionsLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.RoundRobinServerSet;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.StartTLSPostConnectProcessor;
import com.unboundid.util.ssl.HostNameSSLSocketVerifier;
import com.unboundid.util.ssl.SSLSocketVerifier;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.net.SocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LDAPConnectionManager
implements Closeable,
ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(LDAPConnectionManager.class);
    private final LDAPConnectionPool pool;
    private final TLSConfig tlsConfig;
    private final int poolMinSize;
    private final int poolMaxSize;
    private final ConnectionStrategy connectionStrategy;
    private final ComponentState componentState = new ComponentState(0, null, "ldap_connection_pool", LDAPConnectionManager.class);

    public LDAPConnectionManager(DocNode config, Parser.Context context) throws ConfigValidationException {
        boolean createIfNecessary;
        long maxWaitTimeMillis;
        Duration responseTimeout;
        Duration connectTimeout;
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(config, validationErrors, context);
        this.tlsConfig = (TLSConfig)vNode.get("tls").by(TLSConfig::parseInclStartTlsSupport);
        ImmutableList ldapHosts = vNode.get("hosts").required().asList().ofStrings();
        this.connectionStrategy = (ConnectionStrategy)vNode.get("connection_strategy").withDefault((Enum)ConnectionStrategy.ROUNDROBIN).asEnum(ConnectionStrategy.class);
        String bindDn = vNode.get("bind_dn").asString();
        String password = vNode.get("password").asString();
        Object bindRequest = bindDn != null && password != null && password.length() > 0 ? new SimpleBindRequest(bindDn, password) : (this.tlsConfig != null && this.tlsConfig.getClientCertAuthConfig() != null ? new EXTERNALBindRequest() : new SimpleBindRequest());
        LDAPConnectionOptions opts = new LDAPConnectionOptions();
        if (this.tlsConfig != null && this.tlsConfig.isHostnameVerificationEnabled()) {
            opts.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(false));
        }
        if ((connectTimeout = vNode.get("connect_timeout").asDuration()) != null) {
            opts.setConnectTimeoutMillis((int)connectTimeout.toMillis());
        }
        if ((responseTimeout = vNode.get("response_timeout").asDuration()) != null) {
            opts.setResponseTimeoutMillis(responseTimeout.toMillis());
        }
        opts.setFollowReferrals(true);
        this.poolMinSize = vNode.get("connection_pool.min_size").withDefault((Number)3).asInt();
        this.poolMaxSize = vNode.get("connection_pool.max_size").withDefault((Number)10).asInt();
        boolean blocking = vNode.get("connection_pool.blocking").withDefault(false).asBoolean();
        if (blocking) {
            maxWaitTimeMillis = Long.MAX_VALUE;
            createIfNecessary = false;
        } else {
            maxWaitTimeMillis = 0L;
            createIfNecessary = true;
        }
        LDAPConnectionPoolHealthCheck healthChecks = (LDAPConnectionPoolHealthCheck)vNode.get("connection_pool").by(n -> this.getHealthChecks((DocNode)n));
        Duration healthCheckInterval = vNode.get("connection_pool.health_check_interval").asDuration();
        validationErrors.throwExceptionForPresentErrors();
        if (context.isExternalResourceCreationEnabled()) {
            try {
                this.pool = (LDAPConnectionPool)PrivilegedCode.execute(() -> this.lambda$new$1((List)ldapHosts, opts, (BindRequest)bindRequest), LDAPException.class);
            }
            catch (LDAPException e) {
                log.error("Error while creating pool", (Throwable)e);
                throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
            }
            this.pool.setCreateIfNecessary(createIfNecessary);
            this.pool.setMaxWaitTimeMillis(maxWaitTimeMillis);
            if (healthChecks != null) {
                this.pool.setHealthCheck(healthChecks);
                if (healthCheckInterval != null) {
                    this.pool.setHealthCheckIntervalMillis(healthCheckInterval.toMillis());
                }
            }
            this.componentState.setConfigProperty("min_size", (Object)this.poolMinSize);
            this.componentState.setConfigProperty("max_size", (Object)this.poolMaxSize);
            this.componentState.addMetrics("current_available_connections", (Measurement)new Count.Live(() -> this.pool.getCurrentAvailableConnections()));
            this.componentState.addMetrics("connections_closed_defunct", (Measurement)new Count.Live(() -> this.pool.getConnectionPoolStatistics().getNumConnectionsClosedDefunct()));
            this.componentState.addMetrics("connections_closed_expired", (Measurement)new Count.Live(() -> this.pool.getConnectionPoolStatistics().getNumConnectionsClosedExpired()));
            this.componentState.addMetrics("connections_closed_unneeded", (Measurement)new Count.Live(() -> this.pool.getConnectionPoolStatistics().getNumConnectionsClosedUnneeded()));
            this.componentState.addMetrics("failed_checkouts", (Measurement)new Count.Live(() -> this.pool.getConnectionPoolStatistics().getNumFailedCheckouts()));
            this.componentState.addMetrics("failed_connection_attempts", (Measurement)new Count.Live(() -> this.pool.getConnectionPoolStatistics().getNumFailedConnectionAttempts()));
            this.componentState.addMetrics("released_back_to_pool", (Measurement)new Count.Live(() -> this.pool.getConnectionPoolStatistics().getNumReleasedValid()));
            this.componentState.addMetrics("successful_checkouts_from_pool", (Measurement)new Count.Live(() -> this.pool.getConnectionPoolStatistics().getNumSuccessfulCheckouts()));
            this.componentState.addMetrics("successful_checkouts_from_pool_after_wait", (Measurement)new Count.Live(() -> this.pool.getConnectionPoolStatistics().getNumSuccessfulCheckoutsAfterWaiting()));
            this.componentState.addMetrics("successful_checkouts_from_pool_without_wait", (Measurement)new Count.Live(() -> this.pool.getConnectionPoolStatistics().getNumSuccessfulCheckoutsWithoutWaiting()));
            this.componentState.addMetrics("successful_checkouts_new_connection", (Measurement)new Count.Live(() -> this.pool.getConnectionPoolStatistics().getNumSuccessfulCheckoutsNewConnection()));
            this.componentState.addMetrics("successful_connection_attempts", (Measurement)new Count.Live(() -> this.pool.getConnectionPoolStatistics().getNumSuccessfulConnectionAttempts()));
            this.componentState.setInitialized();
        } else {
            this.pool = null;
        }
    }

    private LDAPConnectionPoolHealthCheck getHealthChecks(DocNode config) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(config, validationErrors);
        ArrayList<Object> healthChecks = new ArrayList<Object>();
        boolean validationEnabled = vNode.get("validation.enabled").withDefault(false).asBoolean();
        String entryDN = vNode.get("validation.dn").asString();
        long maxResponseTime = vNode.get("validation.max_response_time").withDefault((Number)30000L).asLong();
        boolean invokeOnCreate = vNode.get("validation.on_create").withDefault(false).asBoolean();
        boolean invokeAfterAuthentication = vNode.get("validation.after_authentication").withDefault(false).asBoolean();
        boolean invokeOnCheckout = vNode.get("validation.on_checkout").withDefault(false).asBoolean();
        boolean invokeOnRelease = vNode.get("validation.on_release").withDefault(false).asBoolean();
        boolean invokeForBackgroundChecks = vNode.get("validation.for_background_checks").withDefault(true).asBoolean();
        boolean invokeOnException = vNode.get("validation.on_exception").withDefault(false).asBoolean();
        if (validationEnabled) {
            healthChecks.add(new GetEntryLDAPConnectionPoolHealthCheck(entryDN, maxResponseTime, invokeOnCreate, invokeAfterAuthentication, invokeOnCheckout, invokeOnRelease, invokeForBackgroundChecks, invokeOnException));
        }
        boolean pruningEnabled = vNode.get("pruning.enabled").withDefault(false).asBoolean();
        int minAvailableConnections = vNode.get("pruning.min_available_connections").withDefault((Number)this.poolMaxSize).asInt();
        long minDurationMillisExceedingMinAvailableConnections = vNode.get("pruning.min_duration_millis_exceeding_min_available_connections").withDefault((Number)0L).asLong();
        if (pruningEnabled) {
            healthChecks.add(new PruneUnneededConnectionsLDAPConnectionPoolHealthCheck(minAvailableConnections, minDurationMillisExceedingMinAvailableConnections));
        }
        validationErrors.throwExceptionForPresentErrors();
        if (healthChecks.size() == 1) {
            return (LDAPConnectionPoolHealthCheck)healthChecks.get(0);
        }
        if (healthChecks.size() > 1) {
            return new AggregateLDAPConnectionPoolHealthCheck(healthChecks);
        }
        return null;
    }

    private ServerSet createServerSet(Collection<String> ldapStrings, LDAPConnectionOptions opts) throws LDAPException {
        ArrayList<String> ldapHosts = new ArrayList<String>();
        ArrayList<Integer> ldapPorts = new ArrayList<Integer>();
        for (String ldapString : ldapStrings) {
            String[] split;
            int port;
            if (ldapString == null || (ldapString = ldapString.trim()).isEmpty()) continue;
            int n = port = this.tlsConfig != null ? 636 : 389;
            if (ldapString.startsWith("ldap://")) {
                ldapString = ldapString.replace("ldap://", "");
            }
            if (ldapString.startsWith("ldaps://")) {
                ldapString = ldapString.replace("ldaps://", "");
                port = 636;
            }
            if ((split = ldapString.split(":")).length > 1) {
                port = Integer.parseInt(split[1]);
            }
            ldapHosts.add(split[0]);
            ldapPorts.add(port);
        }
        if (this.tlsConfig != null) {
            if (!this.tlsConfig.isStartTlsEnabled()) {
                return this.newServerSetImpl(ldapHosts.toArray(new String[0]), Ints.toArray(ldapPorts), this.tlsConfig.getRestrictedSSLSocketFactory(), opts, null, null);
            }
            return this.newServerSetImpl(ldapHosts.toArray(new String[0]), Ints.toArray(ldapPorts), null, opts, null, (PostConnectProcessor)new StartTLSPostConnectProcessor(this.tlsConfig.getRestrictedSSLSocketFactory()));
        }
        return this.newServerSetImpl(ldapHosts.toArray(new String[0]), Ints.toArray(ldapPorts), null, opts, null, null);
    }

    private ServerSet newServerSetImpl(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, BindRequest bindRequest, PostConnectProcessor postConnectProcessor) throws LDAPException {
        switch (this.connectionStrategy) {
            case FAILOVER: {
                return new PrivilegedServerSet((ServerSet)new FailoverServerSet(addresses, ports, socketFactory, connectionOptions, bindRequest, postConnectProcessor));
            }
            case FASTEST: {
                return new PrivilegedServerSet((ServerSet)new FastestConnectServerSet(addresses, ports, socketFactory, connectionOptions, bindRequest, postConnectProcessor));
            }
            case FEWEST: {
                return new PrivilegedServerSet((ServerSet)new FewestConnectionsServerSet(addresses, ports, socketFactory, connectionOptions, bindRequest, postConnectProcessor));
            }
            case ROUNDROBIN: {
                return new PrivilegedServerSet((ServerSet)new RoundRobinServerSet(addresses, ports, socketFactory, connectionOptions, bindRequest, postConnectProcessor));
            }
        }
        throw new RuntimeException("Unexpected connectionStrategy " + this.connectionStrategy);
    }

    public LDAPConnection getConnection() throws AuthenticatorUnavailableException {
        try {
            return this.pool.getConnection();
        }
        catch (LDAPException e) {
            throw new AuthenticatorUnavailableException("Error while creating connection to LDAP server", (Throwable)e).details(LDAP.getDetailsFrom(e));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.pool != null) {
            this.pool.close();
        }
    }

    public LDAPConnectionPool getPool() {
        return this.pool;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    private /* synthetic */ LDAPConnectionPool lambda$new$1(List ldapHosts, LDAPConnectionOptions opts, BindRequest bindRequest) throws LDAPException {
        return new LDAPConnectionPool(this.createServerSet(ldapHosts, opts), bindRequest, this.poolMinSize, this.poolMaxSize, null, false);
    }

    public static enum ConnectionStrategy {
        FEWEST,
        FAILOVER,
        FASTEST,
        ROUNDROBIN;

    }

    static class PrivilegedServerSet
    extends ServerSet {
        private final ServerSet delegate;

        public PrivilegedServerSet(ServerSet delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        public boolean includesAuthentication() {
            return this.delegate.includesAuthentication();
        }

        public boolean includesPostConnectProcessing() {
            return this.delegate.includesPostConnectProcessing();
        }

        public LDAPConnection getConnection() throws LDAPException {
            return (LDAPConnection)PrivilegedCode.execute(() -> this.delegate.getConnection(), LDAPException.class);
        }

        public LDAPConnection getConnection(LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
            return (LDAPConnection)PrivilegedCode.execute(() -> this.delegate.getConnection(healthCheck), LDAPException.class);
        }

        public void toString(StringBuilder buffer) {
            this.delegate.toString(buffer);
            buffer.append("(wrapped by PrivilegedServerSet)");
        }
    }
}

