/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken.update;

import com.floragunn.searchguard.authtoken.AuthToken;
import com.floragunn.searchguard.authtoken.AuthTokenService;
import com.floragunn.searchguard.authtoken.update.PushAuthTokenUpdateNodeResponse;
import com.floragunn.searchguard.authtoken.update.PushAuthTokenUpdateRequest;
import com.floragunn.searchguard.authtoken.update.PushAuthTokenUpdateResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportPushAuthTokenUpdateAction
extends TransportNodesAction<PushAuthTokenUpdateRequest, PushAuthTokenUpdateResponse, NodeRequest, PushAuthTokenUpdateNodeResponse, TransportPushAuthTokenUpdateAction> {
    private final AuthTokenService authTokenService;

    @Inject
    public TransportPushAuthTokenUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, AuthTokenService authTokenService) {
        super("cluster:admin/searchguard/auth_token/update/push", clusterService, transportService, actionFilters, NodeRequest::new, (Executor)threadPool.executor("management"));
        this.authTokenService = authTokenService;
    }

    protected PushAuthTokenUpdateNodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new PushAuthTokenUpdateNodeResponse(in);
    }

    protected PushAuthTokenUpdateResponse newResponse(PushAuthTokenUpdateRequest request, List<PushAuthTokenUpdateNodeResponse> responses, List<FailedNodeException> failures) {
        return new PushAuthTokenUpdateResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected PushAuthTokenUpdateNodeResponse nodeOperation(NodeRequest request, Task task) {
        String status = this.authTokenService.pushAuthTokenUpdate(new PushAuthTokenUpdateRequest(request.updatedToken, request.updateType, request.newHash));
        return new PushAuthTokenUpdateNodeResponse(this.clusterService.localNode(), status);
    }

    protected NodeRequest newNodeRequest(PushAuthTokenUpdateRequest request) {
        return new NodeRequest(request);
    }

    public static class NodeRequest
    extends TransportRequest {
        private AuthToken updatedToken;
        private PushAuthTokenUpdateRequest.UpdateType updateType;
        private long newHash;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.updatedToken = new AuthToken(in);
            this.updateType = (PushAuthTokenUpdateRequest.UpdateType)in.readEnum(PushAuthTokenUpdateRequest.UpdateType.class);
            this.newHash = in.readLong();
        }

        public NodeRequest(PushAuthTokenUpdateRequest request) {
            this.updatedToken = request.getUpdatedToken();
            this.updateType = request.getUpdateType();
            this.newHash = request.getNewHash();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.updatedToken.writeTo(out);
            out.writeEnum((Enum)this.updateType);
            out.writeLong(this.newHash);
        }
    }
}

