/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.dlic.rest.validation.AbstractConfigurationValidator;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Collections;
import org.apache.http.Header;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class RolesApiTest {
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().nodeSettings(new Object[]{"searchguard.restapi.roles_enabled.0", "sg_admin"}).resources("restapi").sslEnabled().enterpriseModulesEnabled().build();

    @Test
    public void testPutRole() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();){
            GenericRestClient.HttpResponse response = adminClient.putJson("_searchguard/api/roles/admin", FileHelper.loadFile((String)"restapi/simple_role.json"), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = adminClient.putJson("_searchguard/api/roles/lala", "{ \"cluster_permissions\": [\"*\"] }", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = adminClient.putJson("_searchguard/api/roles/empty", "{ \"cluster_permissions\": [] }", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = adminClient.putJson("_searchguard/api/roles/role_with_aliases_and_data_stream", FileHelper.loadFile((String)"restapi/simple_role_with_empty_aliases_and_data_streams.json"), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
        }
    }

    @Test
    public void testAllRolesNotContainMetaHeader() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = adminClient.get("_searchguard/api/roles", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertFalse((String)response.getBody(), (boolean)response.getBody().contains("_sg_meta"));
        }
    }

    @Test
    public void testPutDuplicateKeys() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = adminClient.putJson("_searchguard/api/roles/dup", "{ \"cluster_permissions\": [\"*\"], \"cluster_permissions\": [\"*\"] }", new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("is defined more than once"));
        }
    }

    @Test
    public void testPutUnknownKey() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = adminClient.putJson("_searchguard/api/roles/dup", "{ \"unknownkey\": [\"*\"], \"cluster_permissions\": [\"*\"] }", new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("invalid_keys"));
        }
    }

    @Test
    public void testPutInvalidJson() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = adminClient.putJson("_searchguard/api/roles/dup", "{ \"invalid\"::{{ [\"*\"], \"cluster_permissions\": [\"*\"] }", new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("Invalid JSON document"));
        }
    }

    @Test
    public void testRolesApi() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();){
            GenericRestClient.HttpResponse response = adminClient.get("_searchguard/api/roles", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.get("/_searchguard/api/roles/sg_role_starfleet", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            DocNode settings = response.getBodyAsDocNode();
            Assert.assertEquals((long)1L, (long)settings.size());
            response = adminClient.get("/_searchguard/api/roles/nothinghthere", new Header[0]);
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            response = adminClient.get("/_searchguard/api/roles/", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.get("/_searchguard/api/roles", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("\"cluster_permissions\":[\"*\"]"));
            Assert.assertFalse((boolean)response.getBody().contains("\"cluster_permissions\" : ["));
            response = adminClient.get("/_searchguard/api/roles?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertFalse((boolean)response.getBody().contains("\"cluster_permissions\":[\"*\"]"));
            Assert.assertTrue((boolean)response.getBody().contains("\"cluster_permissions\" : ["));
            response = adminClient.get("/_searchguard/api/roles/sg_internal", new Header[0]);
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            this.setupStarfleetIndex();
            this.addUserWithPassword("picard", "picard", new String[]{"starfleet", "captains"}, 201);
            this.checkReadAccess(200, "picard", "picard", "sf", 0);
            this.checkWriteAccess(200, "picard", "picard", "sf", 0);
            response = adminClient.delete("/_searchguard/api/roles/idonotexist", new Header[0]);
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            response = adminClient.delete("/_searchguard/api/roles/sg_transport_client", new Header[0]);
            Assert.assertEquals((long)403L, (long)response.getStatusCode());
            response = adminClient.delete("/_searchguard/api/roles/sg_internal", new Header[0]);
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            response = adminClient.delete("/_searchguard/api/roles/sg_role_starfleet_captains", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            this.checkWriteAccess(403, "picard", "picard", "sf", 1);
            this.checkWriteAccess(403, "picard", "picard", "sf", 0);
            response = adminClient.delete("/_searchguard/api/roles/sg_role_starfleet", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            this.checkReadAccess(403, "picard", "picard", "sf", 0);
            this.checkWriteAccess(403, "picard", "picard", "sf", 0);
            response = adminClient.putJson("/_searchguard/api/roles/sg_role_starfleet", "", new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            settings = response.getBodyAsDocNode();
            Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.PAYLOAD_MANDATORY.getMessage(), (Object)settings.getAsString("reason"));
            response = adminClient.putJson("/_searchguard/api/roles/sg_role_starfleet", FileHelper.loadFile((String)"restapi/roles_not_parseable.json"), new Header[0]);
            settings = response.getBodyAsDocNode();
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.BODY_NOT_PARSEABLE.getMessage(), (Object)settings.getAsString("reason"));
            response = adminClient.putJson("/_searchguard/api/roles/sg_role_starfleet", FileHelper.loadFile((String)"restapi/roles_invalid_keys.json"), new Header[0]);
            settings = response.getBodyAsDocNode();
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.INVALID_CONFIGURATION.getMessage(), (Object)settings.getAsString("reason"));
            Assert.assertTrue((boolean)settings.getAsNode("invalid_keys").getAsString("keys").contains("indexx_permissions"));
            Assert.assertTrue((boolean)settings.getAsNode("invalid_keys").getAsString("keys").contains("kluster_permissions"));
            response = adminClient.putJson("/_searchguard/api/roles/sg_role_starfleet", FileHelper.loadFile((String)"restapi/roles_wrong_datatype.json"), new Header[0]);
            settings = response.getBodyAsDocNode();
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.WRONG_DATATYPE.getMessage(), (Object)settings.getAsString("reason"));
            Assert.assertTrue((boolean)settings.getAsString("cluster_permissions").equals("Array expected"));
            response = adminClient.putJson("/_searchguard/api/roles/sg_transport_client", FileHelper.loadFile((String)"restapi/roles_captains.json"), new Header[0]);
            Assert.assertEquals((long)403L, (long)response.getStatusCode());
            response = adminClient.putJson("/_searchguard/api/roles/sg_internal", FileHelper.loadFile((String)"restapi/roles_captains.json"), new Header[0]);
            Assert.assertEquals((long)403L, (long)response.getStatusCode());
            response = adminClient.putJson("/_searchguard/api/roles/sg_role_starfleet", FileHelper.loadFile((String)"restapi/roles_starfleet.json"), new Header[0]);
            Assert.assertEquals((long)201L, (long)response.getStatusCode());
            this.checkReadAccess(200, "picard", "picard", "sf", 0);
            this.checkWriteAccess(200, "picard", "picard", "sf", 0);
            response = adminClient.putJson("/_searchguard/api/roles/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/roles_captains.json"), new Header[0]);
            Assert.assertEquals((long)201L, (long)response.getStatusCode());
            this.checkReadAccess(200, "picard", "picard", "sf", 0);
            this.checkWriteAccess(200, "picard", "picard", "sf", 0);
            response = adminClient.putJson("/_searchguard/api/roles/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/roles_complete_invalid.json"), new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            response = adminClient.putJson("/_searchguard/api/roles/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/roles_multiple_2.json"), new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            response = adminClient.putJson("/_searchguard/api/roles/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/roles_captains_tenants.json"), new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            settings = response.getBodyAsDocNode();
            Assert.assertEquals((long)2L, (long)settings.size());
            Assert.assertEquals((Object)settings.get("status"), (Object)"OK");
            response = adminClient.get("/_searchguard/api/roles/sg_role_starfleet_captains", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            settings = response.getBodyAsDocNode();
            Assert.assertEquals((long)1L, (long)settings.size());
            Assert.assertEquals((Object)((DocNode)((DocNode)settings.getAsNode("sg_role_starfleet_captains").getAsListOfNodes("tenant_permissions").get(1)).getAsListOfNodes("tenant_patterns").get(0)).toString(), (Object)"tenant1");
            Assert.assertEquals((Object)((DocNode)((DocNode)settings.getAsNode("sg_role_starfleet_captains").getAsListOfNodes("tenant_permissions").get(1)).getAsListOfNodes("allowed_actions").get(0)).toString(), (Object)"SGS_KIBANA_ALL_READ");
            Assert.assertEquals((Object)((DocNode)((DocNode)settings.getAsNode("sg_role_starfleet_captains").getAsListOfNodes("tenant_permissions").get(0)).getAsListOfNodes("tenant_patterns").get(0)).toString(), (Object)"tenant2");
            Assert.assertEquals((Object)((DocNode)((DocNode)settings.getAsNode("sg_role_starfleet_captains").getAsListOfNodes("tenant_permissions").get(0)).getAsListOfNodes("allowed_actions").get(0)).toString(), (Object)"SGS_KIBANA_ALL_WRITE");
            response = adminClient.putJson("/_searchguard/api/roles/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/roles_captains_tenants2.json"), new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            settings = response.getBodyAsDocNode();
            Assert.assertEquals((long)2L, (long)settings.size());
            Assert.assertEquals((Object)settings.get("status"), (Object)"OK");
            response = adminClient.get("/_searchguard/api/roles/sg_role_starfleet_captains", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            settings = response.getBodyAsDocNode();
            Assert.assertEquals((long)1L, (long)settings.size());
            Assert.assertEquals((Object)((DocNode)((DocNode)settings.getAsNode("sg_role_starfleet_captains").getAsListOfNodes("tenant_permissions").get(0)).getAsListOfNodes("tenant_patterns").get(0)).toString(), (Object)"tenant2");
            Assert.assertEquals((Object)((DocNode)((DocNode)settings.getAsNode("sg_role_starfleet_captains").getAsListOfNodes("tenant_permissions").get(0)).getAsListOfNodes("tenant_patterns").get(1)).toString(), (Object)"tenant4");
            Assert.assertEquals((Object)((DocNode)((DocNode)settings.getAsNode("sg_role_starfleet_captains").getAsListOfNodes("tenant_permissions").get(0)).getAsListOfNodes("allowed_actions").get(0)).toString(), (Object)"SGS_KIBANA_ALL_WRITE");
            Assert.assertEquals((Object)((DocNode)((DocNode)settings.getAsNode("sg_role_starfleet_captains").getAsListOfNodes("tenant_permissions").get(1)).getAsListOfNodes("tenant_patterns").get(0)).toString(), (Object)"tenant1");
            Assert.assertEquals((Object)((DocNode)((DocNode)settings.getAsNode("sg_role_starfleet_captains").getAsListOfNodes("tenant_permissions").get(1)).getAsListOfNodes("tenant_patterns").get(1)).toString(), (Object)"tenant3");
            Assert.assertEquals((Object)((DocNode)((DocNode)settings.getAsNode("sg_role_starfleet_captains").getAsListOfNodes("tenant_permissions").get(1)).getAsListOfNodes("allowed_actions").get(0)).toString(), (Object)"SGS_KIBANA_ALL_READ");
            response = adminClient.putJson("/_searchguard/api/roles/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/roles_captains_no_tenants.json"), new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            settings = response.getBodyAsDocNode();
            Assert.assertEquals((long)2L, (long)settings.size());
            Assert.assertEquals((Object)settings.get("status"), (Object)"OK");
            response = adminClient.get("/_searchguard/api/roles/sg_role_starfleet_captains", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            settings = response.getBodyAsDocNode();
            Assert.assertEquals((long)1L, (long)settings.size());
            Assert.assertFalse((boolean)((DocNode)settings.getAsNode("sg_role_starfleet_captains").getAsListOfNodes("cluster_permissions").get(0)).isNull());
            Assert.assertTrue((boolean)settings.getAsNode("sg_role_starfleet_captains").getAsListOfNodes("tenant_permissions").isEmpty());
            response = adminClient.putJson("/_searchguard/api/roles/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/roles_captains_tenants_malformed.json"), new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            settings = response.getBodyAsDocNode();
            Assert.assertEquals((Object)settings.get("status"), (Object)"error");
            Assert.assertEquals((Object)settings.get("reason"), (Object)AbstractConfigurationValidator.ErrorType.INVALID_CONFIGURATION.getMessage());
            response = adminClient.patch("/_searchguard/api/roles/imnothere", "[{ \"op\": \"add\", \"path\": \"/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]");
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/roles/sg_transport_client", "[{ \"op\": \"add\", \"path\": \"/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]");
            Assert.assertEquals((long)403L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/roles/sg_internal", "[{ \"op\": \"add\", \"path\": \"/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]");
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/roles/sg_role_starfleet", "[{ \"op\": \"add\", \"path\": \"/hidden\", \"value\": true }]");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().matches(".*\"invalid_keys\"\\s*:\\s*\\{\\s*\"keys\"\\s*:\\s*\"hidden\"\\s*\\}.*"));
            ImmutableList permissions = null;
            response = adminClient.patch("/_searchguard/api/roles", "[{ \"op\": \"add\", \"path\": \"/imnothere/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/roles", "[{ \"op\": \"add\", \"path\": \"/sg_transport_client/a\", \"value\": [ \"foo\", \"bar\" ] }]");
            Assert.assertEquals((long)403L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/roles", "[{ \"op\": \"add\", \"path\": \"/sg_internal/a\", \"value\": [ \"foo\", \"bar\" ] }]");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/roles", "[{ \"op\": \"remove\", \"path\": \"/sg_transport_client\" }]");
            Assert.assertEquals((long)403L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/roles", "[{ \"op\": \"remove\", \"path\": \"/sg_internal\"}]");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/roles", "[{ \"op\": \"add\", \"path\": \"/newnewnew\", \"value\": {  \"hidden\": true, \"index_permissions\" : [ {\"index_patterns\" : [ \"sf\" ],\"allowed_actions\" : [ \"READ\" ]}] }}]");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().matches(".*\"invalid_keys\"\\s*:\\s*\\{\\s*\"keys\"\\s*:\\s*\"hidden\"\\s*\\}.*"));
            response = adminClient.patch("/_searchguard/api/roles", "[{ \"op\": \"add\", \"path\": \"/bulknew1\", \"value\": {   \"index_permissions\" : [ {\"index_patterns\" : [ \"sf\" ],\"allowed_actions\" : [ \"READ\" ]}] }}]");
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.get("/_searchguard/api/roles/bulknew1", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            settings = response.getBodyAsDocNode();
            permissions = ((DocNode)settings.getAsNode("bulknew1").getAsListOfNodes("index_permissions").get(0)).getAsListOfStrings("allowed_actions");
            Assert.assertNotNull((Object)permissions);
            Assert.assertEquals((long)1L, (long)permissions.size());
            Assert.assertTrue((boolean)permissions.contains("READ"));
            response = adminClient.patch("/_searchguard/api/roles", "[{ \"op\": \"remove\", \"path\": \"/bulknew1\"}]");
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.get("/_searchguard/api/roles/bulknew1", new Header[0]);
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            response = adminClient.putJson("/_searchguard/api/roles/sg_field_mask_valid", FileHelper.loadFile((String)"restapi/roles_field_masks_valid.json"), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = adminClient.putJson("/_searchguard/api/roles/sg_field_mask_invalid", FileHelper.loadFile((String)"restapi/roles_field_masks_invalid.json"), new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
        }
    }

    @Test
    public void putRole_roleWhichAssignsPermsToNoExistentTenantsShouldBeRejected() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            String tenantName = "missing1";
            String roleName = "put_role_with_pattern_matching_no_tenant";
            DocNode role = DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", Collections.singletonList(tenantName + "*"))}));
            GenericRestClient.HttpResponse response = adminClient.putJson("_searchguard/api/roles/" + roleName, (Document)role);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("Tenant pattern: '" + tenantName + "*' does not match any tenant"));
            response = adminClient.putJson("/_searchguard/api/tenants/" + tenantName, (Document)DocNode.of((String)"description", (Object)"tenant"));
            Assert.assertEquals((long)201L, (long)response.getStatusCode());
            response = adminClient.putJson("_searchguard/api/roles/" + roleName, (Document)role);
            Assert.assertEquals((long)201L, (long)response.getStatusCode());
        }
    }

    @Test
    public void patchRole_roleWhichAssignsPermsToNoExistentTenantsShouldBeRejected() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();){
            String tenantName = "missing1";
            String roleName = "patch_role_with_pattern_matching_no_tenant";
            DocNode role = DocNode.of((String)"cluster_permissions", Collections.singletonList("MONITOR"));
            GenericRestClient.HttpResponse response = adminClient.putJson("/_searchguard/api/roles/" + roleName, (Document)role);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            DocNode singlePatch = DocNode.array((Object[])new Object[]{DocNode.of((String)"op", (Object)"add", (String)"path", (Object)"/tenant_permissions", (String)"value", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", Collections.singletonList(tenantName + "*"))}))});
            response = adminClient.patch("/_searchguard/api/roles/" + roleName, singlePatch.toJsonString());
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("Tenant pattern: '" + tenantName + "*' does not match any tenant"));
            DocNode patch = DocNode.array((Object[])new Object[]{DocNode.of((String)"op", (Object)"add", (String)"path", (Object)("/" + roleName + "2"), (String)"value", (Object)DocNode.of((String)"tenant_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"tenant_patterns", Collections.singletonList(tenantName + "*"))})))});
            response = adminClient.patch("/_searchguard/api/roles/", patch.toJsonString());
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("Tenant pattern: '" + tenantName + "*' does not match any tenant"));
            response = adminClient.putJson("/_searchguard/api/tenants/" + tenantName, (Document)DocNode.of((String)"description", (Object)"tenant"));
            Assert.assertEquals((long)201L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/roles/" + roleName, singlePatch.toJsonString());
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/roles/", patch.toJsonString());
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
        }
    }

    protected void setupStarfleetIndex() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            adminClient.put("sf");
            adminClient.putJson("sf/_doc/0", "{\"number\" : \"NCC-1701-D\"}", new Header[0]);
            adminClient.putJson("sf/_doc/0", "{\"some\" : \"value\"}", new Header[0]);
        }
    }

    protected void addUserWithPassword(String username, String password, int status) throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = adminClient.putJson("/_searchguard/api/internalusers/" + username, "{\"password\": \"" + password + "\"}", new Header[0]);
            Assert.assertEquals((long)status, (long)response.getStatusCode());
        }
    }

    protected void addUserWithPassword(String username, String password, String[] roles, int status) throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            String payload = "{\"password\": \"" + password + "\",\"backend_roles\": [";
            for (int i = 0; i < roles.length; ++i) {
                payload = payload + "\"" + roles[i] + "\"";
                if (i + 1 >= roles.length) continue;
                payload = payload + ",";
            }
            payload = payload + "]}";
            GenericRestClient.HttpResponse response = adminClient.putJson("/_searchguard/api/internalusers/" + username, payload, new Header[0]);
            Assert.assertEquals((long)status, (long)response.getStatusCode());
        }
    }

    protected String checkReadAccess(int status, String username, String password, String indexName, int id) throws Exception {
        try (GenericRestClient client = cluster.getRestClient(username, password, new Header[0]);){
            String action = indexName + "/_doc/" + id;
            GenericRestClient.HttpResponse response = client.get(action, new Header[0]);
            int returnedStatus = response.getStatusCode();
            Assert.assertEquals((long)status, (long)returnedStatus);
            String string = response.getBody();
            return string;
        }
    }

    protected String checkWriteAccess(int status, String username, String password, String indexName, int id) throws Exception {
        try (GenericRestClient client = cluster.getRestClient(username, password, new Header[0]);){
            String action = indexName + "/_doc/" + id;
            String payload = "{\"value\" : \"true\"}";
            GenericRestClient.HttpResponse response = client.putJson(action, payload, new Header[0]);
            int returnedStatus = response.getStatusCode();
            Assert.assertEquals((long)status, (long)returnedStatus);
            String string = response.getBody();
            return string;
        }
    }
}

