/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.dlic.rest.validation.AbstractConfigurationValidator;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.net.URLEncoder;
import java.util.List;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class UserApiTest {
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().nodeSettings(new Object[]{"searchguard.restapi.roles_enabled.0", "sg_admin"}).resources("restapi").sslEnabled().enterpriseModulesEnabled().build();

    @Test
    public void testSearchGuardRoles() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();){
            GenericRestClient.HttpResponse response = adminClient.get("_searchguard/api/" + CType.INTERNALUSERS.toLCString(), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/internalusers", "[{ \"op\": \"add\", \"path\": \"/newuser\", \"value\": {\"password\": \"newuser\", \"search_guard_roles\": [\"sg_all_access\"] } }]");
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            response = adminClient.get("/_searchguard/api/internalusers/newuser", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("\"search_guard_roles\":[\"sg_all_access\"]"));
            this.checkGeneralAccess(200, "newuser", "newuser");
        }
    }

    @Test
    public void testUserApi() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();){
            GenericRestClient.HttpResponse response = adminClient.get("_searchguard/api/" + CType.INTERNALUSERS.toLCString(), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Settings settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            Assert.assertTrue((String)response.getBody(), (settings.size() >= 20 ? 1 : 0) != 0);
            response = adminClient.get("/_searchguard/api/internalusers/admin", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            Assert.assertEquals((long)4L, (long)settings.size());
            Assert.assertEquals(null, (Object)settings.get("admin.hash"));
            response = adminClient.get("/_searchguard/api/internalusers/nothinghthere", new Header[0]);
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            response = adminClient.get("/_searchguard/api/internalusers/", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.get("/_searchguard/api/internalusers", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.putJson("/_searchguard/api/internalusers/", "{\"hash\": \"123\"}", new Header[0]);
            Assert.assertEquals((long)405L, (long)response.getStatusCode());
            response = adminClient.putJson("/_searchguard/api/internalusers/nagilum", "{some: \"thing\" asd  other: \"thing\"}", new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            Assert.assertEquals((Object)settings.get("reason"), (Object)AbstractConfigurationValidator.ErrorType.BODY_NOT_PARSEABLE.getMessage());
            response = adminClient.putJson("/_searchguard/api/internalusers/nagilum", "{some: \"thing\", other: \"thing\"}", new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            response = adminClient.putJson("/_searchguard/api/internalusers/nagilum", "{\"some\": \"thing\", \"other\": \"thing\"}", new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            Assert.assertEquals((Object)settings.get("reason"), (Object)AbstractConfigurationValidator.ErrorType.INVALID_CONFIGURATION.getMessage());
            Assert.assertTrue((boolean)settings.get("invalid_keys.keys").contains("some"));
            Assert.assertTrue((boolean)settings.get("invalid_keys.keys").contains("other"));
            response = adminClient.patch("/_searchguard/api/internalusers/imnothere", "[{ \"op\": \"add\", \"path\": \"/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]");
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/internalusers/sarek", "[{ \"op\": \"add\", \"path\": \"/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]");
            Assert.assertEquals((long)403L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/internalusers/q", "[{ \"op\": \"add\", \"path\": \"/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]");
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/internalusers/test", "[{ \"op\": \"add\", \"path\": \"/hidden\", \"value\": true }]");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().matches(".*\"invalid_keys\"\\s*:\\s*\\{\\s*\"keys\"\\s*:\\s*\"hidden\"\\s*\\}.*"));
            response = adminClient.patch("/_searchguard/api/internalusers/test", "[{ \"op\": \"add\", \"path\": \"/password\", \"value\": \"neu\" }]");
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            response = adminClient.get("/_searchguard/api/internalusers/test", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            Assert.assertFalse((boolean)settings.hasValue("test.password"));
            response = adminClient.patch("/_searchguard/api/internalusers", "[{ \"op\": \"add\", \"path\": \"/imnothere/a\", \"value\": [ \"foo\", \"bar\" ] }]");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/internalusers", "[{ \"op\": \"add\", \"path\": \"/sarek/a\", \"value\": [ \"foo\", \"bar\" ] }]");
            Assert.assertEquals((long)403L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/internalusers", "[{ \"op\": \"add\", \"path\": \"/q/a\", \"value\": [ \"foo\", \"bar\" ] }]");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/internalusers", "[{ \"op\": \"add\", \"path\": \"/test/hidden\", \"value\": true }]");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().matches(".*\"invalid_keys\"\\s*:\\s*\\{\\s*\"keys\"\\s*:\\s*\"hidden\"\\s*\\}.*"));
            response = adminClient.patch("/_searchguard/api/internalusers", "[{ \"op\": \"add\", \"path\": \"/bulknew1\", \"value\": {\"password\": \"bla\", \"backend_roles\": [\"vulcan\"] } }]");
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.get("/_searchguard/api/internalusers/bulknew1", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            Assert.assertFalse((boolean)settings.hasValue("bulknew1.password"));
            List roles = settings.getAsList("bulknew1.backend_roles");
            Assert.assertEquals((long)1L, (long)roles.size());
            Assert.assertTrue((boolean)roles.contains("vulcan"));
            this.checkGeneralAccess(401, "nagilum", "nagilum");
            this.addUserWithHash(adminClient, "sarek", "$2a$12$n5nubfWATfQjSYHiWtUyeOxMIxFInUHOAx8VMmGmxFNPGpaBmeB.m", 403);
            this.addUserWithHash(adminClient, "q", "$2a$12$n5nubfWATfQjSYHiWtUyeOxMIxFInUHOAx8VMmGmxFNPGpaBmeB.m", 403);
            this.addUserWithHash(adminClient, "nagilum", "$2a$12$n5nubfWATfQjSYHiWtUyeOxMIxFInUHOAx8VMmGmxFNPGpaBmeB.m", 201);
            this.checkGeneralAccess(200, "nagilum", "nagilum");
            response = adminClient.delete("/_searchguard/api/internalusers", new Header[0]);
            Assert.assertEquals((long)405L, (long)response.getStatusCode());
            response = adminClient.delete("/_searchguard/api/internalusers/picard", new Header[0]);
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            response = adminClient.delete("/_searchguard/api/internalusers/sarek", new Header[0]);
            Assert.assertEquals((long)403L, (long)response.getStatusCode());
            response = adminClient.delete("/_searchguard/api/internalusers/q", new Header[0]);
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            adminClient.delete("/_searchguard/api/internalusers/nagilum", new Header[0]);
            this.checkGeneralAccess(401, "nagilum", "nagilum");
            this.addUserWithPassword(adminClient, "nagilum", "correctpassword", 201);
            this.checkGeneralAccess(401, "nagilum", "wrongpassword");
            this.checkGeneralAccess(200, "nagilum", "correctpassword");
            adminClient.delete("/_searchguard/api/internalusers/nagilum", new Header[0]);
            this.addUserWithoutPasswordOrHash(adminClient, "nagilum", new String[]{"starfleet"}, 400);
            this.addUserWithHash(adminClient, "nagilum", "$2a$12$n5nubfWATfQjSYHiWtUyeOxMIxFInUHOAx8VMmGmxFNPGpaBmeB.m", 201);
            this.addUserWithoutPasswordOrHash(adminClient, "nagilum", new String[]{"starfleet"}, 200);
            response = adminClient.get("/_searchguard/api/internalusers/nagilum", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            Assert.assertNull((Object)settings.get("nagilum.hash"));
            this.setupStarfleetIndex();
            response = adminClient.putJson("/_searchguard/api/internalusers/picard", FileHelper.loadFile((String)"restapi/users_wrong_datatypes.json"), new Header[0]);
            settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.WRONG_DATATYPE.getMessage(), (Object)settings.get("reason"));
            Assert.assertTrue((boolean)settings.get("backend_roles").equals("Array expected"));
            response = adminClient.putJson("/_searchguard/api/internalusers/picard", FileHelper.loadFile((String)"restapi/users_wrong_datatypes.json"), new Header[0]);
            settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.WRONG_DATATYPE.getMessage(), (Object)settings.get("reason"));
            Assert.assertTrue((boolean)settings.get("backend_roles").equals("Array expected"));
            response = adminClient.putJson("/_searchguard/api/internalusers/picard", FileHelper.loadFile((String)"restapi/users_wrong_datatypes2.json"), new Header[0]);
            settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.WRONG_DATATYPE.getMessage(), (Object)settings.get("reason"));
            Assert.assertTrue((boolean)settings.get("password").equals("String expected"));
            Assert.assertTrue((settings.get("backend_roles") == null ? 1 : 0) != 0);
            response = adminClient.putJson("/_searchguard/api/internalusers/picard", FileHelper.loadFile((String)"restapi/users_wrong_datatypes3.json"), new Header[0]);
            settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.WRONG_DATATYPE.getMessage(), (Object)settings.get("reason"));
            Assert.assertTrue((boolean)settings.get("backend_roles").equals("Array expected"));
            this.addUserWithPassword(adminClient, "picard", "picard", 201);
            this.checkGeneralAccess(403, "picard", "picard");
            this.checkReadAccess(403, "picard", "picard", "sf", 0);
            this.addUserWithPassword(adminClient, "picard", "picard", new String[]{"starfleet"}, 200);
            this.checkReadAccess(200, "picard", "picard", "sf", 0);
            this.checkWriteAccess(403, "picard", "picard", "sf", 1);
            this.addUserWithPassword(adminClient, "picard", "picard", new String[]{"starfleet", "captains"}, 200);
            this.checkReadAccess(200, "picard", "picard", "sf", 0);
            this.checkWriteAccess(201, "picard", "picard", "sf", 1);
            response = adminClient.get("/_searchguard/api/internalusers/picard", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
            Assert.assertNull((Object)settings.get("picard.hash"));
            roles = settings.getAsList("picard.backend_roles");
            Assert.assertNotNull((Object)roles);
            Assert.assertEquals((long)2L, (long)roles.size());
            Assert.assertTrue((boolean)roles.contains("starfleet"));
            Assert.assertTrue((boolean)roles.contains("captains"));
            this.addUserWithPassword(adminClient, "$1aAAAAAAAAC", "$1aAAAAAAAAC", 201);
            this.addUserWithPassword(adminClient, "abc", "abc", 201);
            response = adminClient.putJson("/_searchguard/api/internalusers/userwithtabs", "\t{\"hash\": \t \"123\"\t}  ", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
        }
    }

    @Test
    public void testPasswordRules() throws Exception {
        try (LocalCluster cluster = new LocalCluster.Builder().nodeSettings(new Object[]{"searchguard.restapi.roles_enabled.0", "sg_admin", "searchguard.restapi.password_validation_error_message", "xxx", "searchguard.restapi.password_validation_regex", "(?=.*[A-Z])(?=.*[^a-zA-Z\\\\d])(?=.*[0-9])(?=.*[a-z]).{8,}"}).resources("restapi").singleNode().sslEnabled().enterpriseModulesEnabled().start();
             GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();){
            GenericRestClient.HttpResponse response = adminClient.get("_searchguard/api/" + CType.INTERNALUSERS.toLCString(), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            this.addUserWithPassword(adminClient, "tooshoort", "123", 400);
            this.addUserWithPassword(adminClient, "tooshoort", "1234567", 400);
            this.addUserWithPassword(adminClient, "tooshoort", "1Aa%", 400);
            this.addUserWithPassword(adminClient, "no-nonnumeric", "123456789", 400);
            this.addUserWithPassword(adminClient, "no-uppercase", "a123456789", 400);
            this.addUserWithPassword(adminClient, "no-lowercase", "A123456789", 400);
            this.addUserWithPassword(adminClient, "ok1", "a%A123456789", 201);
            this.addUserWithPassword(adminClient, "ok2", "$aA123456789", 201);
            this.addUserWithPassword(adminClient, "ok3", "$Aa123456789", 201);
            this.addUserWithPassword(adminClient, "ok4", "$1aAAAAAAAAA", 201);
            response = adminClient.patch("/_searchguard/api/internalusers", "[{ \"op\": \"add\", \"path\": \"/ok4\", \"value\": {\"password\": \"bla\", \"backend_roles\": [\"vulcan\"] } }]");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            response = adminClient.patch("/_searchguard/api/internalusers", "[{ \"op\": \"replace\", \"path\": \"/ok4\", \"value\": {\"password\": \"bla\", \"backend_roles\": [\"vulcan\"] } }]");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            this.addUserWithPassword(adminClient, "ok4", "123", 400);
            response = adminClient.patch("/_searchguard/api/internalusers", "[{ \"op\": \"add\", \"path\": \"/ok4\", \"value\": {\"password\": \"$1aAAAAAAAAB\", \"backend_roles\": [\"vulcan\"] } }]");
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            this.addUserWithPassword(adminClient, "ok4", "$1aAAAAAAAAC", 200);
            response = adminClient.patch("/_searchguard/api/internalusers", "[{ \"op\": \"add\", \"path\": \"/$1aAAAAAAAAB\", \"value\": {\"password\": \"$1aAAAAAAAAB\", \"backend_roles\": [\"vulcan\"] } }]");
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            this.addUserWithPassword(adminClient, "$1aAAAAAAAAC", "$1aAAAAAAAAC", 400);
            this.addUserWithPassword(adminClient, "$1aAAAAAAAac", "$1aAAAAAAAAC", 400);
            this.addUserWithPassword(adminClient, URLEncoder.encode("$1aAAAAAAAac%", "UTF-8"), "$1aAAAAAAAAC%", 400);
            this.addUserWithPassword(adminClient, URLEncoder.encode("$1aAAAAAAAac%!=\"/\\;:test&~@^", "UTF-8").replace("+", "%2B"), "$1aAAAAAAAac%!=\\\"/\\\\;:test&~@^", 400);
            this.addUserWithPassword(adminClient, URLEncoder.encode("$1aAAAAAAAac%!=\"/\\;: test&", "UTF-8"), "$1aAAAAAAAac%!=\\\"/\\\\;: test&123", 201);
            response = adminClient.get("/_searchguard/api/internalusers/nothinghthere?pretty", new Header[0]);
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("NOT_FOUND"));
            String patchPayload = "[ { \"op\": \"add\", \"path\": \"/testuser1\",  \"value\": { \"password\": \"$aA123456789\", \"backend_roles\": [\"testrole1\"] } },{ \"op\": \"add\", \"path\": \"/testuser2\",  \"value\": { \"password\": \"testpassword2\", \"backend_roles\": [\"testrole2\"] } }]";
            response = adminClient.patch("/_searchguard/api/internalusers", patchPayload);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("error"));
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().contains("Invalid password"));
        }
    }

    @Test
    public void testUserApiWithDots() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();){
            GenericRestClient.HttpResponse response = adminClient.get("_searchguard/api/" + CType.INTERNALUSERS.toLCString(), new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            this.addUserWithPassword(adminClient, ".my.dotuser0", "$2a$12$n5nubfWATfQjSYHiWtUyeOxMIxFInUHOAx8VMmGmxFNPGpaBmeB.m", 201);
            this.addUserWithPassword(adminClient, ".my.dot.user0", "12345678", 201);
            this.addUserWithHash(adminClient, ".my.dotuser1", "$2a$12$n5nubfWATfQjSYHiWtUyeOxMIxFInUHOAx8VMmGmxFNPGpaBmeB.m", 201);
            this.addUserWithPassword(adminClient, ".my.dot.user2", "12345678", 201);
        }
    }

    @Test
    public void testUserApiNoPasswordChange() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();){
            this.addUserWithHash(adminClient, "user1", "$2a$12$n5nubfWATfQjSYHiWtUyeOxMIxFInUHOAx8VMmGmxFNPGpaBmeB.m", 201);
            GenericRestClient.HttpResponse response = adminClient.putJson("/_searchguard/api/internalusers/user1", "{\"hash\":\"$2a$12$n5nubfWATfQjSYHiWtUyeOxMIxFInUHOAx8VMmGmxFNPGpaBmeB.m\",\"password\":\"\",\"backend_roles\":[\"admin\",\"rolea\"]}", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.get("/_searchguard/api/internalusers/user1", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            this.addUserWithHash(adminClient, "user2", "$2a$12$n5nubfWATfQjSYHiWtUyeOxMIxFInUHOAx8VMmGmxFNPGpaBmeB.m", 201);
            response = adminClient.putJson("/_searchguard/api/internalusers/user2", "{\"password\":\"\",\"backend_roles\":[\"admin\",\"rolex\"]}", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.get("/_searchguard/api/internalusers/user2", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
        }
    }

    @Test
    public void testDontReturnSensitiveDataUponInvalidRequests() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();){
            this.addUserWithHash(adminClient, "user1", "$2a$12$n5nubfWATfQjSYHiWtUyeOxMIxFInUHOAx8VMmGmxFNPGpaBmeB.m", 201);
            GenericRestClient.HttpResponse response = adminClient.putJson("/_searchguard/api/internalusers/user1", "{\"12312\"---\"$2a$12$n5nubfWATfQjSYHiWtUyeOxMIxFInUHOAx8VMmGmxFNPGpaBmeB.m\",\"password\":\"secret\",\"xyz\":[\"admina\",\"rolea\"]}", new Header[0]);
            Assert.assertEquals((long)400L, (long)response.getStatusCode());
            Assert.assertThat((Object)response.getBody(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"secret")));
            Assert.assertThat((Object)response.getBody(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"password")));
        }
    }

    protected void checkGeneralAccess(int status, String username, String password) throws Exception {
        try (GenericRestClient client = cluster.getRestClient(username, password, new Header[0]);){
            Assert.assertEquals((long)status, (long)client.get("", new Header[0]).getStatusCode());
        }
    }

    protected void addUserWithPassword(GenericRestClient adminClient, String username, String password, int status) throws Exception {
        GenericRestClient.HttpResponse response = adminClient.putJson("/_searchguard/api/internalusers/" + username, "{\"password\": \"" + password + "\"}", new Header[0]);
        Assert.assertEquals((long)status, (long)response.getStatusCode());
    }

    protected void addUserWithPassword(GenericRestClient adminClient, String username, String password, String[] roles, int status) throws Exception {
        String payload = "{\"password\": \"" + password + "\",\"backend_roles\": [";
        for (int i = 0; i < roles.length; ++i) {
            payload = payload + "\"" + roles[i] + "\"";
            if (i + 1 >= roles.length) continue;
            payload = payload + ",";
        }
        payload = payload + "]}";
        GenericRestClient.HttpResponse response = adminClient.putJson("/_searchguard/api/internalusers/" + username, payload, new Header[0]);
        Assert.assertEquals((long)status, (long)response.getStatusCode());
    }

    protected void addUserWithHash(GenericRestClient adminClient, String username, String hash) throws Exception {
        this.addUserWithHash(adminClient, username, hash, 200);
    }

    protected void addUserWithHash(GenericRestClient adminClient, String username, String hash, int status) throws Exception {
        GenericRestClient.HttpResponse response = adminClient.putJson("/_searchguard/api/internalusers/" + username, "{\"hash\": \"" + hash + "\"}", new Header[0]);
        Assert.assertEquals((String)response.getBody(), (long)status, (long)response.getStatusCode());
    }

    protected void addUserWithoutPasswordOrHash(GenericRestClient adminClient, String username, String[] roles, int status) throws Exception {
        Object payload = "{ \"backend_roles\": [";
        for (int i = 0; i < roles.length; ++i) {
            payload = (String)payload + "\" " + roles[i] + " \"";
            if (i + 1 >= roles.length) continue;
            payload = (String)payload + ",";
        }
        payload = (String)payload + "]}";
        GenericRestClient.HttpResponse response = adminClient.putJson("/_searchguard/api/internalusers/" + username, (String)payload, new Header[0]);
        Assert.assertEquals((long)status, (long)response.getStatusCode());
    }

    protected void setupStarfleetIndex() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            adminClient.put("sf");
            adminClient.putJson("sf/_doc/0", "{\"number\" : \"NCC-1701-D\"}", new Header[0]);
            adminClient.putJson("sf/_doc/0", "{\"some\" : \"value\"}", new Header[0]);
        }
    }

    protected String checkReadAccess(int status, String username, String password, String indexName, int id) throws Exception {
        try (GenericRestClient client = cluster.getRestClient(username, password, new Header[0]);){
            String action = indexName + "/_doc/" + id;
            GenericRestClient.HttpResponse response = client.get(action, new Header[0]);
            int returnedStatus = response.getStatusCode();
            Assert.assertEquals((String)response.getBody(), (long)status, (long)returnedStatus);
            String string = response.getBody();
            return string;
        }
    }

    protected String checkWriteAccess(int status, String username, String password, String indexName, int id) throws Exception {
        try (GenericRestClient client = cluster.getRestClient(username, password, new Header[0]);){
            String action = indexName + "/_doc/" + id;
            String payload = "{\"value\" : \"true\"}";
            GenericRestClient.HttpResponse response = client.putJson(action, payload, new Header[0]);
            int returnedStatus = response.getStatusCode();
            Assert.assertEquals((String)response.getBody(), (long)status, (long)returnedStatus);
            String string = response.getBody();
            return string;
        }
    }
}

