/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.saml;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.enterprise.auth.saml.MockSamlIdpServer;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.google.common.collect.ImmutableMap;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SamlAuthenticatorIntegrationTest {
    protected static MockSamlIdpServer mockSamlIdpServer;
    public static LocalCluster cluster;
    private static String FRONTEND_BASE_URL;

    @BeforeClass
    public static void setUp() throws Exception {
        mockSamlIdpServer = new MockSamlIdpServer();
        mockSamlIdpServer.start();
        mockSamlIdpServer.setSignResponses(true);
        mockSamlIdpServer.loadSigningKeys("saml/kirk-keystore.jks", "kirk");
        mockSamlIdpServer.setAuthenticateUser("horst");
        mockSamlIdpServer.setAuthenticateUserRoles(Arrays.asList("SGS_KIBANA_USER"));
        mockSamlIdpServer.setEndpointQueryString(null);
        TestSgConfig testSgConfig = new TestSgConfig().resources("saml").frontendAuthc("default", new TestSgConfig.FrontendAuthc[]{new TestSgConfig.FrontendAuthc().authDomain(new TestSgConfig.FrontendAuthDomain("saml").label("SAML Label").config("user_mapping.roles.from", (Object)"saml_response.roles", new Object[]{"saml.idp.metadata_url", mockSamlIdpServer.getMetadataUri(), "saml.idp.entity_id", mockSamlIdpServer.getIdpEntityId()}))}).frontendAuthc("invalid", new TestSgConfig.FrontendAuthc[]{new TestSgConfig.FrontendAuthc().authDomain(new TestSgConfig.FrontendAuthDomain("saml").label("SAML Label").config("user_mapping.roles.from", (Object)"saml_response.roles", new Object[]{"saml.idp.metadata_url", mockSamlIdpServer.getMetadataUri(), "saml.idp.entity_id", "invalid"}))}).frontendAuthcDebug("invalid", true);
        cluster = new LocalCluster.Builder().sslEnabled().singleNode().resources("saml").enterpriseModulesEnabled().sgConfig(testSgConfig).embedded().start();
    }

    @AfterClass
    public static void tearDown() {
        if (mockSamlIdpServer != null) {
            try {
                mockSamlIdpServer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (cluster != null) {
            try {
                cluster.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cluster = null;
        }
    }

    @Test
    public void basic() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("kibanaserver", "kibanaserver", new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/auth/config?next_url=/abc/def&frontend_base_url=" + FRONTEND_BASE_URL, new Header[0]);
            String ssoLocation = ((DocNode)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").get(0)).getAsString("sso_location");
            String ssoContext = ((DocNode)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").get(0)).getAsString("sso_context");
            String id = ((DocNode)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").get(0)).getAsString("id");
            Assert.assertNotNull((String)response.getBody(), (Object)ssoLocation);
            String encodedSamlResponse = mockSamlIdpServer.handleSsoGetRequestURI(ssoLocation);
            response = client.postJson("/_searchguard/auth/session", (Map)ImmutableMap.of((Object)"method", (Object)"saml", (Object)"id", (Object)id, (Object)"saml_response", (Object)encodedSamlResponse, (Object)"sso_context", (Object)ssoContext, (Object)"frontend_base_url", (Object)FRONTEND_BASE_URL), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            String token = response.getBodyAsDocNode().getAsString("token");
            BasicHeader tokenAuth = new BasicHeader("Authorization", "Bearer " + token);
            try (GenericRestClient tokenClient = cluster.getRestClient(new Header[]{tokenAuth});){
                response = tokenClient.get("/_searchguard/auth/session", new Header[0]);
                String logoutAddress = response.getBodyAsDocNode().getAsString("sso_logout_url");
                Assert.assertNotNull((Object)logoutAddress);
            }
        }
    }

    @Test
    public void loginFailure() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("kibanaserver", "kibanaserver", new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/auth/config?next_url=/abc/def&frontend_base_url=" + FRONTEND_BASE_URL, new Header[0]);
            System.out.println(response.getBody());
            String ssoLocation = ((DocNode)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").get(0)).getAsString("sso_location");
            String ssoContext = ((DocNode)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").get(0)).getAsString("sso_context");
            String id = ((DocNode)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").get(0)).getAsString("id");
            Assert.assertNotNull((String)response.getBody(), (Object)ssoLocation);
            response = client.postJson("/_searchguard/auth/session", (Map)ImmutableMap.of((Object)"method", (Object)"saml", (Object)"id", (Object)id, (Object)"saml_response", (Object)"invalid", (Object)"sso_context", (Object)ssoContext, (Object)"frontend_base_url", (Object)FRONTEND_BASE_URL), new Header[0]);
            System.out.println(response.getBody());
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
        }
    }

    @Test
    public void invalidEntityId() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("kibanaserver", "kibanaserver", new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/auth/config?config_id=invalid&next_url=/abc/def&frontend_base_url=" + FRONTEND_BASE_URL, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (Object)"Could not find entity descriptor for invalid", (Object)((DocNode)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").get(0)).getAsString("message_body"));
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        FRONTEND_BASE_URL = "http://whereever";
    }
}

