/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.enterprise.auth.oidc.BadCredentialsException;
import com.floragunn.searchguard.enterprise.auth.oidc.KeyProvider;
import com.floragunn.searchguard.enterprise.auth.oidc.KeySetProvider;
import com.google.common.base.Strings;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelfRefreshingKeySet
implements KeyProvider {
    private static final Logger log = LogManager.getLogger(SelfRefreshingKeySet.class);
    private final KeySetProvider keySetProvider;
    private final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 10, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private volatile JsonWebKeys jsonWebKeys = new JsonWebKeys();
    private boolean refreshInProgress = false;
    private long refreshCount = 0L;
    private long queuedGetCount = 0L;
    private long recentRefreshCount = 0L;
    private long refreshTime = 0L;
    private Throwable lastRefreshFailure = null;
    private int requestTimeoutMs = 5000;
    private int queuedThreadTimeoutMs = 2500;
    private int refreshRateLimitTimeWindowMs = 10000;
    private int refreshRateLimitCount = 10;

    public SelfRefreshingKeySet(KeySetProvider refreshFunction) {
        this.keySetProvider = refreshFunction;
    }

    @Override
    public JsonWebKey getKey(String kid) throws AuthenticatorUnavailableException, BadCredentialsException {
        if (Strings.isNullOrEmpty((String)kid)) {
            return this.getKeyWithoutKeyId();
        }
        return this.getKeyWithKeyId(kid);
    }

    @Override
    public synchronized JsonWebKey getKeyAfterRefresh(String kid) throws AuthenticatorUnavailableException, BadCredentialsException {
        JsonWebKey result = this.getKeyAfterRefreshInternal(kid);
        if (result != null) {
            return result;
        }
        if (this.jsonWebKeys.getKeys().size() == 0) {
            throw new AuthenticatorUnavailableException("IdP configuration error", "No JWK are available from IdP");
        }
        throw new BadCredentialsException("JWT did not contain KID which is required if IdP provides multiple JWK");
    }

    private synchronized JsonWebKey getKeyAfterRefreshInternal(String kid) throws AuthenticatorUnavailableException {
        if (this.refreshInProgress) {
            return this.waitForRefreshToFinish(kid);
        }
        return this.performRefresh(kid);
    }

    private JsonWebKey getKeyWithoutKeyId() throws AuthenticatorUnavailableException, BadCredentialsException {
        List keys = this.jsonWebKeys.getKeys();
        if (keys == null || keys.size() == 0) {
            JsonWebKey result = this.getKeyWithRefresh(null);
            if (result != null) {
                return result;
            }
            throw new AuthenticatorUnavailableException("IdP configuration error", "No JWK are available from IdP");
        }
        if (keys.size() == 1) {
            return (JsonWebKey)keys.get(0);
        }
        JsonWebKey result = this.getKeyWithRefresh(null);
        if (result != null) {
            return result;
        }
        throw new BadCredentialsException("JWT did not contain KID which is required if IdP provides multiple JWK");
    }

    private JsonWebKey getKeyWithKeyId(String kid) throws AuthenticatorUnavailableException, BadCredentialsException {
        JsonWebKey result = this.jsonWebKeys.getKey(kid);
        if (result != null) {
            return result;
        }
        result = this.getKeyWithRefresh(kid);
        if (result == null) {
            throw new BadCredentialsException("Unknown kid " + kid);
        }
        return result;
    }

    private synchronized JsonWebKey getKeyWithRefresh(String kid) throws AuthenticatorUnavailableException {
        JsonWebKey result = this.getKeySimple(kid);
        if (result != null) {
            return result;
        }
        return this.getKeyAfterRefreshInternal(kid);
    }

    private JsonWebKey getKeySimple(String kid) {
        if (Strings.isNullOrEmpty((String)kid)) {
            List keys = this.jsonWebKeys.getKeys();
            if (keys != null && keys.size() == 1) {
                return (JsonWebKey)keys.get(0);
            }
            return null;
        }
        return this.jsonWebKeys.getKey(kid);
    }

    private synchronized JsonWebKey waitForRefreshToFinish(String kid) throws AuthenticatorUnavailableException {
        ++this.queuedGetCount;
        long currentRefreshCount = this.refreshCount;
        try {
            this.wait(this.queuedThreadTimeoutMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug((Object)e);
        }
        JsonWebKey result = this.getKeySimple(kid);
        if (result != null) {
            return result;
        }
        if (this.refreshInProgress && currentRefreshCount == this.refreshCount) {
            throw new AuthenticatorUnavailableException("IdP communication error", "Authentication backend timed out");
        }
        if (this.lastRefreshFailure != null) {
            throw new AuthenticatorUnavailableException("Authentication backend failed", this.lastRefreshFailure);
        }
        return null;
    }

    private synchronized JsonWebKey performRefresh(String kid) throws AuthenticatorUnavailableException {
        boolean recentRefresh;
        if (log.isDebugEnabled()) {
            log.debug("performRefresh({})", (Object)kid);
        }
        if (System.currentTimeMillis() - this.refreshTime < (long)this.refreshRateLimitTimeWindowMs) {
            ++this.recentRefreshCount;
            recentRefresh = true;
            if (this.recentRefreshCount > (long)this.refreshRateLimitCount) {
                throw new AuthenticatorUnavailableException("IdP refresh rate limit reached", "Too many unknown kids recently: " + this.recentRefreshCount);
            }
        } else {
            recentRefresh = false;
        }
        this.refreshInProgress = true;
        ++this.refreshCount;
        log.info("Performing refresh {}", (Object)this.refreshCount);
        long currentRefreshCount = this.refreshCount;
        try {
            Future<?> future = this.threadPoolExecutor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        JsonWebKeys newKeys = SelfRefreshingKeySet.this.keySetProvider.get();
                        if (newKeys == null) {
                            throw new RuntimeException("Refresh function " + SelfRefreshingKeySet.this.keySetProvider + " yielded null");
                        }
                        log.info("KeySetProvider finished");
                        SelfRefreshingKeySet selfRefreshingKeySet = SelfRefreshingKeySet.this;
                        synchronized (selfRefreshingKeySet) {
                            SelfRefreshingKeySet.this.jsonWebKeys = newKeys;
                            SelfRefreshingKeySet.this.refreshInProgress = false;
                            SelfRefreshingKeySet.this.lastRefreshFailure = null;
                            SelfRefreshingKeySet.this.notifyAll();
                        }
                    }
                    catch (Throwable e) {
                        SelfRefreshingKeySet selfRefreshingKeySet = SelfRefreshingKeySet.this;
                        synchronized (selfRefreshingKeySet) {
                            SelfRefreshingKeySet.this.lastRefreshFailure = e;
                            SelfRefreshingKeySet.this.refreshInProgress = false;
                            SelfRefreshingKeySet.this.notifyAll();
                        }
                        log.warn("KeySetProvider threw error", e);
                    }
                    finally {
                        if (!recentRefresh) {
                            SelfRefreshingKeySet.this.recentRefreshCount = 0L;
                            SelfRefreshingKeySet.this.refreshTime = System.currentTimeMillis();
                        }
                    }
                }
            });
            try {
                this.wait(this.requestTimeoutMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debug((Object)e);
            }
            JsonWebKey result = this.getKeySimple(kid);
            if (result != null) {
                JsonWebKey jsonWebKey = result;
                return jsonWebKey;
            }
            if (this.refreshInProgress && currentRefreshCount == this.refreshCount) {
                if (!future.isDone()) {
                    future.cancel(true);
                }
                this.lastRefreshFailure = new AuthenticatorUnavailableException("IdP communication error", "Authentication backend timed out");
                throw new AuthenticatorUnavailableException("IdP communication error", "Authentication backend timed out");
            }
            if (this.lastRefreshFailure != null) {
                throw new AuthenticatorUnavailableException("Authentication backend failed", this.lastRefreshFailure);
            }
            JsonWebKey jsonWebKey = null;
            return jsonWebKey;
        }
        catch (RejectedExecutionException e) {
            throw new AuthenticatorUnavailableException("IdP refresh rate limit reached", "Did not try to call authentication backend because of " + this.threadPoolExecutor.getActiveCount() + " pending threads", (Throwable)e);
        }
        finally {
            if (this.refreshInProgress && currentRefreshCount == this.refreshCount) {
                this.refreshInProgress = false;
                this.notifyAll();
            }
        }
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public void setRequestTimeoutMs(int requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public int getQueuedThreadTimeoutMs() {
        return this.queuedThreadTimeoutMs;
    }

    public void setQueuedThreadTimeoutMs(int queuedThreadTimeoutMs) {
        this.queuedThreadTimeoutMs = queuedThreadTimeoutMs;
    }

    public long getRefreshCount() {
        return this.refreshCount;
    }

    public long getQueuedGetCount() {
        return this.queuedGetCount;
    }

    public int getRefreshRateLimitTimeWindowMs() {
        return this.refreshRateLimitTimeWindowMs;
    }

    public void setRefreshRateLimitTimeWindowMs(int refreshRateLimitTimeWindowMs) {
        this.refreshRateLimitTimeWindowMs = refreshRateLimitTimeWindowMs;
    }

    public int getRefreshRateLimitCount() {
        return this.refreshRateLimitCount;
    }

    public void setRefreshRateLimitCount(int refreshRateLimitCount) {
        this.refreshRateLimitCount = refreshRateLimitCount;
    }
}

