/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.searchguard.authtoken.AuthTokenModule;
import com.floragunn.searchguard.authtoken.RequestedPrivileges;
import com.floragunn.searchguard.authtoken.api.CreateAuthTokenRequest;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestComponentTemplate;
import com.floragunn.searchguard.test.TestData;
import com.floragunn.searchguard.test.TestDataStream;
import com.floragunn.searchguard.test.TestIndexTemplate;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.util.Collections;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ToXContentObject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class AuthTokenDlsIntTest {
    static final String INDEX = "logs";
    static final String INDEX_ALIAS = "logs_alias";
    static final String DATA_STREAM = "ds_logs";
    static final int DOC_COUNT = 200;
    static final TestData TEST_DATA = TestData.documentCount((int)200).get();
    static final TestDataStream TEST_DATA_STREAM = new TestDataStream.Builder().name("ds_logs").documentCount(200).build();
    static final TestSgConfig.User ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("all_access").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"*"}).on(new String[]{"*"}).aliasPermissions(new String[]{"*"}).on(new String[]{"*"}).dataStreamPermissions(new String[]{"*"}).on(new String[]{"*"})});
    static final TestSgConfig.User DEPT_A_USER = new TestSgConfig.User("dept_a").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("dept_a").indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"prefix.dept.value", (Object)"dept_a")).on(new String[]{"logs"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User DEPT_D_USER = new TestSgConfig.User("dept_d").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("dept_d").indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_d")).on(new String[]{"logs"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User DEPT_D_VIA_ALIAS_USER = new TestSgConfig.User("dept_d_via_alias").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("dept_d_via_alias").aliasPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_d")).on(new String[]{"logs_alias"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User DEPT_D_DATA_STREAM_USER = new TestSgConfig.User("dept_d_ds").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("dept_d_ds").dataStreamPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_d")).on(new String[]{"ds_logs"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.User DEPT_D_TERMS_LOOKUP_USER = new TestSgConfig.User("dept_d_terms_lookup_user").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("dept_d").indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"terms", (Object)DocNode.of((String)"dept", (Object)DocNode.of((String)"index", (Object)"user_dept_terms_lookup", (String)"id", (Object)"${user.name}", (String)"path", (Object)"dept")))).on(new String[]{"logs"}).clusterPermissions(new String[]{"*"})});
    static final TestSgConfig.Role ROLE_WITH_DLS_FLS_FM_RULES_ON_INDEX = new TestSgConfig.Role("dls_fls_fm_role").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"SGS_READ"}).dls((Map)DocNode.of((String)"term.dept.value", (Object)"dept_d")).fls(new String[]{"source_ip", "dest_ip", "dept"}).maskedFields(new String[]{"dest_ip"}).on(new String[]{"logs"});
    static final TestSgConfig.User DLS_FLS_FM_USER = new TestSgConfig.User("dls_fls_fm").roles(new String[]{ROLE_WITH_DLS_FLS_FM_RULES_ON_INDEX.getName()});
    static final TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")});
    static final TestSgConfig.DlsFls DLSFLS = new TestSgConfig.DlsFls().metrics("detailed");
    static final TestSgConfig.AuthTokenService AUTH_TOKEN_SERVICE = new TestSgConfig.AuthTokenService().enabled(true).jwtSigningKeyHs512("eTDZjSqRD9Abhod9iqeGX_7o93a-eElTeXWAF6FmzQshmRIrPD-C9ET3pFjJ_IBrzmWIZDk8ig-X_PIyGmKsxNMsrU-0BNWF5gJq5xOp4rYTl8z66Tw9wr8tHLxLxgJqkLSuUCRBZvlZlQ7jNdhBBxgM-hdSSzsN1T33qdIwhrUeJ-KXI5yKUXHjoWFYb9tETbYQ4NvONowkCsXK_flp-E3F_OcKe_z5iVUszAV8QfCod1zhbya540kDejXCL6N_XMmhWJqum7UJ3hgf6DEtroPSnVpHt4iR5w9ArKK-IBgluPght03gNcoNqwz7p77TFbdOmUKF_PWy1bcdbaUoSg");
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().enterpriseModulesEnabled().authc(AUTHC).dlsFls(DLSFLS).roles(new TestSgConfig.Role[]{ROLE_WITH_DLS_FLS_FM_RULES_ON_INDEX}).indexTemplates(new TestIndexTemplate[]{new TestIndexTemplate("ds_test", new String[]{"ds_*"}).dataStream().composedOf(new TestComponentTemplate[]{TestComponentTemplate.DATA_STREAM_MINIMAL})}).dataStreams(new TestDataStream[]{TEST_DATA_STREAM}).authzDebug(true).authTokenService(AUTH_TOKEN_SERVICE).users(new TestSgConfig.User[]{ADMIN, DEPT_A_USER, DEPT_D_USER, DEPT_D_TERMS_LOOKUP_USER, DEPT_D_VIA_ALIAS_USER, DEPT_D_DATA_STREAM_USER, DLS_FLS_FM_USER}).resources(null).enableModule(AuthTokenModule.class).useExternalProcessCluster().build();

    @BeforeClass
    public static void setupTestData() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            TEST_DATA.createIndex(client, INDEX, Settings.builder().put("index.number_of_shards", 5).build());
            GenericRestClient.HttpResponse response = client.putJson("/user_dept_terms_lookup/_doc/dept_d_terms_lookup_user?refresh=true", (Document)DocNode.of((String)"dept", (Object)"dept_d"));
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isCreated());
            response = client.postJson("/_aliases", (Map)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"add", (Object)DocNode.of((String)"index", (Object)INDEX, (String)"alias", (Object)INDEX_ALIAS))})), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
        }
    }

    @Test
    public void get_authtoken() throws Exception {
        GenericRestClient.HttpResponse response;
        String token;
        TestData.TestDocument testDocumentA1 = TEST_DATA.anyDocumentForDepartment("dept_a_1");
        String documentIndexUriA1 = String.format("/%s/_doc/%s", INDEX, testDocumentA1.getId());
        TestData.TestDocument testDocumentD = TEST_DATA.anyDocumentForDepartment("dept_d");
        String documentIndexUriD = String.format("/%s/_doc/%s", INDEX, testDocumentD.getId());
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_USER, new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token");
            GenericRestClient.HttpResponse response2 = client.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            Assert.assertEquals((long)200L, (long)response2.getStatusCode());
            token = response2.getBodyAsDocNode().getAsString("token");
            Assert.assertNotNull((Object)token);
        }
        client = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
        try {
            GenericRestClient.HttpResponse response3 = client.get(documentIndexUriA1, new Header[0]);
            Assert.assertEquals((String)response3.getBody(), (long)404L, (long)response3.getStatusCode());
            response3 = client.get(documentIndexUriD, new Header[0]);
            Assert.assertEquals((String)response3.getBody(), (long)200L, (long)response3.getStatusCode());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        String documentAliasUriA1 = String.format("/%s/_doc/%s", INDEX_ALIAS, testDocumentA1.getId());
        String documentAliasUriD = String.format("/%s/_doc/%s", INDEX_ALIAS, testDocumentD.getId());
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_VIA_ALIAS_USER, new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"alias_permissions:\n- alias_patterns: '*'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token");
            GenericRestClient.HttpResponse response4 = client.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            Assert.assertEquals((long)200L, (long)response4.getStatusCode());
            token = response4.getBodyAsDocNode().getAsString("token");
            Assert.assertNotNull((Object)token);
        }
        client = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
        try {
            GenericRestClient.HttpResponse response5 = client.get(documentAliasUriA1, new Header[0]);
            Assert.assertEquals((String)response5.getBody(), (long)404L, (long)response5.getStatusCode());
            response5 = client.get(documentAliasUriD, new Header[0]);
            Assert.assertEquals((String)response5.getBody(), (long)200L, (long)response5.getStatusCode());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        String searchDataStreamA1 = String.format("{\"query\":{\"ids\":{ \"values\": [\"%s\"]}}}", testDocumentA1.getId());
        String searchDataStreamD = String.format("{\"query\":{\"ids\":{ \"values\": [ \"%s\"]}}}", testDocumentD.getId());
        String searchDataStreamUri = String.format("/%s/_search", DATA_STREAM);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DEPT_D_DATA_STREAM_USER, new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"data_stream_permissions:\n- data_stream_patterns: '*'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token");
            GenericRestClient.HttpResponse response6 = client.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            Assert.assertEquals((long)200L, (long)response6.getStatusCode());
            token = response6.getBodyAsDocNode().getAsString("token");
            Assert.assertNotNull((Object)token);
        }
        client = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
        try {
            response = client.postJson(searchDataStreamUri, searchDataStreamA1, new Header[0]);
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.hits.hits", (int)0));
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            response = client.postJson(searchDataStreamUri, searchDataStreamD, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.hits.hits", (int)1));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);
        try {
            response = client.get(documentIndexUriD, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            response = client.get(documentAliasUriA1, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            response = client.postJson(searchDataStreamUri, searchDataStreamA1, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void roleChangesShouldNotAffectTokenWithFrozenPrivileges() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)DLS_FLS_FM_USER, new Header[0]);
             GenericRestClient adminCertClient = cluster.getAdminCertRestClient();){
            try {
                CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*'\n  allowed_actions: '*'"));
                request.setFreezePrivileges(true);
                request.setTokenName("my_new_token");
                GenericRestClient.HttpResponse response = client.postJson("/_searchguard/authtoken", (ToXContentObject)request);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
                String accessToken = response.getBodyAsDocNode().getAsString("token");
                DocNode roleWithoutDlsFlsFmRestrictions = DocNode.of((String)"cluster_permissions", Collections.singletonList("*"), (String)"index_permissions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"index_patterns", Collections.singletonList(INDEX), (String)"allowed_actions", Collections.singletonList("SGS_READ"))}));
                response = adminCertClient.putJson("/_searchguard/api/roles/" + ROLE_WITH_DLS_FLS_FM_RULES_ON_INDEX.getName(), (Document)roleWithoutDlsFlsFmRestrictions);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
                TestData.TestDocument docDeptD = TEST_DATA.anyDocumentForDepartment("dept_d");
                TestData.TestDocument docDeptA = TEST_DATA.anyDocumentForDepartment("dept_a_1");
                MatcherAssert.assertThat((Object)docDeptD, (Matcher)Matchers.notNullValue());
                MatcherAssert.assertThat((Object)docDeptA, (Matcher)Matchers.notNullValue());
                String searchUrl = "/logs/_search?size=200";
                String docDeptDUrl = "/logs/_doc/" + docDeptD.getId();
                String docDeptAUrl = "/logs/_doc/" + docDeptA.getId();
                response = client.get(searchUrl, new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode().findByJsonPath("$.hits.hits[*]._source.dept"), (Matcher)Matchers.not((Matcher)Matchers.everyItem((Matcher)Matchers.equalTo((Object)"dept_d"))));
                response = client.get(docDeptDUrl, new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode().getAsNode("_source").size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(3)));
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$._source.source_ip", docDeptD.getContent().get("source_ip")));
                MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$._source.dest_ip", docDeptD.getContent().get("dest_ip")));
                response = client.get(docDeptAUrl, new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
                try (GenericRestClient tokenClient = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer " + accessToken)});){
                    response = tokenClient.get(searchUrl, new Header[0]);
                    MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
                    MatcherAssert.assertThat((Object)response.getBodyAsDocNode().findByJsonPath("$.hits.hits[*]._source.dept"), (Matcher)Matchers.everyItem((Matcher)Matchers.equalTo((Object)"dept_d")));
                    response = tokenClient.get(docDeptDUrl, new Header[0]);
                    MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
                    MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$._source", (int)3));
                    MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$._source", (String)"dept"));
                    MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$._source", (String)"source_ip"));
                    MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$._source", (String)"dest_ip"));
                    MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$._source.source_ip", docDeptD.getContent().get("source_ip")));
                    MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsValue((String)"$._source.dest_ip", docDeptD.getContent().get("dest_ip"))));
                    response = tokenClient.get(docDeptAUrl, new Header[0]);
                    MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isNotFound());
                }
            }
            finally {
                GenericRestClient.HttpResponse response = adminCertClient.putJson("/_searchguard/api/roles/" + ROLE_WITH_DLS_FLS_FM_RULES_ON_INDEX.getName(), (Document)ROLE_WITH_DLS_FLS_FM_RULES_ON_INDEX);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            }
        }
    }
}

