/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import org.apache.http.Header;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class BlocksApiTest {
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().nodeSettings(new Object[]{"searchguard.restapi.roles_enabled.0", "sg_admin"}).resources("restapi").sslEnabled().enterpriseModulesEnabled().build();

    @Test
    public void testBlockByUserName() throws Exception {
        try (GenericRestClient worfClient = cluster.getRestClient("worf", "worf", new Header[0]);
             GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();
             GenericRestClient sarekClient = cluster.getRestClient("sarek", "sarek", new Header[0]);){
            GenericRestClient.HttpResponse response = worfClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.putJson("_searchguard/api/blocks/a_block", FileHelper.loadFile((String)"restapi/simple_blocks_username.json"), new Header[0]);
            Assert.assertEquals((long)201L, (long)response.getStatusCode());
            response = adminClient.get("_searchguard/api/blocks/a_block", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("worf"));
            response = adminClient.get("_searchguard/api/blocks/", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("worf"));
            response = worfClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)401L, (long)response.getStatusCode());
            response = sarekClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
        }
    }

    @Test
    public void testAllowSingleUserName() throws Exception {
        try (GenericRestClient worfClient = cluster.getRestClient("worf", "worf", new Header[0]);
             GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();
             GenericRestClient sarekClient = cluster.getRestClient("sarek", "sarek", new Header[0]);
             GenericRestClient testClient = cluster.getRestClient("test", "test", new Header[0]);){
            GenericRestClient.HttpResponse response = worfClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = sarekClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = testClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.putJson("_searchguard/api/blocks/a_block", FileHelper.loadFile((String)"restapi/simple_blocks_single_allow_username.json"), new Header[0]);
            Assert.assertEquals((long)201L, (long)response.getStatusCode());
            response = adminClient.get("_searchguard/api/blocks/a_block", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("worf"));
            response = adminClient.get("_searchguard/api/blocks/", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("worf"));
            response = testClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
            response = adminClient.putJson("_searchguard/api/blocks/another_block", FileHelper.loadFile((String)"restapi/simple_blocks_single_disallow_username.json"), new Header[0]);
            Assert.assertEquals((long)201L, (long)response.getStatusCode());
            response = adminClient.get("_searchguard/api/blocks/another_block", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("test"));
            response = adminClient.get("_searchguard/api/blocks/", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("test"));
            response = worfClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = sarekClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)401L, (long)response.getStatusCode());
            response = testClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)401L, (long)response.getStatusCode());
        }
    }

    @Test
    public void testBlockByIp() throws Exception {
        try (GenericRestClient worfClient = cluster.getRestClient("worf", "worf", new Header[0]);
             GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();){
            GenericRestClient.HttpResponse response = worfClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.putJson("_searchguard/api/blocks/a_block", FileHelper.loadFile((String)"restapi/simple_blocks_ip.json"), new Header[0]);
            Assert.assertEquals((long)201L, (long)response.getStatusCode());
            response = adminClient.get("_searchguard/api/blocks/a_block", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("127.0.0.1"));
            response = adminClient.get("_searchguard/api/blocks/", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("127.0.0.1"));
            response = worfClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)401L, (long)response.getStatusCode());
        }
    }

    @Test
    public void testBlockByNetmask() throws Exception {
        try (GenericRestClient worfClient = cluster.getRestClient("worf", "worf", new Header[0]);
             GenericRestClient adminClient = cluster.getAdminCertRestClient().trackResources();){
            GenericRestClient.HttpResponse response = worfClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.putJson("_searchguard/api/blocks/a_block", FileHelper.loadFile((String)"restapi/simple_blocks_netmask.json"), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = adminClient.get("_searchguard/api/blocks/a_block", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("127.0.0.0/8"));
            response = adminClient.get("_searchguard/api/blocks/", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertTrue((boolean)response.getBody().contains("127.0.0.0/8"));
            response = worfClient.get("_searchguard/authinfo?pretty", new Header[0]);
            Assert.assertEquals((long)401L, (long)response.getStatusCode());
        }
    }

    @Test
    public void testDeleteBlocks() throws Exception {
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = adminClient.get("_searchguard/api/blocks/a_block", new Header[0]);
            boolean blocksExist = response.getBody().contains("Spock");
            if (!blocksExist) {
                response = adminClient.putJson("_searchguard/api/blocks/a_block", FileHelper.loadFile((String)"restapi/simple_blocks_username.json"), new Header[0]);
                Assert.assertEquals((long)201L, (long)response.getStatusCode());
            }
            response = adminClient.delete("_searchguard/api/blocks/a_block", new Header[0]);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = adminClient.get("_searchguard/api/blocks/a_block", new Header[0]);
            Assert.assertEquals((long)404L, (long)response.getStatusCode());
        }
    }
}

