/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.dlic.rest.api.AbstractRestApiUnitTest;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.license.SearchGuardLicense;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;

public class LicenseTest
extends AbstractRestApiUnitTest {
    protected static final String CONFIG_LICENSE_KEY = "sg_config.dynamic.license";
    protected static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    protected LocalDate expiredStartDate = LocalDate.of(2016, Month.JANUARY, 31);
    protected LocalDate validStartDate = LocalDate.of(2017, Month.JANUARY, 31);
    protected LocalDate notStartedStartDate = LocalDate.of(2024, Month.NOVEMBER, 8);
    protected LocalDate expiredExpiryDate = LocalDate.of(2017, Month.JANUARY, 31);
    protected LocalDate validExpiryDate = this.validStartDate.plusYears(100L);
    protected LocalDate notStartedExpiryDate = this.notStartedStartDate.plusYears(10L);
    protected LocalDate trialExpiryDate = LocalDate.now().plusDays(91L);

    @Test
    public void testLicenseApi() throws Exception {
        this.setup();
        this.rh.keystore = "restapi/kirk-keystore.jks";
        this.rh.sendHTTPClientCertificate = true;
        Map<?, ?> settingsAsMap = this.getCurrentLicense();
        Assert.assertEquals((Object)SearchGuardLicense.Type.TRIAL.name(), settingsAsMap.get("type"));
        Assert.assertEquals((Object)"unlimited", settingsAsMap.get("allowed_node_count_per_cluster"));
        Assert.assertEquals((Object)"true", (Object)String.valueOf(settingsAsMap.get("is_valid")));
        Assert.assertEquals((Object)"false", (Object)String.valueOf(settingsAsMap.get("is_expired")));
        this.uploadAndCheckValidLicense("full_valid_forever.txt", 200);
        this.checkCurrentLicenseProperties(SearchGuardLicense.Type.FULL, Boolean.TRUE, "unlimited", this.validStartDate, this.validExpiryDate);
        this.uploadAndCheckValidLicense("sme_valid_forever.txt");
        this.checkCurrentLicenseProperties(SearchGuardLicense.Type.SME, Boolean.TRUE, "5", this.validStartDate, this.validExpiryDate);
        this.uploadAndCheckValidLicense("oem_valid_forever.txt");
        this.checkCurrentLicenseProperties(SearchGuardLicense.Type.OEM, Boolean.TRUE, "unlimited", this.validStartDate, this.validExpiryDate);
        this.uploadAndCheckValidLicense("academic_valid_forever.txt");
        this.checkCurrentLicenseProperties(SearchGuardLicense.Type.ACADEMIC, Boolean.TRUE, "unlimited", this.validStartDate, this.validExpiryDate);
        Settings result = this.uploadAndCheckInvalidLicense("single_valid_forever.txt", 400);
        this.checkCurrentLicenseProperties(SearchGuardLicense.Type.ACADEMIC, Boolean.TRUE, "unlimited", this.validStartDate, this.validExpiryDate);
        Assert.assertEquals((Object)"License invalid due to: Only 1 node(s) allowed but you run 3 node(s)", (Object)result.get("message"));
        this.uploadAndCheckValidLicense("academic_not_started_search_guard_CI_CD_be_used_ONLY_for_internal_automated_tests_82B4F83A-486B-4D4C-A0DA-B2B7BD356B53.txt");
        this.checkCurrentLicenseProperties(SearchGuardLicense.Type.ACADEMIC, Boolean.TRUE, "unlimited", this.notStartedStartDate, this.notStartedExpiryDate);
        result = this.uploadAndCheckInvalidLicense("sme_expired.txt", 400);
        this.checkCurrentLicenseProperties(SearchGuardLicense.Type.ACADEMIC, Boolean.TRUE, "unlimited", this.notStartedStartDate, this.notStartedExpiryDate);
        Assert.assertTrue((boolean)result.get("message").contains("License is expired"));
        Assert.assertTrue((boolean)result.get("message").contains("Only 1 node(s) allowed"));
        this.uploadAndCheckValidLicense("full_valid_forever.txt");
        this.checkCurrentLicenseProperties(SearchGuardLicense.Type.FULL, Boolean.TRUE, "unlimited", this.validStartDate, this.validExpiryDate);
        RestHelper.HttpResponse response = this.rh.executePutRequest("/_searchguard/api/license", null, new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Settings settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        String msg = settings.get("reason");
        Assert.assertEquals((Object)"Request body required for this action.", (Object)msg);
        this.checkCurrentLicenseProperties(SearchGuardLicense.Type.FULL, Boolean.TRUE, "unlimited", this.validStartDate, this.validExpiryDate);
        response = this.rh.executePutRequest("/_searchguard/api/license", "{ \"sg_license\": \"\"}", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        msg = settings.get("message");
        Assert.assertEquals((Object)"License must not be null.", (Object)msg);
        this.checkCurrentLicenseProperties(SearchGuardLicense.Type.FULL, Boolean.TRUE, "unlimited", this.validStartDate, this.validExpiryDate);
        response = this.rh.executePutRequest("/_searchguard/api/license", "{ }", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        msg = settings.get("reason");
        Assert.assertEquals((Object)"Request body required for this action.", (Object)msg);
        this.checkCurrentLicenseProperties(SearchGuardLicense.Type.FULL, Boolean.TRUE, "unlimited", this.validStartDate, this.validExpiryDate);
        response = this.rh.executePutRequest("/_searchguard/api/license", "{ \"sg_license\": \"lalala\"}", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        msg = settings.get("message");
        Assert.assertEquals((Object)"License could not be decoded due to: Cannot find license signature", (Object)msg);
        this.checkCurrentLicenseProperties(SearchGuardLicense.Type.FULL, Boolean.TRUE, "unlimited", this.validStartDate, this.validExpiryDate);
    }

    private final String createLicenseRequestBody(String licenseString) throws Exception {
        return "{ \"sg_license\": \"" + licenseString + "\"}";
    }

    protected final String loadLicenseKey(String filename) throws Exception {
        return FileHelper.loadFile((String)("restapi/license/" + filename));
    }

    protected final void checkCurrentLicenseProperties(SearchGuardLicense.Type type, Boolean isValid, String nodeCount, LocalDate startDate, LocalDate expiryDate) throws Exception {
        Map<?, ?> settingsAsMap = this.getCurrentLicense();
        Assert.assertEquals((Object)type.name(), settingsAsMap.get("type"));
        Assert.assertEquals((Object)nodeCount, settingsAsMap.get("allowed_node_count_per_cluster"));
        Assert.assertEquals((Object)isValid.toString(), (Object)String.valueOf(settingsAsMap.get("is_valid")));
        Assert.assertEquals((Object)startDate.format(formatter), settingsAsMap.get("start_date"));
        Assert.assertEquals((Object)expiryDate.format(formatter), settingsAsMap.get("expiry_date"));
    }

    protected final void uploadAndCheckValidLicense(String licenseFileName) throws Exception {
        this.uploadAndCheckValidLicense(licenseFileName, 200);
    }

    protected final Settings uploadAndCheckInvalidLicense(String licenseFileName, int statusCode) throws Exception {
        String licenseKey = this.loadLicenseKey(licenseFileName);
        RestHelper.HttpResponse response = this.rh.executePutRequest("/_searchguard/api/license", this.createLicenseRequestBody(licenseKey), new Header[0]);
        Assert.assertEquals((long)statusCode, (long)response.getStatusCode());
        Settings settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        return settings;
    }

    protected final void uploadAndCheckValidLicense(String licenseFileName, int statusCode) throws Exception {
        String licenseKey = this.loadLicenseKey(licenseFileName);
        RestHelper.HttpResponse response = this.rh.executePutRequest("/_searchguard/api/license", this.createLicenseRequestBody(licenseKey), new Header[0]);
        Assert.assertEquals((String)response.getBody(), (long)statusCode, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/config", new Header[0]);
        DocNode jsonNode = response.toDocNode();
        Assert.assertEquals((Object)licenseKey, (Object)jsonNode.getAsNode("license_key", new String[]{"content", "key"}).toString());
    }

    protected final Map<?, ?> getCurrentLicense() throws Exception {
        RestHelper.HttpResponse response = this.rh.executeGetRequest("_searchguard/api/license", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        return (Map)response.toDocNode().get("sg_license");
    }
}

