/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.ldap;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.enterprise.auth.ldap.TestLdapDirectory;
import com.floragunn.searchguard.enterprise.auth.ldap.TestLdapServer;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.certificate.TestCertificate;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.Header;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Ignore
public class LdapStressTest {
    static TestCertificates certificatesContext = TestCertificates.builder().build();
    static TestCertificate ldapServerCertificate = certificatesContext.create("CN=ldap.example.com,OU=MyOU,O=MyO");
    static TestLdapDirectory.Entry KARLOTTA = new TestLdapDirectory.Entry("cn=Karlotta,ou=people,o=TEST").cn("Karlotta").uid("karlotta").userpassword("karlottas-secret").displayName("Karlotta Karl").objectClass("inetOrgPerson");
    static TestLdapDirectory.Entry THORE = new TestLdapDirectory.Entry("cn=Thore,ou=people,o=TEST").cn("Thore").uid("tho").userpassword("tho-secret").objectClass("inetOrgPerson").attr("departmentnumber", "a", "b").attr("businessCategory", "bc_1");
    static TestLdapDirectory.Entry PAUL = new TestLdapDirectory.Entry("cn=Paul,ou=people,o=TEST").cn("Paul").uid("paule").userpassword("p-secret").objectClass("inetOrgPerson");
    static TestLdapDirectory.Entry ALL_ACCESS_GROUP = new TestLdapDirectory.Entry("cn=all_access,ou=groups,o=TEST").cn("all_access").objectClass("groupOfUniqueNames").uniqueMember(KARLOTTA);
    static TestLdapDirectory.Entry STD_ACCESS_GROUP = new TestLdapDirectory.Entry("cn=std_access,ou=groups,o=TEST").cn("std_access").objectClass("groupOfUniqueNames").uniqueMember(THORE);
    static TestLdapServer tlsLdapServer = TestLdapServer.with(TestLdapDirectory.BASE, new TestLdapDirectory.Entry[]{KARLOTTA, THORE, PAUL, ALL_ACCESS_GROUP, STD_ACCESS_GROUP}).tls(ldapServerCertificate).bindRequestDelay(Duration.ofSeconds(5L)).build();
    static TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/ldap").description("using raw filter queries").backend(DocNode.of((String)"idp.hosts", (Object)"#{var:ldapHost}", (String)"idp.tls.trusted_cas", (Object)certificatesContext.getCaCertificate().getCertificateString(), (String)"idp.tls.verify_hostnames", (Object)false, (String)"user_search.filter.raw", (Object)"(uid=${user.name})", (String)"group_search.base_dn", (Object)TestLdapDirectory.GROUPS.getDn(), (Object[])new Object[]{"group_search.filter.raw", "(uniqueMember=${dn})", "group_search.role_name_attribute", "dn", "group_search.recursive.enabled", true})).userMapping(new TestSgConfig.Authc.Domain.UserMapping().attrsFrom("pattern", "ldap_user_entry.departmentnumber").attrsFrom("pattern_rec", "ldap_group_entries[*].businessCategory[*]"))});
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().singleNode().sslEnabled().enterpriseModulesEnabled().resources("ldap").roles(new TestSgConfig.Role[]{TestSgConfig.Role.ALL_ACCESS}).roleToRoleMapping(TestSgConfig.Role.ALL_ACCESS, new String[]{ALL_ACCESS_GROUP.getDn()}).authc(AUTHC).var("ldapHost", () -> tlsLdapServer.hostAndPort()).embedded().build();
    @ClassRule
    public static TestRule serverChain = RuleChain.outerRule((TestRule)tlsLdapServer).around((TestRule)cluster);

    @BeforeClass
    public static void initTestData() {
        Client tc = cluster.getInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("attr_test_a").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"a\", \"amount\": 1010}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("attr_test_b").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"b\", \"amount\": 2020}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("attr_test_c").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"c\", \"amount\": 3030}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("attr_test_d").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"d\", \"amount\": 4040}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("attr_test_e").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"e\", \"amount\": 5050}", XContentType.JSON)).actionGet();
    }

    @Test
    public void concurrentAuth() {
        int count = 15;
        CompletableFuture[] futures = new CompletableFuture[count];
        ExecutorService executorService = Executors.newFixedThreadPool(count);
        for (int i = 0; i < count; ++i) {
            futures[i] = CompletableFuture.supplyAsync(() -> {
                Object var2_4;
                block8: {
                    GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)KARLOTTA, new Header[0]);
                    try {
                        GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
                        Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
                        Assert.assertEquals((String)response.getBody(), (Object)"karlotta", (Object)response.getBodyAsDocNode().get("user_name"));
                        var2_4 = null;
                        if (client == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (client != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    client.close();
                }
                return var2_4;
            }, executorService);
        }
        CompletableFuture.allOf(futures).join();
    }
}

