/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.ldap;

import com.floragunn.searchguard.enterprise.auth.ldap.DelayedBindRequestHandler;
import com.floragunn.searchguard.enterprise.auth.ldap.PlaintextRequestRejectingRequestHandler;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.listener.AccessLogRequestHandler;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryDirectoryServerPassword;
import com.unboundid.ldap.listener.InMemoryDirectoryServerSnapshot;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.listener.InMemoryPasswordEncoder;
import com.unboundid.ldap.listener.InMemoryRequestHandler;
import com.unboundid.ldap.listener.JSONAccessLogRequestHandler;
import com.unboundid.ldap.listener.LDAPDebuggerRequestHandler;
import com.unboundid.ldap.listener.LDAPListener;
import com.unboundid.ldap.listener.LDAPListenerConfig;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.ReadOnlyInMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.StartTLSRequestHandler;
import com.unboundid.ldap.listener.ToCodeRequestHandler;
import com.unboundid.ldap.listener.interceptor.InMemoryOperationInterceptorRequestHandler;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.PLAINBindRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TestInMemoryDirectoryServer {
    private final InMemoryRequestHandler inMemoryHandler;
    private final Map<String, LDAPListener> listeners;
    private final Map<String, LDAPListenerConfig> ldapListenerConfigs;
    private final Map<String, SocketFactory> clientSocketFactories;
    private final ReadOnlyInMemoryDirectoryServerConfig config;

    public TestInMemoryDirectoryServer(InMemoryDirectoryServerConfig cfg, Duration bindRequestDelay) throws LDAPException {
        Validator.ensureNotNull((Object)cfg);
        this.config = new ReadOnlyInMemoryDirectoryServerConfig(cfg);
        InMemoryRequestHandler requestHandler = this.inMemoryHandler = new InMemoryRequestHandler((InMemoryDirectoryServerConfig)this.config);
        if (this.config.getAccessLogHandler() != null) {
            requestHandler = new AccessLogRequestHandler(this.config.getAccessLogHandler(), (LDAPListenerRequestHandler)requestHandler);
        }
        if (this.config.getJSONAccessLogHandler() != null) {
            requestHandler = new JSONAccessLogRequestHandler(this.config.getJSONAccessLogHandler(), (LDAPListenerRequestHandler)requestHandler);
        }
        if (this.config.getLDAPDebugLogHandler() != null) {
            requestHandler = new LDAPDebuggerRequestHandler(this.config.getLDAPDebugLogHandler(), (LDAPListenerRequestHandler)requestHandler);
        }
        if (this.config.getCodeLogPath() != null) {
            try {
                requestHandler = new ToCodeRequestHandler(this.config.getCodeLogPath(), this.config.includeRequestProcessingInCodeLog(), (LDAPListenerRequestHandler)requestHandler);
            }
            catch (IOException ioe) {
                Debug.debugException((Throwable)ioe);
                throw new LDAPException(ResultCode.LOCAL_ERROR, (Throwable)ioe);
            }
        }
        if (!this.config.getOperationInterceptors().isEmpty()) {
            requestHandler = new InMemoryOperationInterceptorRequestHandler(this.config.getOperationInterceptors(), (LDAPListenerRequestHandler)requestHandler);
        }
        List listenerConfigs = this.config.getListenerConfigs();
        this.listeners = new LinkedHashMap<String, LDAPListener>(StaticUtils.computeMapCapacity((int)listenerConfigs.size()));
        this.ldapListenerConfigs = new LinkedHashMap<String, LDAPListenerConfig>(StaticUtils.computeMapCapacity((int)listenerConfigs.size()));
        this.clientSocketFactories = new LinkedHashMap<String, SocketFactory>(StaticUtils.computeMapCapacity((int)listenerConfigs.size()));
        for (InMemoryListenerConfig c : listenerConfigs) {
            String name = StaticUtils.toLowerCase((String)c.getListenerName());
            Object listenerRequestHandler = c.getStartTLSSocketFactory() == null ? requestHandler : new PlaintextRequestRejectingRequestHandler((LDAPListenerRequestHandler)new StartTLSRequestHandler(c.getStartTLSSocketFactory(), (LDAPListenerRequestHandler)requestHandler), null);
            if (bindRequestDelay != null) {
                listenerRequestHandler = new DelayedBindRequestHandler((LDAPListenerRequestHandler)listenerRequestHandler, bindRequestDelay);
            }
            LDAPListenerConfig listenerCfg = new LDAPListenerConfig(c.getListenPort(), (LDAPListenerRequestHandler)listenerRequestHandler);
            listenerCfg.setMaxConnections(this.config.getMaxConnections());
            listenerCfg.setExceptionHandler(this.config.getListenerExceptionHandler());
            listenerCfg.setListenAddress(c.getListenAddress());
            listenerCfg.setServerSocketFactory(c.getServerSocketFactory());
            this.ldapListenerConfigs.put(name, listenerCfg);
            if (c.getClientSocketFactory() == null) continue;
            this.clientSocketFactories.put(name, c.getClientSocketFactory());
        }
    }

    public synchronized void startListening() throws LDAPException {
        ArrayList<String> messages = new ArrayList<String>(this.listeners.size());
        for (Map.Entry<String, LDAPListenerConfig> cfgEntry : this.ldapListenerConfigs.entrySet()) {
            String name = cfgEntry.getKey();
            if (this.listeners.containsKey(name)) continue;
            LDAPListenerConfig listenerConfig = cfgEntry.getValue();
            LDAPListener listener = new LDAPListener(listenerConfig);
            try {
                listener.startListening();
                listenerConfig.setListenPort(listener.getListenPort());
                this.listeners.put(name, listener);
            }
            catch (Exception e) {
                Debug.debugException((Throwable)e);
                messages.add(StaticUtils.getExceptionMessage((Throwable)e));
            }
        }
        if (!messages.isEmpty()) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, StaticUtils.concatenateStrings(messages));
        }
    }

    public synchronized void startListening(String listenerName) throws LDAPException {
        String name = StaticUtils.toLowerCase((String)listenerName);
        if (this.listeners.containsKey(name)) {
            return;
        }
        LDAPListenerConfig listenerConfig = this.ldapListenerConfigs.get(name);
        if (listenerConfig == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, "No such listener: " + listenerName);
        }
        LDAPListener listener = new LDAPListener(listenerConfig);
        try {
            listener.startListening();
            listenerConfig.setListenPort(listener.getListenPort());
            this.listeners.put(name, listener);
        }
        catch (Exception e) {
            Debug.debugException((Throwable)e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, (Throwable)e);
        }
    }

    public void close() {
        this.shutDown(true);
    }

    public synchronized void closeAllConnections(boolean sendNoticeOfDisconnection) {
        for (LDAPListener l : this.listeners.values()) {
            try {
                l.closeAllConnections(sendNoticeOfDisconnection);
            }
            catch (Exception e) {
                Debug.debugException((Throwable)e);
            }
        }
    }

    public synchronized void shutDown(boolean closeExistingConnections) {
        for (LDAPListener l : this.listeners.values()) {
            try {
                l.shutDown(closeExistingConnections);
            }
            catch (Exception e) {
                Debug.debugException((Throwable)e);
            }
        }
        this.listeners.clear();
    }

    public synchronized void shutDown(String listenerName, boolean closeExistingConnections) {
        String name = StaticUtils.toLowerCase((String)listenerName);
        LDAPListener listener = this.listeners.remove(name);
        if (listener != null) {
            listener.shutDown(closeExistingConnections);
        }
    }

    public synchronized void restartServer() throws LDAPException {
        block2: {
            this.shutDown(true);
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                Debug.debugException((Throwable)e);
                if (!(e instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
        this.startListening();
    }

    public synchronized void restartListener(String listenerName) throws LDAPException {
        block2: {
            this.shutDown(listenerName, true);
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                Debug.debugException((Throwable)e);
                if (!(e instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
        this.startListening(listenerName);
    }

    public ReadOnlyInMemoryDirectoryServerConfig getConfig() {
        return this.config;
    }

    InMemoryRequestHandler getInMemoryRequestHandler() {
        return this.inMemoryHandler;
    }

    public InMemoryDirectoryServerSnapshot createSnapshot() {
        return this.inMemoryHandler.createSnapshot();
    }

    public void restoreSnapshot(InMemoryDirectoryServerSnapshot snapshot) {
        this.inMemoryHandler.restoreSnapshot(snapshot);
    }

    public List<DN> getBaseDNs() {
        return this.inMemoryHandler.getBaseDNs();
    }

    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null, null);
    }

    public LDAPConnection getConnection(LDAPConnectionOptions options) throws LDAPException {
        return this.getConnection(null, options);
    }

    public LDAPConnection getConnection(String listenerName) throws LDAPException {
        return this.getConnection(listenerName, null);
    }

    public synchronized LDAPConnection getConnection(String listenerName, LDAPConnectionOptions options) throws LDAPException {
        String hostAddress;
        SocketFactory clientSocketFactory;
        LDAPListenerConfig listenerConfig;
        if (listenerName == null) {
            name = this.getFirstListenerName();
            if (name == null) {
                throw new LDAPException(ResultCode.CONNECT_ERROR, "no listeners");
            }
            listenerConfig = this.ldapListenerConfigs.get(name);
            clientSocketFactory = this.clientSocketFactories.get(name);
        } else {
            name = StaticUtils.toLowerCase((String)listenerName);
            if (!this.listeners.containsKey(name)) {
                throw new LDAPException(ResultCode.CONNECT_ERROR, "listener not running: " + listenerName);
            }
            listenerConfig = this.ldapListenerConfigs.get(name);
            clientSocketFactory = this.clientSocketFactories.get(name);
        }
        InetAddress listenAddress = listenerConfig.getListenAddress();
        if (listenAddress == null || listenAddress.isAnyLocalAddress()) {
            try {
                hostAddress = LDAPConnectionOptions.DEFAULT_NAME_RESOLVER.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                Debug.debugException((Throwable)e);
                hostAddress = "127.0.0.1";
            }
        } else {
            hostAddress = listenAddress.getHostAddress();
        }
        return new LDAPConnection(clientSocketFactory, options, hostAddress, listenerConfig.getListenPort());
    }

    public LDAPConnectionPool getConnectionPool(int maxConnections) throws LDAPException {
        return this.getConnectionPool(null, null, 1, maxConnections);
    }

    public LDAPConnectionPool getConnectionPool(String listenerName, LDAPConnectionOptions options, int initialConnections, int maxConnections) throws LDAPException {
        LDAPConnection conn = this.getConnection(listenerName, options);
        return new LDAPConnectionPool(conn, initialConnections, maxConnections);
    }

    public InetAddress getListenAddress() {
        return this.getListenAddress(null);
    }

    public synchronized InetAddress getListenAddress(String listenerName) {
        String name = listenerName == null ? this.getFirstListenerName() : StaticUtils.toLowerCase((String)listenerName);
        LDAPListenerConfig listenerCfg = this.ldapListenerConfigs.get(name);
        if (listenerCfg == null) {
            return null;
        }
        return listenerCfg.getListenAddress();
    }

    public int getListenPort() {
        return this.getListenPort(null);
    }

    public synchronized int getListenPort(String listenerName) {
        String name = listenerName == null ? this.getFirstListenerName() : StaticUtils.toLowerCase((String)listenerName);
        LDAPListener listener = this.listeners.get(name);
        if (listener == null) {
            return -1;
        }
        return listener.getListenPort();
    }

    public SocketFactory getClientSocketFactory() {
        return this.getClientSocketFactory(null);
    }

    public synchronized SocketFactory getClientSocketFactory(String listenerName) {
        String name = listenerName == null ? this.getFirstListenerName() : StaticUtils.toLowerCase((String)listenerName);
        return this.clientSocketFactories.get(name);
    }

    private String getFirstListenerName() {
        for (Map.Entry<String, LDAPListenerConfig> e : this.ldapListenerConfigs.entrySet()) {
            String name = e.getKey();
            if (!this.listeners.containsKey(name)) continue;
            return name;
        }
        return null;
    }

    public long getProcessingDelayMillis() {
        return this.inMemoryHandler.getProcessingDelayMillis();
    }

    public void setProcessingDelayMillis(long processingDelayMillis) {
        this.inMemoryHandler.setProcessingDelayMillis(processingDelayMillis);
    }

    public int countEntries() {
        return this.countEntries(false);
    }

    public int countEntries(boolean includeChangeLog) {
        return this.inMemoryHandler.countEntries(includeChangeLog);
    }

    public int countEntriesBelow(String baseDN) throws LDAPException {
        return this.inMemoryHandler.countEntriesBelow(baseDN);
    }

    public void clear() {
        this.inMemoryHandler.clear();
    }

    public int importFromLDIF(boolean clear, String path) throws LDAPException {
        return this.importFromLDIF(clear, new File(path));
    }

    public int importFromLDIF(boolean clear, File ldifFile) throws LDAPException {
        LDIFReader reader;
        try {
            reader = new LDIFReader(ldifFile);
            Schema schema = this.getSchema();
            if (schema != null) {
                reader.setSchema(schema);
            }
        }
        catch (Exception e) {
            Debug.debugException((Throwable)e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, (Throwable)e);
        }
        return this.importFromLDIF(clear, reader);
    }

    public int importFromLDIF(boolean clear, LDIFReader reader) throws LDAPException {
        return this.inMemoryHandler.importFromLDIF(clear, reader);
    }

    public int exportToLDIF(String path, boolean excludeGeneratedAttrs, boolean excludeChangeLog) throws LDAPException {
        LDIFWriter ldifWriter;
        try {
            ldifWriter = new LDIFWriter(path);
        }
        catch (Exception e) {
            Debug.debugException((Throwable)e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, (Throwable)e);
        }
        return this.exportToLDIF(ldifWriter, excludeGeneratedAttrs, excludeChangeLog, true);
    }

    public int exportToLDIF(LDIFWriter ldifWriter, boolean excludeGeneratedAttrs, boolean excludeChangeLog, boolean closeWriter) throws LDAPException {
        return this.inMemoryHandler.exportToLDIF(ldifWriter, excludeGeneratedAttrs, excludeChangeLog, closeWriter);
    }

    public int applyChangesFromLDIF(String path) throws LDAPException {
        return this.applyChangesFromLDIF(new File(path));
    }

    public int applyChangesFromLDIF(File ldifFile) throws LDAPException {
        LDIFReader reader;
        try {
            reader = new LDIFReader(ldifFile);
            Schema schema = this.getSchema();
            if (schema != null) {
                reader.setSchema(schema);
            }
        }
        catch (Exception e) {
            Debug.debugException((Throwable)e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, (Throwable)e);
        }
        return this.applyChangesFromLDIF(reader);
    }

    public int applyChangesFromLDIF(LDIFReader reader) throws LDAPException {
        return this.inMemoryHandler.applyChangesFromLDIF(reader);
    }

    public LDAPResult add(Entry entry) throws LDAPException {
        return this.add(new AddRequest(entry));
    }

    public LDAPResult add(String ... ldifLines) throws LDIFException, LDAPException {
        return this.add(new AddRequest(ldifLines));
    }

    public LDAPResult add(AddRequest addRequest) throws LDAPException {
        return this.inMemoryHandler.add(addRequest);
    }

    public Schema getSchema() throws LDAPException {
        return this.inMemoryHandler.getSchema();
    }

    public void addEntries(Entry ... entries) throws LDAPException {
        this.addEntries(Arrays.asList(entries));
    }

    public void addEntries(List<? extends Entry> entries) throws LDAPException {
        this.inMemoryHandler.addEntries(entries);
    }

    public void addEntries(String ... ldifEntryLines) throws LDAPException {
        ByteStringBuffer buffer = new ByteStringBuffer();
        for (String line : ldifEntryLines) {
            buffer.append((CharSequence)line);
            buffer.append(StaticUtils.EOL_BYTES);
        }
        ArrayList<Entry> entryList = new ArrayList<Entry>(10);
        try (LDIFReader reader = new LDIFReader(buffer.asInputStream());){
            Schema schema = this.getSchema();
            if (schema != null) {
                reader.setSchema(schema);
            }
            try {
                Entry entry;
                while ((entry = reader.readEntry()) != null) {
                    entryList.add(entry);
                }
            }
            catch (Exception e) {
                Debug.debugException((Throwable)e);
                throw new LDAPException(ResultCode.PARAM_ERROR, (Throwable)e);
            }
            this.addEntries(entryList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BindResult bind(String bindDN, String password) throws LDAPException {
        return this.bind((BindRequest)new SimpleBindRequest(bindDN, password));
    }

    public BindResult bind(BindRequest bindRequest) throws LDAPException {
        BindRequestProtocolOp bindOp;
        ArrayList<Control> requestControlList = new ArrayList<Control>(bindRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        if (bindRequest instanceof SimpleBindRequest) {
            r = (SimpleBindRequest)bindRequest;
            bindOp = new BindRequestProtocolOp(r.getBindDN(), r.getPassword().getValue());
        } else if (bindRequest instanceof PLAINBindRequest) {
            r = (PLAINBindRequest)bindRequest;
            byte[] authZIDBytes = StaticUtils.getBytes((String)r.getAuthorizationID());
            byte[] authNIDBytes = StaticUtils.getBytes((String)r.getAuthenticationID());
            byte[] passwordBytes = r.getPasswordBytes();
            byte[] credBytes = new byte[2 + authZIDBytes.length + authNIDBytes.length + passwordBytes.length];
            System.arraycopy(authZIDBytes, 0, credBytes, 0, authZIDBytes.length);
            int pos = authZIDBytes.length + 1;
            System.arraycopy(authNIDBytes, 0, credBytes, pos, authNIDBytes.length);
            System.arraycopy(passwordBytes, 0, credBytes, pos += authNIDBytes.length + 1, passwordBytes.length);
            bindOp = new BindRequestProtocolOp(null, "PLAIN", new ASN1OctetString(credBytes));
        } else {
            throw new LDAPException(ResultCode.AUTH_METHOD_NOT_SUPPORTED);
        }
        LDAPMessage responseMessage = this.inMemoryHandler.processBindRequest(1, bindOp, requestControlList);
        BindResponseProtocolOp bindResponse = responseMessage.getBindResponseProtocolOp();
        BindResult bindResult = new BindResult(new LDAPResult(responseMessage.getMessageID(), ResultCode.valueOf((int)bindResponse.getResultCode()), bindResponse.getDiagnosticMessage(), bindResponse.getMatchedDN(), bindResponse.getReferralURLs(), responseMessage.getControls()));
        switch (bindResponse.getResultCode()) {
            case 0: {
                return bindResult;
            }
        }
        throw new LDAPException((LDAPResult)bindResult);
    }

    public int deleteSubtree(String baseDN) throws LDAPException {
        return this.inMemoryHandler.deleteSubtree(baseDN);
    }

    public ExtendedResult processExtendedOperation(String requestOID) throws LDAPException {
        Validator.ensureNotNull((Object)requestOID);
        return this.processExtendedOperation(new ExtendedRequest(requestOID));
    }

    public ExtendedResult processExtendedOperation(String requestOID, ASN1OctetString requestValue) throws LDAPException {
        Validator.ensureNotNull((Object)requestOID);
        return this.processExtendedOperation(new ExtendedRequest(requestOID, requestValue));
    }

    public ExtendedResult processExtendedOperation(ExtendedRequest extendedRequest) throws LDAPException {
        Control[] responseControls;
        String[] referralURLs;
        Validator.ensureNotNull((Object)extendedRequest);
        ArrayList<Control> requestControlList = new ArrayList<Control>(extendedRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        LDAPMessage responseMessage = this.inMemoryHandler.processExtendedRequest(1, new ExtendedRequestProtocolOp(extendedRequest.getOID(), extendedRequest.getValue()), requestControlList);
        ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
        ResultCode rc = ResultCode.valueOf((int)extendedResponse.getResultCode());
        List referralURLList = extendedResponse.getReferralURLs();
        if (referralURLList == null || referralURLList.isEmpty()) {
            referralURLs = StaticUtils.NO_STRINGS;
        } else {
            referralURLs = new String[referralURLList.size()];
            referralURLList.toArray(referralURLs);
        }
        List controlList = responseMessage.getControls();
        if (controlList == null || controlList.isEmpty()) {
            responseControls = StaticUtils.NO_CONTROLS;
        } else {
            responseControls = new Control[controlList.size()];
            controlList.toArray(responseControls);
        }
        ExtendedResult extendedResult = new ExtendedResult(responseMessage.getMessageID(), rc, extendedResponse.getDiagnosticMessage(), extendedResponse.getMatchedDN(), referralURLs, extendedResponse.getResponseOID(), extendedResponse.getResponseValue(), responseControls);
        if (extendedResult.getOID() == null && extendedResult.getValue() == null) {
            switch (rc.intValue()) {
                case 1: 
                case 2: 
                case 51: 
                case 52: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 90: 
                case 91: {
                    throw new LDAPException((LDAPResult)extendedResult);
                }
            }
        }
        return extendedResult;
    }

    public List<String> getPasswordAttributes() {
        return this.inMemoryHandler.getPasswordAttributes();
    }

    public InMemoryPasswordEncoder getPrimaryPasswordEncoder() {
        return this.inMemoryHandler.getPrimaryPasswordEncoder();
    }

    public List<InMemoryPasswordEncoder> getAllPasswordEncoders() {
        return this.inMemoryHandler.getAllPasswordEncoders();
    }

    public List<InMemoryDirectoryServerPassword> getPasswordsInEntry(Entry entry, ASN1OctetString clearPasswordToMatch) {
        return this.inMemoryHandler.getPasswordsInEntry(entry, clearPasswordToMatch);
    }

    public boolean entryExists(String dn) throws LDAPException {
        return this.inMemoryHandler.entryExists(dn);
    }

    public boolean entryExists(String dn, String filter) throws LDAPException {
        return this.inMemoryHandler.entryExists(dn, filter);
    }

    public boolean entryExists(Entry entry) throws LDAPException {
        return this.inMemoryHandler.entryExists(entry);
    }

    public void assertEntryExists(String dn) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntryExists(dn);
    }

    public void assertEntryExists(String dn, String filter) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntryExists(dn, filter);
    }

    public void assertEntryExists(Entry entry) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntryExists(entry);
    }

    public List<String> getMissingEntryDNs(String ... dns) throws LDAPException {
        return this.inMemoryHandler.getMissingEntryDNs((Collection)StaticUtils.toList((Object[])dns));
    }

    public List<String> getMissingEntryDNs(Collection<String> dns) throws LDAPException {
        return this.inMemoryHandler.getMissingEntryDNs(dns);
    }

    public void assertEntriesExist(String ... dns) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntriesExist((Collection)StaticUtils.toList((Object[])dns));
    }

    public void assertEntriesExist(Collection<String> dns) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntriesExist(dns);
    }

    public List<String> getMissingAttributeNames(String dn, String ... attributeNames) throws LDAPException {
        return this.inMemoryHandler.getMissingAttributeNames(dn, (Collection)StaticUtils.toList((Object[])attributeNames));
    }

    public List<String> getMissingAttributeNames(String dn, Collection<String> attributeNames) throws LDAPException {
        return this.inMemoryHandler.getMissingAttributeNames(dn, attributeNames);
    }

    public void assertAttributeExists(String dn, String ... attributeNames) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertAttributeExists(dn, (Collection)StaticUtils.toList((Object[])attributeNames));
    }

    public void assertAttributeExists(String dn, Collection<String> attributeNames) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertAttributeExists(dn, attributeNames);
    }

    public List<String> getMissingAttributeValues(String dn, String attributeName, String ... attributeValues) throws LDAPException {
        return this.inMemoryHandler.getMissingAttributeValues(dn, attributeName, (Collection)StaticUtils.toList((Object[])attributeValues));
    }

    public List<String> getMissingAttributeValues(String dn, String attributeName, Collection<String> attributeValues) throws LDAPException {
        return this.inMemoryHandler.getMissingAttributeValues(dn, attributeName, attributeValues);
    }

    public void assertValueExists(String dn, String attributeName, String ... attributeValues) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertValueExists(dn, attributeName, (Collection)StaticUtils.toList((Object[])attributeValues));
    }

    public void assertValueExists(String dn, String attributeName, Collection<String> attributeValues) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertValueExists(dn, attributeName, attributeValues);
    }

    public void assertEntryMissing(String dn) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntryMissing(dn);
    }

    public void assertAttributeMissing(String dn, String ... attributeNames) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertAttributeMissing(dn, (Collection)StaticUtils.toList((Object[])attributeNames));
    }

    public void assertAttributeMissing(String dn, Collection<String> attributeNames) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertAttributeMissing(dn, attributeNames);
    }

    public void assertValueMissing(String dn, String attributeName, String ... attributeValues) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertValueMissing(dn, attributeName, (Collection)StaticUtils.toList((Object[])attributeValues));
    }

    public void assertValueMissing(String dn, String attributeName, Collection<String> attributeValues) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertValueMissing(dn, attributeName, attributeValues);
    }
}

