/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.searchguard.enterprise.auth.oidc.CxfTestTools;
import com.floragunn.searchguard.enterprise.auth.oidc.TestJwts;
import com.floragunn.searchguard.test.helper.network.SocketUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ExceptionLogger;
import org.apache.http.Header;
import org.apache.http.HttpConnectionFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.ConnSupport;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.SSLServerSetupHandler;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;

public class MockIpdServer
implements Closeable {
    private static final Logger log = LogManager.getLogger(MockIpdServer.class);
    static final String CTX_DISCOVER = "/discover";
    static final String CTX_KEYS = "/api/oauth/keys";
    static final String CTX_TOKEN = "/token";
    static final String CTX_USERINFO = "/userinfo";
    private HttpServer httpServer;
    private int port;
    private String uri;
    private boolean requireTlsClientCertAuth;
    private String requireTlsClientCertFingerprint;
    private JsonWebKeys jwks;
    private boolean requireValidCodes = true;
    private boolean requirePkce = false;
    private Map<String, AuthCodeContext> validCodes = new ConcurrentHashMap<String, AuthCodeContext>();
    private Map<String, Map<String, Object>> accessTokenToUserInfoMap = new ConcurrentHashMap<String, Map<String, Object>>();
    private Header requiredHttpHeader;
    private TLSConfig tlsConfig;

    public static Builder forKeySet(JsonWebKeys jwks) {
        return new Builder(jwks);
    }

    private MockIpdServer() {
    }

    private void start() throws IOException {
        int i = 0;
        while (true) {
            try {
                this.start(SocketUtils.findAvailableTcpPort());
                return;
            }
            catch (BindException e) {
                if (i >= 10) {
                    throw e;
                }
                ++i;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    private void start(int port) throws IOException {
        this.port = port;
        this.uri = (this.tlsConfig != null ? "https" : "http") + "://localhost:" + port;
        ServerBootstrap serverBootstrap = ServerBootstrap.bootstrap().setListenerPort(port).registerHandler(CTX_DISCOVER, new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                MockIpdServer.this.handleDiscoverRequest(request, response, context);
            }
        }).registerHandler(CTX_KEYS, new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                MockIpdServer.this.handleKeysRequest(request, response, context);
            }
        }).registerHandler(CTX_TOKEN, new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                MockIpdServer.this.handleTokenRequest(request, response, context);
            }
        }).registerHandler(CTX_USERINFO, new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                MockIpdServer.this.handleUserInfoRequest(request, response, context);
            }
        }).setExceptionLogger(new ExceptionLogger(){

            public void log(Exception ex) {
                if (ex instanceof ConnectionClosedException) {
                    log.debug("Error in MockIdpServer", (Throwable)ex);
                } else {
                    log.error("Error in MockIdpServer", (Throwable)ex);
                }
            }
        });
        if (this.tlsConfig != null) {
            serverBootstrap = serverBootstrap.setSslContext(this.createSSLContext()).setSslSetupHandler(new SSLServerSetupHandler(){

                public void initialize(SSLServerSocket socket) throws SSLException {
                    socket.setNeedClientAuth(MockIpdServer.this.requireTlsClientCertAuth);
                }
            }).setConnectionFactory((HttpConnectionFactory)new HttpConnectionFactory<DefaultBHttpServerConnection>(){
                private ConnectionConfig cconfig = ConnectionConfig.DEFAULT;

                public DefaultBHttpServerConnection createConnection(Socket socket) throws IOException {
                    SSLTestHttpServerConnection conn = new SSLTestHttpServerConnection(this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), ConnSupport.createDecoder((ConnectionConfig)this.cconfig), ConnSupport.createEncoder((ConnectionConfig)this.cconfig), this.cconfig.getMessageConstraints(), null, null, null, null);
                    conn.bind(socket);
                    return conn;
                }
            });
        }
        this.httpServer = serverBootstrap.create();
        this.httpServer.start();
    }

    public MockIpdServer acceptOnlyRequestsWithHeader(Header header) {
        this.requiredHttpHeader = header;
        return this;
    }

    @Override
    public void close() throws IOException {
        this.httpServer.stop();
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public String getUri() {
        return this.uri;
    }

    public URI getDiscoverUri() {
        return URI.create(this.uri + CTX_DISCOVER);
    }

    public int getPort() {
        return this.port;
    }

    protected void handleDiscoverRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (!this.checkAccess(request, response, context)) {
            return;
        }
        response.setStatusCode(200);
        response.setHeader("Cache-Control", "public, max-age=31536000");
        response.setEntity((HttpEntity)new StringEntity(DocNode.of((String)"jwks_uri", (Object)(this.uri + CTX_KEYS), (String)"issuer", (Object)this.uri, (String)"unknownPropertyToBeIgnored", (Object)42, (String)"token_endpoint", (Object)(this.uri + CTX_TOKEN), (String)"authorization_endpoint", (Object)(this.uri + "/auth"), (Object[])new Object[]{"end_session_endpoint", this.uri + "/logout", "userinfo_endpoint", this.uri + CTX_USERINFO}).toJsonString(), ContentType.APPLICATION_JSON));
    }

    protected void handleKeysRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (!this.checkAccess(request, response, context)) {
            return;
        }
        response.setStatusCode(200);
        response.setEntity((HttpEntity)new StringEntity(CxfTestTools.toJson((JsonMapObject)this.jwks)));
    }

    protected void handleTokenRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        try {
            String accessToken;
            String idToken;
            if (!this.checkAccess(request, response, context)) {
                return;
            }
            if (!"POST".equalsIgnoreCase(request.getRequestLine().getMethod())) {
                response.setStatusCode(400);
                response.setEntity((HttpEntity)new StringEntity("Not a POST request"));
                return;
            }
            if (request.getFirstHeader("Content-Type") == null) {
                response.setStatusCode(400);
                response.setEntity((HttpEntity)new StringEntity("Content-Type header is missing"));
                return;
            }
            if (!request.getFirstHeader("Content-Type").getValue().toLowerCase().startsWith("application/x-www-form-urlencoded")) {
                response.setStatusCode(400);
                response.setEntity((HttpEntity)new StringEntity("Content-Type is not application/x-www-form-urlencoded"));
                return;
            }
            if (!(request instanceof HttpEntityEnclosingRequest)) {
                response.setStatusCode(400);
                response.setEntity((HttpEntity)new StringEntity("Missing entity"));
                return;
            }
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            String entityBody = EntityUtils.toString((HttpEntity)entity);
            Map<String, String> entityParams = this.getFormUrlEncodedValues(entityBody);
            log.info("Got entity params: " + String.valueOf(entityParams) + "; " + entityBody);
            if (!entityParams.containsKey("grant_type")) {
                response.setStatusCode(400);
                response.setEntity((HttpEntity)new StringEntity("Missing grant_type"));
                return;
            }
            String code = entityParams.get("code");
            if (this.requireValidCodes) {
                String currentRedirectUri;
                String oldRedirectUri;
                String codeVerifier;
                String hashed;
                AuthCodeContext authCodeContext = this.validCodes.remove(code);
                if (authCodeContext == null) {
                    response.setStatusCode(400);
                    response.setEntity((HttpEntity)new StringEntity("Invalid code " + code));
                    return;
                }
                if (authCodeContext.codeChallenge != null && !(hashed = this.applySHA256(codeVerifier = entityParams.get("code_verifier"))).equals(authCodeContext.codeChallenge)) {
                    response.setStatusCode(400);
                    response.setEntity((HttpEntity)new StringEntity("Invalid code_challenge " + authCodeContext.codeChallenge + "; expected: " + hashed + " (" + codeVerifier + ")"));
                    return;
                }
                idToken = authCodeContext.userJwt;
                accessToken = RandomStringUtils.randomAlphabetic((int)20);
                if (authCodeContext.userInfo != null) {
                    this.accessTokenToUserInfoMap.put(accessToken, authCodeContext.userInfo);
                }
                if (!(oldRedirectUri = authCodeContext.redirectUri).equals(currentRedirectUri = entityParams.get("redirect_uri"))) {
                    response.setStatusCode(400);
                    response.setEntity((HttpEntity)new StringEntity("Invalid redirect_uri " + currentRedirectUri + "; expected: " + oldRedirectUri));
                    return;
                }
            } else {
                idToken = TestJwts.MC_COY_SIGNED_OCT_1;
                accessToken = "dummy_access_token";
            }
            response.setStatusCode(200);
            ImmutableMap responseBody = ImmutableMap.of((Object)"access_token", (Object)accessToken, (Object)"token_type", (Object)"bearer", (Object)"expires_in", (Object)3600, (Object)"scope", (Object)"profile app:read app:write", (Object)"id_token", (Object)idToken);
            response.setEntity((HttpEntity)new StringEntity(DocWriter.json().writeAsString((Object)responseBody), ContentType.APPLICATION_JSON));
        }
        catch (Exception e) {
            log.error("Error in handleTokenRequest()", (Throwable)e);
            response.setStatusCode(500);
            response.setEntity((HttpEntity)new StringEntity(e.toString()));
        }
    }

    protected void handleUserInfoRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (!this.checkAccess(request, response, context)) {
            return;
        }
        if (!"POST".equalsIgnoreCase(request.getRequestLine().getMethod()) && !"GET".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            response.setStatusCode(400);
            response.setEntity((HttpEntity)new StringEntity("Not a GET or POST request"));
            return;
        }
        if (request.getFirstHeader("Authorization") == null) {
            response.setStatusCode(400);
            response.setEntity((HttpEntity)new StringEntity("Authorization header is missing"));
            return;
        }
        String authorization = request.getFirstHeader("Authorization").getValue();
        if (!authorization.toLowerCase().startsWith("bearer ")) {
            response.setStatusCode(400);
            response.setEntity((HttpEntity)new StringEntity("Needs to use bearer authorization"));
            return;
        }
        String accessToken = authorization.substring("bearer ".length());
        Map<String, Object> userInfo = this.accessTokenToUserInfoMap.get(accessToken);
        if (userInfo == null) {
            response.setStatusCode(400);
            response.setEntity((HttpEntity)new StringEntity("Invalid access token " + accessToken));
            return;
        }
        response.setEntity((HttpEntity)new StringEntity(DocWriter.json().writeAsString(userInfo), ContentType.APPLICATION_JSON));
    }

    private SSLContext createSSLContext() {
        return this.tlsConfig.getUnrestrictedSslContext();
    }

    private boolean checkAccess(HttpRequest request, HttpResponse response, HttpContext context) throws UnsupportedEncodingException, SSLPeerUnverifiedException {
        if (this.requiredHttpHeader != null) {
            List<Header> requestHeaders = Arrays.asList(request.getHeaders(this.requiredHttpHeader.getName()));
            if (requestHeaders.stream().anyMatch(header -> this.requiredHttpHeader.getValue().equals(header.getValue()))) {
                return true;
            }
            response.setStatusCode(451);
            response.setEntity((HttpEntity)new StringEntity("We are only accepting requests with the '" + this.requiredHttpHeader.getName() + "' header set to '" + this.requiredHttpHeader.getValue() + "'"));
            return false;
        }
        if (this.requireTlsClientCertFingerprint != null) {
            SSLTestHttpServerConnection connection = (SSLTestHttpServerConnection)((HttpCoreContext)context).getConnection();
            X509Certificate peerCert = (X509Certificate)connection.getPeerCertificates()[0];
            try {
                String sha256Fingerprint = Hashing.sha256().hashBytes(peerCert.getEncoded()).toString();
                if (!this.requireTlsClientCertFingerprint.equals(sha256Fingerprint)) {
                    response.setStatusCode(401);
                    response.setEntity((HttpEntity)new StringEntity("Client certificate is not allowed: " + sha256Fingerprint + "\n" + String.valueOf(peerCert)));
                    return false;
                }
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private String applySHA256(String string) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(string.getBytes(StandardCharsets.US_ASCII));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String handleSsoGetRequestURI(String ssoLocation, String userJwt) throws URISyntaxException, UnsupportedEncodingException {
        return this.handleSsoGetRequestURI(ssoLocation, userJwt, null);
    }

    public String handleSsoGetRequestURI(String ssoLocation, String userJwt, Map<String, Object> userInfo) throws URISyntaxException, UnsupportedEncodingException {
        Map<String, String> ssoParams = this.getUriParams(ssoLocation);
        String scope = ssoParams.get("scope");
        Assert.assertNotNull((String)ssoLocation, (Object)scope);
        Assert.assertTrue((String)ssoLocation, (boolean)scope.contains("openid"));
        String state = ssoParams.get("state");
        Assert.assertNotNull((String)ssoLocation, (Object)state);
        String redirectUri = ssoParams.get("redirect_uri");
        Assert.assertNotNull((String)ssoLocation, (Object)redirectUri);
        String codeChallenge = ssoParams.get("code_challenge");
        String codeChallengeMethod = ssoParams.get("code_challenge_method");
        String code = RandomStringUtils.randomAlphanumeric((int)8);
        AuthCodeContext authCodeContext = new AuthCodeContext();
        authCodeContext.userJwt = userJwt;
        authCodeContext.redirectUri = redirectUri;
        authCodeContext.codeChallenge = codeChallenge;
        authCodeContext.userInfo = userInfo;
        if (codeChallenge != null) {
            Assert.assertEquals((String)ssoLocation, (Object)"S256", (Object)codeChallengeMethod);
        } else if (this.requirePkce) {
            return null;
        }
        this.validCodes.put(code, authCodeContext);
        URIBuilder uriBuilder = new URIBuilder(redirectUri);
        uriBuilder.addParameter("code", code);
        uriBuilder.addParameter("state", state);
        return uriBuilder.build().toASCIIString();
    }

    private Map<String, String> getUriParams(String uriString) {
        URI uri = URI.create(uriString);
        return this.getFormUrlEncodedValues(uri.getRawQuery());
    }

    private Map<String, String> getFormUrlEncodedValues(String formUrlencoded) {
        List nameValuePairs = URLEncodedUtils.parse((String)formUrlencoded, (Charset)Charset.forName("utf-8"));
        HashMap<String, String> result = new HashMap<String, String>(nameValuePairs.size());
        for (NameValuePair nameValuePair : nameValuePairs) {
            result.put(nameValuePair.getName(), nameValuePair.getValue());
        }
        return result;
    }

    public boolean isRequireValidCodes() {
        return this.requireValidCodes;
    }

    public void setRequireValidCodes(boolean requireValidCodes) {
        this.requireValidCodes = requireValidCodes;
    }

    public static class Builder {
        private MockIpdServer mockIdpServer = new MockIpdServer();

        public Builder(JsonWebKeys jwks) {
            this.mockIdpServer.jwks = jwks;
        }

        public Builder useCustomTlsConfig(TLSConfig tlsConfig) {
            this.mockIdpServer.tlsConfig = tlsConfig;
            return this;
        }

        public Builder requirePkce(boolean requirePkce) {
            this.mockIdpServer.requirePkce = requirePkce;
            return this;
        }

        public Builder requireTlsClientCertAuth() {
            this.mockIdpServer.requireTlsClientCertAuth = true;
            return this;
        }

        public Builder acceptOnlyRequestsWithHeader(Header header) {
            this.mockIdpServer.requiredHttpHeader = header;
            return this;
        }

        public Builder requireValidCodes(boolean requireValidCodes) {
            this.mockIdpServer.requireValidCodes = requireValidCodes;
            return this;
        }

        public Builder requireTlsClientCertFingerprint(String fingerprint) {
            this.mockIdpServer.requireTlsClientCertAuth = true;
            this.mockIdpServer.requireTlsClientCertFingerprint = fingerprint;
            return this;
        }

        public MockIpdServer start() throws IOException {
            this.mockIdpServer.start();
            return this.mockIdpServer;
        }
    }

    private static class AuthCodeContext {
        private String userJwt;
        private String redirectUri;
        private String codeChallenge;
        private Map<String, Object> userInfo;

        private AuthCodeContext() {
        }
    }

    static class SSLTestHttpServerConnection
    extends DefaultBHttpServerConnection {
        public SSLTestHttpServerConnection(int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageParserFactory<HttpRequest> requestParserFactory, HttpMessageWriterFactory<HttpResponse> responseWriterFactory) {
            super(buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestParserFactory, responseWriterFactory);
        }

        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            return ((SSLSocket)this.getSocket()).getSession().getPeerCertificates();
        }
    }
}

