/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.codova.config.net.ProxyConfig;
import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.enterprise.auth.oidc.KeySetRetriever;
import com.floragunn.searchguard.enterprise.auth.oidc.MockIpdServer;
import com.floragunn.searchguard.enterprise.auth.oidc.OidcProviderConfig;
import com.floragunn.searchguard.enterprise.auth.oidc.OpenIdProviderClient;
import com.floragunn.searchguard.enterprise.auth.oidc.TestJwk;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchsupport.proxy.wiremock.WireMockRequestHeaderAddingFilter;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.google.common.collect.ImmutableMap;
import java.io.FileNotFoundException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class OpenIdProviderClientTest {
    private static final TLSConfig IDP_TLS_CONFIG;
    protected static MockIpdServer mockIdpServer;
    private static final WireMockRequestHeaderAddingFilter REQUEST_HEADER_ADDING_FILTER;
    @ClassRule
    public static WireMockRule wireMockProxy;

    @BeforeClass
    public static void setUp() throws Exception {
        mockIdpServer = MockIpdServer.forKeySet(TestJwk.Jwks.ALL).start();
        mockIdpServer.setRequireValidCodes(false);
    }

    @AfterClass
    public static void tearDown() {
        if (mockIdpServer != null) {
            try {
                mockIdpServer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void proxyTest() throws Exception {
        try (MockIpdServer proxyOnlyMockIdpServer = MockIpdServer.forKeySet(TestJwk.Jwks.ALL).acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader()).start();){
            OpenIdProviderClient openIdProviderClientWithoutProxySettings = new OpenIdProviderClient(proxyOnlyMockIdpServer.getDiscoverUri(), null, null, true);
            proxyOnlyMockIdpServer.setRequireValidCodes(false);
            try {
                openIdProviderClientWithoutProxySettings.getOidcConfiguration();
                Assert.fail();
            }
            catch (AuthenticatorUnavailableException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("HTTP/1.1 451"));
            }
            ImmutableMap proxySettings = ImmutableMap.of((Object)"proxy.host", (Object)"127.0.0.8", (Object)"proxy.port", (Object)wireMockProxy.port(), (Object)"proxy.scheme", (Object)"http");
            OpenIdProviderClient openIdProviderClient = new OpenIdProviderClient(proxyOnlyMockIdpServer.getDiscoverUri(), null, ProxyConfig.parse((Map)proxySettings, (String)"proxy"), true);
            OidcProviderConfig oidcProviderConfig = (OidcProviderConfig)openIdProviderClient.getOidcConfiguration().get();
            Assert.assertTrue((String)oidcProviderConfig.toJsonString(), (boolean)oidcProviderConfig.toBasicObject().containsKey("token_endpoint"));
            String tokenEndpointRequest = "grant_type=authorization_code&code=wusch";
            HttpResponse response = openIdProviderClient.callTokenEndpoint(tokenEndpointRequest.getBytes(), ContentType.create((String)"application/x-www-form-urlencoded"));
            String entity = EntityUtils.toString((HttpEntity)response.getEntity());
            Assert.assertEquals((String)entity, (long)200L, (long)response.getStatusLine().getStatusCode());
            Assert.assertTrue((String)entity, (boolean)entity.contains("access_token"));
        }
    }

    @Test
    public void cacheTest() throws AuthenticatorUnavailableException {
        OpenIdProviderClient openIdProviderClient = new OpenIdProviderClient(mockIdpServer.getDiscoverUri(), null, null, true);
        KeySetRetriever keySetRetriever = new KeySetRetriever(openIdProviderClient);
        keySetRetriever.get();
        Assert.assertEquals((long)1L, (long)openIdProviderClient.getOidcCacheMisses());
        Assert.assertEquals((long)0L, (long)openIdProviderClient.getOidcCacheHits());
        keySetRetriever.get();
        Assert.assertEquals((long)1L, (long)openIdProviderClient.getOidcCacheMisses());
        Assert.assertEquals((long)1L, (long)openIdProviderClient.getOidcCacheHits());
    }

    @Test
    public void clientCertTest() throws Exception {
        try (MockIpdServer sslMockIdpServer = MockIpdServer.forKeySet(TestJwk.Jwks.ALL).useCustomTlsConfig(IDP_TLS_CONFIG).requireTlsClientCertFingerprint("67f4d3453f1d52c7d3868e76f052cfd696a18bf4a70d8ececd6306e2428bec96").start();){
            TLSConfig tlsConfig = new TLSConfig.Builder().trust(FileHelper.getAbsoluteFilePathFromClassPath((String)"oidc/idp/root-ca.pem").toFile()).clientCert(FileHelper.getAbsoluteFilePathFromClassPath((String)"oidc/idp/client.pem").toFile(), FileHelper.getAbsoluteFilePathFromClassPath((String)"oidc/idp/client.key").toFile(), "secret").build();
            OpenIdProviderClient openIdProviderClient = new OpenIdProviderClient(sslMockIdpServer.getDiscoverUri(), tlsConfig, null, true);
            KeySetRetriever keySetRetriever = new KeySetRetriever(openIdProviderClient);
            keySetRetriever.get();
        }
    }

    static {
        try {
            IDP_TLS_CONFIG = new TLSConfig.Builder().trust(FileHelper.getAbsoluteFilePathFromClassPath((String)"oidc/idp/root-ca.pem").toFile()).clientCert(FileHelper.getAbsoluteFilePathFromClassPath((String)"oidc/idp/idp.pem").toFile(), FileHelper.getAbsoluteFilePathFromClassPath((String)"oidc/idp/idp.key").toFile(), "secret").build();
        }
        catch (ConfigValidationException | FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        REQUEST_HEADER_ADDING_FILTER = new WireMockRequestHeaderAddingFilter("Proxy", "wire-mock");
        wireMockProxy = new WireMockRule((Options)WireMockConfiguration.options().bindAddress("127.0.0.8").trustAllProxyTargets(true).enableBrowserProxying(true).dynamicPort().extensions(new Extension[]{REQUEST_HEADER_ADDING_FILTER}));
    }
}

