/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.ldap;

import co.elastic.clients.elasticsearch.core.SearchResponse;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.client.RestHighLevelClient;
import com.floragunn.searchguard.enterprise.auth.ldap.TestLdapDirectory;
import com.floragunn.searchguard.enterprise.auth.ldap.TestLdapServer;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.certificate.TestCertificate;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.http.Header;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class LdapIntegrationTest {
    static TestCertificates certificatesContext = TestCertificates.builder().build();
    static TestCertificate ldapServerCertificate = certificatesContext.create("CN=ldap.example.com,OU=MyOU,O=MyO");
    static String PICTURE_OF_THORE = "U2VhcmNoIEd1YXJk==";
    static TestLdapDirectory.Entry KARLOTTA = new TestLdapDirectory.Entry("cn=Karlotta,ou=people,o=TEST").cn("Karlotta").uid("karlotta").userpassword("karlottas-secret").displayName("Karlotta Karl").objectClass("inetOrgPerson");
    static TestLdapDirectory.Entry THORE = new TestLdapDirectory.Entry("cn=Thore,ou=people,o=TEST").cn("Thore").uid("tho").userpassword("tho-secret").objectClass("inetOrgPerson").attr("departmentnumber", "a", "b").attr("jpegPhoto", PICTURE_OF_THORE).attr("businessCategory", "bc_1");
    static TestLdapDirectory.Entry PAUL = new TestLdapDirectory.Entry("cn=Paul,ou=people,o=TEST").cn("Paul").uid("paule").userpassword("p-secret").objectClass("inetOrgPerson");
    static TestLdapDirectory.Entry TILDA_ADDITIONAL_USER_INFORMATION_ENTRY = new TestLdapDirectory.Entry("cn=Tilda,ou=people,o=TEST").cn("Tilda").uid("tilda_additional_user_information").userpassword("p-undefined").objectClass("inetOrgPerson");
    static TestLdapDirectory.Entry ALL_ACCESS_GROUP = new TestLdapDirectory.Entry("cn=all_access,ou=groups,o=TEST").cn("all_access").objectClass("groupOfUniqueNames").uniqueMember(KARLOTTA);
    static TestLdapDirectory.Entry STD_ACCESS_GROUP = new TestLdapDirectory.Entry("cn=std_access,ou=groups,o=TEST").cn("std_access").objectClass("groupOfUniqueNames").attr("description", "My Description").attr("businessCategory", "x").uniqueMember(THORE);
    static TestLdapDirectory.Entry BUSINESS_CATEGORY_1_GROUP = new TestLdapDirectory.Entry("cn=bc_1,ou=groups,o=TEST").cn("bc_1").objectClass("groupOfUniqueNames").attr("businessCategory", "bc_1");
    static TestLdapDirectory.Entry RECURSIVE_GROUP_1 = new TestLdapDirectory.Entry("cn=recursive1,ou=groups,o=TEST").cn("recursive1").objectClass("groupOfUniqueNames").attr("businessCategory", "c").uniqueMember(PAUL, TILDA_ADDITIONAL_USER_INFORMATION_ENTRY);
    static TestLdapDirectory.Entry RECURSIVE_GROUP_2 = new TestLdapDirectory.Entry("cn=recursive2,ou=groups,o=TEST").cn("recursive2").objectClass("groupOfUniqueNames").attr("businessCategory", "d").uniqueMember(RECURSIVE_GROUP_1);
    static TestLdapDirectory.Entry RECURSIVE_GROUP_3 = new TestLdapDirectory.Entry("cn=recursive3,ou=groups,o=TEST").cn("recursive3").objectClass("groupOfUniqueNames").attr("businessCategory", "e").uniqueMember(RECURSIVE_GROUP_1);
    static TestLdapServer tlsLdapServer = TestLdapServer.with(TestLdapDirectory.BASE, new TestLdapDirectory.Entry[]{KARLOTTA, THORE, PAUL, TILDA_ADDITIONAL_USER_INFORMATION_ENTRY, ALL_ACCESS_GROUP, STD_ACCESS_GROUP, RECURSIVE_GROUP_1, RECURSIVE_GROUP_2, RECURSIVE_GROUP_3, BUSINESS_CATEGORY_1_GROUP}).tls(ldapServerCertificate).build();
    static TestSgConfig.User TILDA_ADDITIONAL_USER_INFORMATION_USER = new TestSgConfig.User("tilda_additional_user_information").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("role").clusterPermissions(new String[]{"*"})});
    static TestSgConfig.Role INDEX_PATTERN_WITH_ATTR = new TestSgConfig.Role("sg_index_pattern_with_attr_role").clusterPermissions(new String[]{"SGS_CLUSTER_COMPOSITE_OPS_RO"}).indexPermissions(new String[]{"SGS_CRUD"}).on(new String[]{"/attr_test_${user.attrs.pattern|toRegexFragment}/"});
    static TestSgConfig.Role INDEX_PATTERN_WITH_ATTR_FOR_RECURSIVE_GROUPS = new TestSgConfig.Role("sg_index_pattern_with_attr_role_for_recursive_groups").clusterPermissions(new String[]{"SGS_CLUSTER_COMPOSITE_OPS_RO"}).indexPermissions(new String[]{"SGS_CRUD"}).on(new String[]{"/attr_test_${user.attrs.pattern_rec|toRegexFragment}/"});
    static TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/ldap").description("using raw filter queries").backend(DocNode.of((String)"idp.hosts", (Object)"#{var:ldapHost}", (String)"idp.tls.trusted_cas", (Object)certificatesContext.getCaCertificate().getCertificateString(), (String)"idp.tls.verify_hostnames", (Object)false, (String)"user_search.filter.raw", (Object)"(uid=${user.name})", (String)"group_search.base_dn", (Object)TestLdapDirectory.GROUPS.getDn(), (Object[])new Object[]{"group_search.filter.raw", "(uniqueMember=${dn})", "group_search.role_name_attribute", "dn", "group_search.recursive.enabled", true})).skipIps(new String[]{"127.0.0.16/30"}).userMapping(new TestSgConfig.Authc.Domain.UserMapping().attrsFrom("pattern", "ldap_user_entry.departmentnumber").attrsFrom("pattern_rec", "ldap_group_entries[*].businessCategory[*]")), new TestSgConfig.Authc.Domain("basic/ldap").description("using by_attribute filter queries and getting user name from ldap_user_entry.displayName").backend(DocNode.of((String)"idp.hosts", (Object)"#{var:ldapHost}", (String)"idp.tls.trusted_cas", (Object)certificatesContext.getCaCertificate().getCertificateString(), (String)"idp.tls.verify_hostnames", (Object)false, (String)"user_search.filter.by_attribute", (Object)"uid", (String)"group_search.base_dn", (Object)TestLdapDirectory.GROUPS.getDn(), (Object[])new Object[]{"group_search.filter.by_attribute", "uniqueMember", "group_search.role_name_attribute", "dn", "group_search.recursive.enabled", true})).acceptIps(new String[]{"127.0.0.17"}).userMapping(new TestSgConfig.Authc.Domain.UserMapping().userNameFromBackend("ldap_user_entry.displayName").attrsFrom("pattern", "ldap_user_entry.departmentnumber").attrsFrom("pattern_rec", "ldap_group_entries[*].businessCategory[*]")), new TestSgConfig.Authc.Domain("basic/ldap").description("group search based on attribute of ldap_user_entry").backend(DocNode.of((String)"idp.hosts", (Object)"#{var:ldapHost}", (String)"idp.tls.trusted_cas", (Object)certificatesContext.getCaCertificate().getCertificateString(), (String)"idp.tls.verify_hostnames", (Object)false, (String)"user_search.filter.by_attribute", (Object)"uid", (String)"group_search.base_dn", (Object)TestLdapDirectory.GROUPS.getDn(), (Object[])new Object[]{"group_search.filter.raw", "(businessCategory=${ldap_user_entry.businessCategory})", "group_search.role_name_attribute", "dn", "group_search.recursive.enabled", true})).acceptIps(new String[]{"127.0.0.18"}).userMapping(new TestSgConfig.Authc.Domain.UserMapping().attrsFrom("pattern", "ldap_user_entry.departmentnumber").attrsFrom("pattern_rec", "ldap_group_entries[*].businessCategory[*]")), new TestSgConfig.Authc.Domain("basic/ldap").description("using retrieve_attributes setting").backend(DocNode.of((String)"idp.hosts", (Object)"#{var:ldapHost}", (String)"idp.tls.trusted_cas", (Object)certificatesContext.getCaCertificate().getCertificateString(), (String)"idp.tls.verify_hostnames", (Object)false, (String)"user_search.filter.by_attribute", (Object)"uid", (String)"user_search.retrieve_attributes", (Object)"uid", (Object[])new Object[]{"group_search.base_dn", TestLdapDirectory.GROUPS.getDn(), "group_search.filter.by_attribute", "uniqueMember", "group_search.role_name_attribute", "dn", "group_search.retrieve_attributes", "businessCategory", "group_search.recursive.enabled", true})).acceptIps(new String[]{"127.0.0.19"}).userMapping(new TestSgConfig.Authc.Domain.UserMapping().userNameFromBackend("ldap_user_entry.uid")), new TestSgConfig.Authc.Domain("basic/internal_users_db").additionalUserInformation(new TestSgConfig.Authc.Domain.AdditionalUserInformation[]{new TestSgConfig.Authc.Domain.AdditionalUserInformation("ldap", DocNode.of((String)"idp.hosts", (Object)"#{var:ldapHost}", (String)"idp.tls.trusted_cas", (Object)certificatesContext.getCaCertificate().getCertificateString(), (String)"idp.tls.verify_hostnames", (Object)false, (String)"user_search.filter.raw", (Object)"(uid=${user.name})", (String)"group_search.base_dn", (Object)TestLdapDirectory.GROUPS.getDn(), (Object[])new Object[]{"group_search.filter.raw", "(uniqueMember=${dn})", "group_search.role_name_attribute", "dn", "group_search.recursive.enabled", true}))}).userMapping(new TestSgConfig.Authc.Domain.UserMapping().attrsFrom("pattern", "ldap_user_entry.departmentnumber").attrsFrom("pattern_rec", "ldap_group_entries[*].businessCategory[*]"))}).debug().userCacheEnabled(false);
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().singleNode().sslEnabled().enterpriseModulesEnabled().resources("ldap").roles(new TestSgConfig.Role[]{TestSgConfig.Role.ALL_ACCESS, INDEX_PATTERN_WITH_ATTR, INDEX_PATTERN_WITH_ATTR_FOR_RECURSIVE_GROUPS}).roleToRoleMapping(TestSgConfig.Role.ALL_ACCESS, new String[]{ALL_ACCESS_GROUP.getDn()}).roleToRoleMapping(INDEX_PATTERN_WITH_ATTR, new String[]{STD_ACCESS_GROUP.getDn()}).roleToRoleMapping(INDEX_PATTERN_WITH_ATTR_FOR_RECURSIVE_GROUPS, new String[]{RECURSIVE_GROUP_3.getDn()}).authc(AUTHC).users(new TestSgConfig.User[]{TILDA_ADDITIONAL_USER_INFORMATION_USER}).var("ldapHost", () -> tlsLdapServer.hostAndPort()).embedded().build();
    @ClassRule
    public static TestRule serverChain = RuleChain.outerRule((TestRule)tlsLdapServer).around((TestRule)cluster);

    @BeforeClass
    public static void initTestData() {
        Client tc = cluster.getInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("attr_test_a").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"a\", \"amount\": 1010}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("attr_test_b").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"b\", \"amount\": 2020}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("attr_test_c").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"c\", \"amount\": 3030}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("attr_test_d").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"d\", \"amount\": 4040}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("attr_test_e").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"filter_attr\": \"e\", \"amount\": 5050}", XContentType.JSON)).actionGet();
    }

    @Test
    public void name_fromLdapEntry() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)KARLOTTA, new Header[0]);){
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 17}));
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)"Karlotta Karl", (Object)response.getBodyAsDocNode().get("user_name"));
        }
    }

    @Test
    public void roles() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)KARLOTTA, new Header[0]);){
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 17}));
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), Arrays.asList("cn=all_access,ou=groups,o=TEST"), (Object)response.getBodyAsDocNode().get("backend_roles"));
        }
    }

    @Test
    public void roles_rawQuery() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)KARLOTTA, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), Arrays.asList("cn=all_access,ou=groups,o=TEST"), (Object)response.getBodyAsDocNode().get("backend_roles"));
        }
    }

    @Test
    public void roles_groupSearchWithLdapEntry() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)THORE, new Header[0]);){
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 18}));
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), Arrays.asList("cn=bc_1,ou=groups,o=TEST"), (Object)response.getBodyAsDocNode().get("backend_roles"));
        }
    }

    @Test
    public void attributeIntegrationTest() throws Exception {
        SearchResponse searchResponse;
        try (RestHighLevelClient client = cluster.getRestHighLevelClient((EsClientProvider.UserCredentialsHolder)KARLOTTA);){
            searchResponse = client.search("attr_test_*", 0, 100);
            Assert.assertEquals((long)5L, (long)searchResponse.hits().total().value());
        }
        client = cluster.getRestHighLevelClient((EsClientProvider.UserCredentialsHolder)THORE);
        try {
            searchResponse = client.search("attr_test_*", 0, 100);
            Assert.assertEquals((long)2L, (long)searchResponse.hits().total().value());
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void attributeIntegrationTest_recursiveGroups() throws Exception {
        try (RestHighLevelClient client = cluster.getRestHighLevelClient((EsClientProvider.UserCredentialsHolder)PAUL);){
            SearchResponse searchResponse = client.search("attr_test_*", 0, 100);
            Assert.assertEquals((long)3L, (long)searchResponse.hits().total().value());
        }
    }

    @Test
    public void additionalUserInformation() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)TILDA_ADDITIONAL_USER_INFORMATION_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)TILDA_ADDITIONAL_USER_INFORMATION_USER.getName(), (Object)response.getBodyAsDocNode().get("user_name"));
            Assert.assertEquals((String)response.getBody(), (Object)ImmutableSet.of((Object)RECURSIVE_GROUP_1.getDn(), (Object[])new String[]{RECURSIVE_GROUP_2.getDn(), RECURSIVE_GROUP_3.getDn()}), (Object)ImmutableSet.of((Collection)((Collection)response.getBodyAsDocNode().get("backend_roles"))));
            Assert.assertTrue((String)response.getBody(), (boolean)((Collection)response.getBodyAsDocNode().get("sg_roles")).contains("user_tilda_additional_user_information__role"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("pattern_rec"), (Object)response.getBodyAsDocNode().get("attribute_names"));
        }
    }

    @Test
    public void testAuthDomainInfo() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)KARLOTTA, new Header[0]);){
            GenericRestClient.HttpResponse response = restClient.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertTrue((String)response.getBody(), (boolean)response.getBodyAsDocNode().getAsString("user").startsWith("User karlotta <basic/ldap>"));
        }
    }

    @Test
    public void wrongPassword() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(KARLOTTA.getName(), "wrong-password", new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
        }
    }

    @Test
    public void userNotFound() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("unknown-user", "password", new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
        }
    }

    @Test
    public void retrieveAttributes() throws Exception {
        GenericRestClient.HttpResponse response;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)THORE, new Header[0]);){
            response = client.get("/_searchguard/auth/debug", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), Arrays.asList(PICTURE_OF_THORE), (Object)response.getBodyAsDocNode().findByJsonPath("$.debug[?(@.method=='basic/ldap' && @.message=='Backends successful')].details.user_mapping_attributes.ldap_user_entry.jpegPhoto[0]"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("My Description"), (Object)response.getBodyAsDocNode().findByJsonPath("$.debug[?(@.method=='basic/ldap' && @.message=='Backends successful')].details.user_mapping_attributes.ldap_group_entries[*].description[0]"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("x"), (Object)response.getBodyAsDocNode().findByJsonPath("$.debug[?(@.method=='basic/ldap' && @.message=='Backends successful')].details.user_mapping_attributes.ldap_group_entries[*].businessCategory[0]"));
        }
        client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)THORE, new Header[0]);
        try {
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 19}));
            response = client.get("/_searchguard/auth/debug", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), Collections.emptyList(), (Object)response.getBodyAsDocNode().findByJsonPath("$.debug[?(@.method=='basic/ldap' && @.message=='Backends successful')].details.user_mapping_attributes.ldap_user_entry.jpegPhoto[0]"));
            Assert.assertEquals((String)response.getBody(), Collections.emptyList(), (Object)response.getBodyAsDocNode().findByJsonPath("$.debug[?(@.method=='basic/ldap' && @.message=='Backends successful')].details.user_mapping_attributes.ldap_group_entries[*].description[0]"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("x"), (Object)response.getBodyAsDocNode().findByJsonPath("$.debug[?(@.method=='basic/ldap' && @.message=='Backends successful')].details.user_mapping_attributes.ldap_group_entries[*].businessCategory[0]"));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }
}

