/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import com.floragunn.codova.documents.BasicJsonPathDefaultConfiguration;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchguard.authtoken.AuthTokenModule;
import com.floragunn.searchguard.authtoken.RequestedPrivileges;
import com.floragunn.searchguard.authtoken.api.CreateAuthTokenRequest;
import com.floragunn.searchguard.client.RestHighLevelClient;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestComponentTemplate;
import com.floragunn.searchguard.test.TestIndexTemplate;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchguard.test.helper.cluster.LocalEsCluster;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import com.floragunn.searchsupport.junit.matcher.ExceptionsMatchers;
import com.google.common.io.BaseEncoding;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.Collections;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class AuthTokenIntegrationTest {
    public static final int MAX_TOKEN_PER_USER = 10;
    private static String SGCONFIG = "_sg_meta:\n  type: \"config\"\n  config_version: 2\n\nsg_config:\n  dynamic:\n    auth_token_provider: \n      enabled: true\n      jwt_signing_key_hs512: \"eTDZjSqRD9Abhod9iqeGX_7o93a-eElTeXWAF6FmzQshmRIrPD-C9ET3pFjJ_IBrzmWIZDk8ig-X_PIyGmKsxNMsrU-0BNWF5gJq5xOp4rYTl8z66Tw9wr8tHLxLxgJqkLSuUCRBZvlZlQ7jNdhBBxgM-hdSSzsN1T33qdIwhrUeJ-KXI5yKUXHjoWFYb9tETbYQ4NvONowkCsXK_flp-E3F_OcKe_z5iVUszAV8QfCod1zhbya540kDejXCL6N_XMmhWJqum7UJ3hgf6DEtroPSnVpHt4iR5w9ArKK-IBgluPght03gNcoNqwz7p77TFbdOmUKF_PWy1bcdbaUoSg\"\n      jwt_aud: \"searchguard_tokenauth\"\n      max_validity: \"1y\"\n      max_tokens_per_user: 10\n      token_cache:\n        expire_after_write: 70m\n        max_size: 100";
    static TestSgConfig sgConfig = new TestSgConfig().resources("authtoken").sgConfigSettings("", (Object)TestSgConfig.fromYaml((String)SGCONFIG), new Object[0]);
    private static Configuration JSON_PATH_CONFIG = BasicJsonPathDefaultConfiguration.defaultConfiguration().setOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
    static TestSgConfig.User USER_ALIAS_PUB_ACCESS = new TestSgConfig.User("user_alias_pub_access").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("alias_pub_access").clusterPermissions(new String[]{"cluster:admin:searchguard:authtoken/_own/*"}).aliasPermissions(new String[]{"READ"}).on(new String[]{"alias_pub*"})});
    static TestSgConfig.User USER_DATA_STREAM_PUB_ACCESS = new TestSgConfig.User("user_ds_pub_access").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("ds_pub_access").clusterPermissions(new String[]{"cluster:admin:searchguard:authtoken/_own/*"}).dataStreamPermissions(new String[]{"READ"}).on(new String[]{"ds_pub*"})});
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().nodeSettings(new Object[]{"searchguard.restapi.roles_enabled.0", "sg_admin"}).sslEnabled().sgConfig(sgConfig).enterpriseModulesEnabled().enableModule(AuthTokenModule.class).useExternalProcessCluster().authc(new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db").userMapping(new TestSgConfig.Authc.Domain.UserMapping().attrsFrom("index", "user_entry.attributes.test_attr_1.c").attrsFrom("all", "user_entry.attributes.test_attr_1"))})).indexTemplates(new TestIndexTemplate[]{new TestIndexTemplate("ds_test", new String[]{"ds_*"}).dataStream().composedOf(new TestComponentTemplate[]{TestComponentTemplate.DATA_STREAM_MINIMAL})}).users(new TestSgConfig.User[]{USER_ALIAS_PUB_ACCESS, USER_DATA_STREAM_PUB_ACCESS}).build();

    @BeforeClass
    public static void setupTestData() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.postJson("/pub_test_deny/_doc?refresh=true", (Map)DocNode.of((String)"this_is", (Object)"not_allowed_from_token"), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isCreated());
            response = client.postJson("/pub_test_allow_because_from_token/_doc?refresh=true", (Map)DocNode.of((String)"this_is", (Object)"allowed"), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isCreated());
            response = client.postJson("/user_attr_foo/_doc?refresh=true", (Map)DocNode.of((String)"this_is", (Object)"allowed"), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isCreated());
            response = client.postJson("/user_attr_qux/_doc?refresh=true", (Map)DocNode.of((String)"this_is", (Object)"not_allowed"), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isCreated());
            response = client.postJson("/dls_user_attr/_doc?refresh=true", (Map)DocNode.of((String)"this_is", (Object)"allowed", (String)"a", (Object)"foo"), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isCreated());
            response = client.postJson("/dls_user_attr/_doc?refresh=true", (Map)DocNode.of((String)"this_is", (Object)"not_allowed", (String)"a", (Object)"qux"), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isCreated());
            response = client.postJson("/_aliases", (Map)DocNode.of((String)"actions", (Object)DocNode.array((Object[])new Object[]{DocNode.of((String)"add", (Object)DocNode.of((String)"index", (Object)"pub_test_deny", (String)"alias", (Object)"alias_pub_test_deny")), DocNode.of((String)"add", (Object)DocNode.of((String)"index", (Object)"pub_test_allow_because_from_token", (String)"alias", (Object)"alias_pub_test_allow_because_from_token"))})), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            response = client.put("/_data_stream/ds_pub_test_deny");
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            response = client.put("/_data_stream/ds_pub_test_allow_because_from_token");
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            response = client.postJson("/ds_pub_test_deny/_doc?refresh=true", (Map)DocNode.of((String)"@timestamp", (Object)"2024-05-06T10:11:15.000Z", (String)"this_is", (Object)"not_allowed_from_token"), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isCreated());
            response = client.postJson("/ds_pub_test_allow_because_from_token/_doc?refresh=true", (Map)DocNode.of((String)"@timestamp", (Object)"2024-05-06T10:11:15.000Z", (String)"this_is", (Object)"allowed"), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isCreated());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tokenWithDefaultSigningKeyTest() throws Exception {
        DocNode updatedConfig;
        try {
            GenericRestClient.HttpResponse response;
            String tokenWithDefaultSigningKey;
            String tokenWithConfiguredSigningKey;
            try (GenericRestClient restClient = cluster.getRestClient("spock", "spock", new Header[0]);){
                CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*_from_token'\n  allowed_actions: '*'"));
                request.setTokenName("token_with_configured_signing_key");
                GenericRestClient.HttpResponse response2 = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
                MatcherAssert.assertThat((Object)response2, (Matcher)RestMatchers.isOk());
                tokenWithConfiguredSigningKey = response2.getBodyAsDocNode().getAsString("token");
                MatcherAssert.assertThat((Object)tokenWithConfiguredSigningKey, (Matcher)Matchers.notNullValue());
            }
            DocNode config = DocNode.of((String)"enabled", (Object)true);
            updatedConfig = this.updateAuthTokenServiceConfig(config);
            MatcherAssert.assertThat((Object)updatedConfig.get("jwt_signing_key"), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)updatedConfig.get("jwt_signing_key_hs512"), (Matcher)Matchers.nullValue());
            try (GenericRestClient restClient = cluster.getRestClient("spock", "spock", new Header[0]);){
                CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*_from_token'\n  allowed_actions: '*'"));
                request.setTokenName("token_with_default_signing_key");
                GenericRestClient.HttpResponse response3 = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
                System.out.println(response3.getBody());
                MatcherAssert.assertThat((Object)response3, (Matcher)RestMatchers.isOk());
                tokenWithDefaultSigningKey = response3.getBodyAsDocNode().getAsString("token");
                MatcherAssert.assertThat((Object)tokenWithDefaultSigningKey, (Matcher)Matchers.notNullValue());
                MatcherAssert.assertThat((Object)AuthTokenIntegrationTest.getJwtHeaderValue(tokenWithDefaultSigningKey, "alg"), (Matcher)Matchers.equalTo((Object)"HS512"));
            }
            try (GenericRestClient client = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer " + tokenWithConfiguredSigningKey)});){
                response = client.postJson("/pub_test_allow_because_from_token/_search", "{\"query\":{\"match_all\":{}}}", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isUnauthorized());
                response = client.postJson("/pub_test_deny/_search", "{\"query\":{\"match_all\":{}}}", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isUnauthorized());
            }
            client = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer " + tokenWithDefaultSigningKey)});
            try {
                response = client.postJson("/pub_test_allow_because_from_token/_search", "{\"query\":{\"match_all\":{}}}", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
                response = client.postJson("/pub_test_deny/_search", "{\"query\":{\"match_all\":{}}}", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isForbidden());
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
        finally {
            DocNode originalConfig = DocNode.parse((Format)Format.YAML).from(SGCONFIG).findSingleNodeByJsonPath("sg_config.dynamic.auth_token_provider");
            updatedConfig = this.updateAuthTokenServiceConfig(originalConfig);
            MatcherAssert.assertThat((Object)updatedConfig, (Matcher)Matchers.anyOf((Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"jwt_signing_key"), (Matcher)Matchers.notNullValue()), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"jwt_signing_key_hs512"), (Matcher)Matchers.notNullValue())));
        }
    }

    @Test
    public void basicTest_indexAccess() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("spock", "spock", new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*_from_token'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token");
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)AuthTokenIntegrationTest.getJwtHeaderValue(token, "alg"), (Matcher)Matchers.equalTo((Object)"HS512"));
            String tokenPayload = AuthTokenIntegrationTest.getJwtPayload(token);
            Map parsedTokenPayload = DocReader.json().readObject(tokenPayload);
            MatcherAssert.assertThat((String)tokenPayload, (Object)((String)JsonPath.using((Configuration)BasicJsonPathDefaultConfiguration.defaultConfiguration()).parse((Object)parsedTokenPayload).read("sub", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"spock"));
            MatcherAssert.assertThat((String)tokenPayload, (Object)JsonPath.using((Configuration)JSON_PATH_CONFIG).parse((Object)parsedTokenPayload).read("base.c", new Predicate[0]), (Matcher)Matchers.notNullValue());
            try (RestHighLevelClient client = cluster.getRestHighLevelClient("spock", "spock");){
                SearchResponse searchResponse = client.search("pub_test_allow_because_from_token");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
                searchResponse = client.search("pub_test_deny");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"not_allowed_from_token"));
            }
            for (LocalEsCluster.Node node : cluster.nodes()) {
                RestHighLevelClient client = node.getRestHighLevelClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
                try {
                    SearchResponse searchResponse = client.search("pub_test_allow_because_from_token");
                    MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                    MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
                    ThrowableAssert.assertThatThrown(() -> client.search("pub_test_deny"), (Matcher[])new Matcher[]{ExceptionsMatchers.messageContainsMatcher((String)"Insufficient permissions")});
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
        }
    }

    @Test
    public void basicTest_aliasAccess() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ALIAS_PUB_ACCESS, new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"alias_permissions:\n- alias_patterns: '*_from_token'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token");
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)AuthTokenIntegrationTest.getJwtHeaderValue(token, "alg"), (Matcher)Matchers.equalTo((Object)"HS512"));
            String tokenPayload = AuthTokenIntegrationTest.getJwtPayload(token);
            Map parsedTokenPayload = DocReader.json().readObject(tokenPayload);
            MatcherAssert.assertThat((String)tokenPayload, (Object)((String)JsonPath.using((Configuration)BasicJsonPathDefaultConfiguration.defaultConfiguration()).parse((Object)parsedTokenPayload).read("sub", new Predicate[0])), (Matcher)Matchers.equalTo((Object)USER_ALIAS_PUB_ACCESS.getName()));
            MatcherAssert.assertThat((String)tokenPayload, (Object)JsonPath.using((Configuration)JSON_PATH_CONFIG).parse((Object)parsedTokenPayload).read("base.c", new Predicate[0]), (Matcher)Matchers.notNullValue());
            DocNode matchAllQuery = DocNode.of((String)"query", (Object)DocNode.of((String)"match_all", (Object)DocNode.EMPTY));
            try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ALIAS_PUB_ACCESS, new Header[0]);){
                GenericRestClient.HttpResponse searchResponse = client.postJson("/alias_pub_test_allow_because_from_token/_search", (Map)matchAllQuery, new Header[0]);
                DocNode body = searchResponse.getBodyAsDocNode();
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.hits.total.value", (Object)1L));
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.hits.hits[0]._source.this_is", (Object)"allowed"));
                searchResponse = client.postJson("/alias_pub_test_deny/_search", (Map)matchAllQuery, new Header[0]);
                body = searchResponse.getBodyAsDocNode();
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.hits.total.value", (Object)1L));
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.hits.hits[0]._source.this_is", (Object)"not_allowed_from_token"));
            }
            for (LocalEsCluster.Node node : cluster.nodes()) {
                GenericRestClient client = node.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
                try {
                    GenericRestClient.HttpResponse searchResponse = client.postJson("/alias_pub_test_allow_because_from_token/_search", (Map)matchAllQuery, new Header[0]);
                    DocNode body = searchResponse.getBodyAsDocNode();
                    MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.hits.total.value", (Object)1L));
                    MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.hits.hits[0]._source.this_is", (Object)"allowed"));
                    searchResponse = client.postJson("/alias_pub_test_deny/_search", (Map)matchAllQuery, new Header[0]);
                    MatcherAssert.assertThat((Object)searchResponse, (Matcher)RestMatchers.isForbidden());
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
        }
    }

    @Test
    public void basicTest_dataStreamAccess() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_DATA_STREAM_PUB_ACCESS, new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"data_stream_permissions:\n- data_stream_patterns: '*_from_token'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token");
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)AuthTokenIntegrationTest.getJwtHeaderValue(token, "alg"), (Matcher)Matchers.equalTo((Object)"HS512"));
            String tokenPayload = AuthTokenIntegrationTest.getJwtPayload(token);
            Map parsedTokenPayload = DocReader.json().readObject(tokenPayload);
            MatcherAssert.assertThat((String)tokenPayload, (Object)((String)JsonPath.using((Configuration)BasicJsonPathDefaultConfiguration.defaultConfiguration()).parse((Object)parsedTokenPayload).read("sub", new Predicate[0])), (Matcher)Matchers.equalTo((Object)USER_DATA_STREAM_PUB_ACCESS.getName()));
            MatcherAssert.assertThat((String)tokenPayload, (Object)JsonPath.using((Configuration)JSON_PATH_CONFIG).parse((Object)parsedTokenPayload).read("base.c", new Predicate[0]), (Matcher)Matchers.notNullValue());
            DocNode matchAllQuery = DocNode.of((String)"query", (Object)DocNode.of((String)"match_all", (Object)DocNode.EMPTY));
            try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_DATA_STREAM_PUB_ACCESS, new Header[0]);){
                GenericRestClient.HttpResponse searchResponse = client.postJson("/ds_pub_test_allow_because_from_token/_search", (Map)matchAllQuery, new Header[0]);
                DocNode body = searchResponse.getBodyAsDocNode();
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.hits.total.value", (Object)1L));
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.hits.hits[0]._source.this_is", (Object)"allowed"));
                searchResponse = client.postJson("/ds_pub_test_deny/_search", (Map)matchAllQuery, new Header[0]);
                body = searchResponse.getBodyAsDocNode();
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.hits.total.value", (Object)1L));
                MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.hits.hits[0]._source.this_is", (Object)"not_allowed_from_token"));
            }
            for (LocalEsCluster.Node node : cluster.nodes()) {
                GenericRestClient client = node.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
                try {
                    GenericRestClient.HttpResponse searchResponse = client.postJson("/ds_pub_test_allow_because_from_token/_search", (Map)matchAllQuery, new Header[0]);
                    DocNode body = searchResponse.getBodyAsDocNode();
                    MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.hits.total.value", (Object)1L));
                    MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.hits.hits[0]._source.this_is", (Object)"allowed"));
                    searchResponse = client.postJson("/ds_pub_test_deny/_search", (Map)matchAllQuery, new Header[0]);
                    MatcherAssert.assertThat((Object)searchResponse, (Matcher)RestMatchers.isForbidden());
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
        }
    }

    @Test
    public void basicTestUnfrozenPrivileges() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("spock", "spock", new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*_from_token'\n  allowed_actions: '*'"));
            request.setFreezePrivileges(false);
            request.setTokenName("my_new_token_unfrozen_privileges");
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)AuthTokenIntegrationTest.getJwtHeaderValue(token, "alg"), (Matcher)Matchers.equalTo((Object)"HS512"));
            String tokenPayload = AuthTokenIntegrationTest.getJwtPayload(token);
            Map parsedTokenPayload = DocReader.json().readObject(tokenPayload);
            MatcherAssert.assertThat((String)tokenPayload, (Object)((String)JsonPath.using((Configuration)BasicJsonPathDefaultConfiguration.defaultConfiguration()).parse((Object)parsedTokenPayload).read("sub", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"spock"));
            MatcherAssert.assertThat((String)tokenPayload, (Object)JsonPath.using((Configuration)JSON_PATH_CONFIG).parse((Object)parsedTokenPayload).read("base.c", new Predicate[0]), (Matcher)Matchers.nullValue());
            try (RestHighLevelClient client = cluster.getRestHighLevelClient("spock", "spock");){
                SearchResponse searchResponse = client.search("pub_test_allow_because_from_token");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
                searchResponse = client.search("pub_test_deny");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"not_allowed_from_token"));
            }
            for (LocalEsCluster.Node node : cluster.nodes()) {
                RestHighLevelClient client = node.getRestHighLevelClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
                try {
                    SearchResponse searchResponse = client.search("pub_test_allow_because_from_token");
                    MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                    MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
                    ThrowableAssert.assertThatThrown(() -> client.search("pub_test_deny"), (Matcher[])new Matcher[]{ExceptionsMatchers.messageContainsMatcher((String)"Insufficient permissions")});
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
        }
    }

    @Test
    public void maxTokenCountTest() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("nagilum", "nagilum", new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*_from_token'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token");
            for (int i = 0; i < 10; ++i) {
                GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            }
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isForbidden());
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode().findSingleNodeByJsonPath("error.root_cause[0].reason").toString(), (Matcher)Matchers.equalTo((Object)"Cannot create token. Token limit per user exceeded. Max number of allowed tokens is 10"));
        }
    }

    @Test
    public void createTokenWithTokenForbidden() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("spock", "spock", new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"cluster_permissions: '*'\nindex_permissions:\n- index_patterns: '*'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token_with_with_i_am_trying_to_create_another_token");
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            try (GenericRestClient tokenAuthRestClient = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});){
                request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"cluster_permissions: '*'\nindex_permissions:\n- index_patterns: '*'\n  allowed_actions: '*'"));
                request.setTokenName("this_token_should_not_be_created");
                response = tokenAuthRestClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isForbidden());
                MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBody(), (Matcher)Matchers.containsString((String)"Insufficient permissions"));
            }
        }
    }

    @Test
    public void userAttrTest() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("picard", "picard", new Header[0]);){
            SearchResponse searchResponse;
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: 'user_attr_*'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token");
            System.out.println(request.toJson());
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            try (RestHighLevelClient client = cluster.getRestHighLevelClient("picard", "picard");){
                searchResponse = client.search("user_attr_foo");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
                ThrowableAssert.assertThatThrown(() -> client.search("user_attr_qux"), (Matcher[])new Matcher[]{ExceptionsMatchers.messageContainsMatcher((String)"Insufficient permissions")});
            }
            client = cluster.getRestHighLevelClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
            try {
                searchResponse = client.search("user_attr_foo");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
                ThrowableAssert.assertThatThrown(() -> client.search("user_attr_qux"), (Matcher[])new Matcher[]{ExceptionsMatchers.messageContainsMatcher((String)"Insufficient permissions")});
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
    }

    @Test
    public void userAttrTestDls() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("picard", "picard", new Header[0]);){
            SearchResponse searchResponse;
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token");
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            try (RestHighLevelClient client = cluster.getRestHighLevelClient("admin", "admin");){
                searchResponse = client.search("dls_user_attr");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)2L));
            }
            client = cluster.getRestHighLevelClient("picard", "picard");
            try {
                searchResponse = client.search("dls_user_attr");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
            client = cluster.getRestHighLevelClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
            try {
                searchResponse = client.search("dls_user_attr");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
    }

    @Test
    public void revocationTest() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("spock", "spock", new Header[0]);){
            RestHighLevelClient client;
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*_from_token'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token");
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            String id = response.getBodyAsDocNode().getAsString("id");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)id, (Matcher)Matchers.notNullValue());
            for (LocalEsCluster.Node node : cluster.nodes()) {
                client = node.getRestHighLevelClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
                try {
                    SearchResponse searchResponse = client.search("pub_test_allow_because_from_token");
                    MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                    MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
                    ThrowableAssert.assertThatThrown(() -> client.search("pub_test_deny"), (Matcher[])new Matcher[]{ExceptionsMatchers.messageContainsMatcher((String)"Insufficient permissions")});
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            response = restClient.delete("/_searchguard/authtoken/" + id, new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            Thread.sleep(100L);
            for (LocalEsCluster.Node node : cluster.nodes()) {
                client = node.getRestHighLevelClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
                try {
                    ElasticsearchException exception = (ElasticsearchException)ThrowableAssert.assertThatThrown(() -> client.search("pub_test_allow_because_from_token"), (Matcher[])new Matcher[]{Matchers.instanceOf(ElasticsearchException.class)});
                    MatcherAssert.assertThat((String)exception.getMessage(), (Object)exception.status(), (Matcher)Matchers.equalTo((Object)RestStatus.UNAUTHORIZED.getStatus()));
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
        }
    }

    @Test
    public void revocationWithoutSpecialPrivsTest() throws Exception {
        TestSgConfig sgConfig = AuthTokenIntegrationTest.sgConfig.clone().sgConfigSettings("sg_config.dynamic.auth_token_provider.exclude_cluster_permissions", Collections.emptyList(), new Object[0]);
        try (LocalCluster.Embedded cluster = new LocalCluster.Builder().nodeSettings(new Object[]{"searchguard.restapi.roles_enabled.0", "sg_admin"}).resources("authtoken").sslEnabled().sgConfig(sgConfig).enterpriseModulesEnabled().enableModule(AuthTokenModule.class).embedded().start();
             GenericRestClient restClient = cluster.getRestClient("spock", "spock", new Header[0]);){
            RestHighLevelClient client;
            Client internalClient = cluster.getInternalNodeClient();
            internalClient.index(((IndexRequest)new IndexRequest("pub_test_allow_because_from_token").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"this_is", "allowed"})).actionGet();
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.totalWildcard());
            request.setTokenName("my_new_token_without_special_privs");
            request.setFreezePrivileges(false);
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", request.toJson(), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            String id = response.getBodyAsDocNode().getAsString("id");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)id, (Matcher)Matchers.notNullValue());
            for (LocalEsCluster.Node node : cluster.nodes()) {
                client = node.getRestHighLevelClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
                try {
                    SearchResponse searchResponse = client.search("pub_test_allow_because_from_token");
                    MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                    MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            response = restClient.delete("/_searchguard/authtoken/" + id, new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            Thread.sleep(100L);
            for (LocalEsCluster.Node node : cluster.nodes()) {
                client = node.getRestHighLevelClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
                try {
                    ElasticsearchException exception = (ElasticsearchException)ThrowableAssert.assertThatThrown(() -> client.search("pub_test_allow_because_from_token"), (Matcher[])new Matcher[]{Matchers.instanceOf(ElasticsearchException.class)});
                    MatcherAssert.assertThat((String)exception.getMessage(), (Object)exception.status(), (Matcher)Matchers.equalTo((Object)RestStatus.UNAUTHORIZED.getStatus()));
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
        }
    }

    @Test
    public void getAndSearchTest() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("spock", "spock", new Header[0]);
             GenericRestClient picardRestClient = cluster.getRestClient("picard", "picard", new Header[0]);
             GenericRestClient adminRestClient = cluster.getRestClient("admin", "admin", new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*_from_token'\n  allowed_actions: '*'"));
            request.setTokenName("get_and_search_test_token");
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            request.setTokenName("get_and_search_test_token_2");
            response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            request.setTokenName("get_and_search_test_token_picard");
            response = picardRestClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String picardsTokenId = response.getBodyAsDocNode().getAsString("token");
            response = restClient.get("/_searchguard/authtoken/_search", new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBody(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"\"picard\"")));
            String searchRequest = "{\n    \"query\": {\n        \"wildcard\": {\n            \"token_name\": {\n                \"value\": \"get_and_search_test_*\"\n            }\n        }\n    }\n}";
            response = restClient.postJson("/_searchguard/authtoken/_search", searchRequest, new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            DocNode jsonNode = response.getBodyAsDocNode();
            MatcherAssert.assertThat((String)response.getBody(), (Object)jsonNode.getAsNode("hits", new String[]{"total", "value"}).toNumber(), (Matcher)Matchers.equalTo((Object)2));
            MatcherAssert.assertThat((String)response.getBody(), (Object)jsonNode.findSingleNodeByJsonPath("hits.hits[0]._source.user_name").toString(), (Matcher)Matchers.equalTo((Object)"spock"));
            MatcherAssert.assertThat((String)response.getBody(), (Object)jsonNode.findSingleNodeByJsonPath("hits.hits[1]._source.user_name").toString(), (Matcher)Matchers.equalTo((Object)"spock"));
            String id = ((DocNode)jsonNode.getAsNode("hits").getAsListOfNodes("hits").get(0)).getAsString("_id");
            String tokenName = ((DocNode)jsonNode.getAsNode("hits").getAsListOfNodes("hits").get(0)).getAsNode("_source").getAsString("token_name");
            response = restClient.get("/_searchguard/authtoken/" + id, new Header[0]);
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode().getAsString("token_name"), (Matcher)Matchers.equalTo((Object)tokenName));
            response = restClient.get("/_searchguard/authtoken/" + picardsTokenId, new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isNotFound());
            response = adminRestClient.postJson("/_searchguard/authtoken/_search", searchRequest, new Header[0]);
            jsonNode = response.getBodyAsDocNode();
            MatcherAssert.assertThat((String)response.getBody(), (Object)jsonNode.get("hits", new String[]{"total", "value"}), (Matcher)Matchers.equalTo((Object)3));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBody(), (Matcher)Matchers.containsString((String)"\"spock\""));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBody(), (Matcher)Matchers.containsString((String)"\"picard\""));
        }
    }

    @Test
    public void encryptedAuthTokenTest() throws Exception {
        String sgConfigWithEncryption = "_sg_meta:\n  type: \"config\"\n  config_version: 2\n\nsg_config:\n  dynamic:\n    auth_token_provider: \n      enabled: true\n      jwt_signing_key_hs512: \"0c8YGg-YdAuOqIZFMoWm0INDnZhmZmTy3ovdZ3PDeJwAQ1qEYn_sivE0960sIKl8sRQnIti7-JEUeVfeJxgpBg==\"\n      jwt_encryption_key_a256kw: \"Z74PlpmePaZg2Ubm3ipD9QE4uX45GWAPwjMHCKpb6Xk=\"\n      jwt_aud: \"searchguard_tokenauth\"\n      max_validity: \"1y\"\n    authc:\n      authentication_domain_basic_internal:\n        http_enabled: true\n        transport_enabled: true\n        order: 1\n        http_authenticator:\n          challenge: true\n          type: \"basic\"\n          config: {}\n        authentication_backend:\n          type: \"intern\"\n          config:\n            map_db_attrs_to_user_attrs:\n              index: test_attr_1.c\n              all: test_attr_1\n      sg_issued_jwt_auth_domain:\n        description: \"Authenticate via Json Web Tokens issued by Search Guard\"\n        http_enabled: true\n        transport_enabled: false\n        order: 0\n        http_authenticator:\n          type: sg_auth_token\n          challenge: false\n        authentication_backend:\n          type: sg_auth_token";
        TestSgConfig sgConfig = new TestSgConfig().resources("authtoken").sgConfigSettings("", (Object)TestSgConfig.fromYaml((String)sgConfigWithEncryption), new Object[0]);
        try (LocalCluster.Embedded cluster = new LocalCluster.Builder().resources("authtoken").sslEnabled().singleNode().sgConfig(sgConfig).enterpriseModulesEnabled().enableModule(AuthTokenModule.class).embedded().start();
             GenericRestClient restClient = cluster.getRestClient("spock", "spock", new Header[0]);){
            SearchResponse searchResponse;
            Client internalClient = cluster.getInternalNodeClient();
            internalClient.index(((IndexRequest)new IndexRequest("pub_test_deny").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"this_is", "not_allowed_from_token"})).actionGet();
            internalClient.index(((IndexRequest)new IndexRequest("pub_test_allow_because_from_token").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"this_is", "allowed"})).actionGet();
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*_from_token'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token");
            System.out.println(request.toJson());
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)AuthTokenIntegrationTest.getJwtHeaderValue(token, "alg"), (Matcher)Matchers.equalTo((Object)"A256KW"));
            MatcherAssert.assertThat((Object)AuthTokenIntegrationTest.getJwtHeaderValue(token, "enc"), (Matcher)Matchers.equalTo((Object)"A256CBC-HS512"));
            MatcherAssert.assertThat((String)("JWT payload seems to be unencrypted because it contains the user name in clear text: " + AuthTokenIntegrationTest.getJwtPayload(token)), (Object)AuthTokenIntegrationTest.getJwtPayload(token), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"spock")));
            try (RestHighLevelClient client = cluster.getRestHighLevelClient("spock", "spock");){
                searchResponse = client.search("pub_test_allow_because_from_token");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
                searchResponse = client.search("pub_test_deny");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"not_allowed_from_token"));
            }
            client = cluster.getRestHighLevelClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
            try {
                searchResponse = client.search("pub_test_allow_because_from_token");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
                ThrowableAssert.assertThatThrown(() -> client.search("pub_test_deny"), (Matcher[])new Matcher[]{ExceptionsMatchers.messageContainsMatcher((String)"Insufficient permissions")});
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
    }

    @Test
    public void ecSignedAuthTokenTest() throws Exception {
        String sgConfigWithEncryption = "_sg_meta:\n  type: \"config\"\n  config_version: 2\n\nsg_config:\n  dynamic:\n    auth_token_provider: \n      enabled: true\n      jwt_signing_key: \n        kty: EC\n        d: \"1nlQeqOq48OPWiDkmOIXLF_XBWUe9LSznBvWzPI4Ggo\"\n        use: sig\n        crv: P-256\n        x: \"lBybOJZyK6r8Nx54Jn4cKoDUZgyOdLlsQ2EHk-7LStk\"\n        y: \"BwSiCmlnS1CDetg_iuxBZKkh6VTMrra0aIT9dBeoCZU\"\n        alg: ES256\n      jwt_aud: \"searchguard_tokenauth\"\n      max_validity: \"1y\"\n    authc:\n      authentication_domain_basic_internal:\n        http_enabled: true\n        transport_enabled: true\n        order: 1\n        http_authenticator:\n          challenge: true\n          type: \"basic\"\n          config: {}\n        authentication_backend:\n          type: \"intern\"\n          config:\n            map_db_attrs_to_user_attrs:\n              index: test_attr_1.c\n              all: test_attr_1\n      sg_issued_jwt_auth_domain:\n        description: \"Authenticate via Json Web Tokens issued by Search Guard\"\n        http_enabled: true\n        transport_enabled: false\n        order: 0\n        http_authenticator:\n          type: sg_auth_token\n          challenge: false\n        authentication_backend:\n          type: sg_auth_token";
        TestSgConfig sgConfig = new TestSgConfig().resources("authtoken").sgConfigSettings("", (Object)TestSgConfig.fromYaml((String)sgConfigWithEncryption), new Object[0]);
        try (LocalCluster.Embedded cluster = new LocalCluster.Builder().resources("authtoken").sslEnabled().singleNode().sgConfig(sgConfig).enterpriseModulesEnabled().enableModule(AuthTokenModule.class).embedded().start();
             GenericRestClient restClient = cluster.getRestClient("spock", "spock", new Header[0]);){
            SearchResponse searchResponse;
            Client internalClient = cluster.getInternalNodeClient();
            internalClient.index(((IndexRequest)new IndexRequest("pub_test_deny").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"this_is", "not_allowed_from_token"})).actionGet();
            internalClient.index(((IndexRequest)new IndexRequest("pub_test_allow_because_from_token").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"this_is", "allowed"})).actionGet();
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*_from_token'\n  allowed_actions: '*'"));
            request.setTokenName("my_new_token");
            System.out.println(request.toJson());
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)AuthTokenIntegrationTest.getJwtHeaderValue(token, "alg"), (Matcher)Matchers.equalTo((Object)"ES256"));
            MatcherAssert.assertThat((String)AuthTokenIntegrationTest.getJwtPayload(token), (Object)AuthTokenIntegrationTest.getJwtPayload(token), (Matcher)Matchers.containsString((String)"spock"));
            try (RestHighLevelClient client = cluster.getRestHighLevelClient("spock", "spock");){
                searchResponse = client.search("pub_test_allow_because_from_token");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
                searchResponse = client.search("pub_test_deny");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"not_allowed_from_token"));
            }
            client = cluster.getRestHighLevelClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});
            try {
                searchResponse = client.search("pub_test_allow_because_from_token");
                MatcherAssert.assertThat((Object)searchResponse.hits().total().value(), (Matcher)Matchers.equalTo((Object)1L));
                MatcherAssert.assertThat(((Map)((Hit)searchResponse.hits().hits().get(0)).source()).get("this_is"), (Matcher)Matchers.equalTo((Object)"allowed"));
                ThrowableAssert.assertThatThrown(() -> client.search("pub_test_deny"), (Matcher[])new Matcher[]{ExceptionsMatchers.messageContainsMatcher((String)"Insufficient permissions")});
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
    }

    @Test
    public void sgAdminRestApiTest() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("admin", "admin", new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"cluster_permissions: ['*']"));
            request.setTokenName("rest_api_test_token");
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            response = restClient.get("_searchguard/api/roles", new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            try (GenericRestClient tokenAuthRestClient = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});){
                response = restClient.get("_searchguard/api/roles", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            }
        }
    }

    @Test
    public void sgAdminRestApiForbiddenTest() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("admin", "admin", new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"index_permissions:\n- index_patterns: '*_from_token'\n  allowed_actions: '*'"));
            request.setTokenName("rest_api_test_token");
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", (ToXContentObject)request);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            response = restClient.get("_searchguard/api/roles", new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            try (GenericRestClient tokenAuthRestClient = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});){
                response = tokenAuthRestClient.get("_searchguard/api/roles", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void sgAdminRestApiExclusionTest() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("admin", "admin", new Header[0]);){
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(RequestedPrivileges.parseYaml((String)"cluster_permissions: ['*']\nexclude_cluster_permissions: ['cluster:admin:searchguard:configrestapi']"));
            request.setTokenName("rest_api_test_token");
            GenericRestClient.HttpResponse response = restClient.postJson("/_searchguard/authtoken", request.toJson(), new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            String token = response.getBodyAsDocNode().getAsString("token");
            MatcherAssert.assertThat((Object)token, (Matcher)Matchers.notNullValue());
            response = restClient.get("_searchguard/api/roles", new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            try (GenericRestClient tokenAuthRestClient = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer " + token)});){
                response = tokenAuthRestClient.get("_searchguard/api/roles", new Header[0]);
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isForbidden());
            }
        }
    }

    @Test
    public void infoApiTest() throws Exception {
        try (GenericRestClient restClient = cluster.getRestClient("admin", "admin", new Header[0]);){
            GenericRestClient.HttpResponse response = restClient.get("/_searchguard/authtoken/_info", new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode().get("enabled"), (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void bulkConfigApi() throws Exception {
        DocNode config = DocNode.of((String)"jwt_signing_key_hs512", (Object)"eTDZjSqRD9Abhod9iqeGX_7o93a-eElTeXWAF6FmzQshmRIrPD-C9ET3pFjJ_IBrzmWIZDk8ig-X_PIyGmKsxNMsrU-0BNWF5gJq5xOp4rYTl8z66Tw9wr8tHLxLxgJqkLSuUCRBZvlZlQ7jNdhBBxgM-hdSSzsN1T33qdIwhrUeJ-KXI5yKUXHjoWFYb9tETbYQ4NvONowkCsXK_flp-E3F_OcKe_z5iVUszAV8QfCod1zhbya540kDejXCL6N_XMmhWJqum7UJ3hgf6DEtroPSnVpHt4iR5w9ArKK-IBgluPght03gNcoNqwz7p77TFbdOmUKF_PWy1bcdbaUoSg", (String)"max_tokens_per_user", (Object)100, (String)"enabled", (Object)true);
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            try {
                GenericRestClient.HttpResponse response = restClient.putJson("/_searchguard/config", (Document)DocNode.of((String)"auth_token_service.content", (Object)config));
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
                GenericRestClient.HttpResponse httpResponse = restClient.get("/_searchguard/config", new Header[0]);
                MatcherAssert.assertThat((Object)httpResponse, (Matcher)RestMatchers.isOk());
                MatcherAssert.assertThat((Object)httpResponse.getBodyAsDocNode().get("auth_token_service", new String[]{"content"}), (Matcher)Matchers.equalTo((Object)config.toMap()));
            }
            finally {
                DocNode configToRestore = config.with("max_tokens_per_user", (Object)10);
                GenericRestClient.HttpResponse response = restClient.putJson("/_searchguard/config", (Document)DocNode.of((String)"auth_token_service.content", (Object)configToRestore));
                MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            }
        }
    }

    private static String getJwtHeaderValue(String jwt, String headerName) throws DocumentParseException {
        int p = jwt.indexOf(46);
        String headerBase4 = jwt.substring(0, p);
        return DocNode.parse((Format)Format.JSON).from(new String(BaseEncoding.base64Url().decode((CharSequence)headerBase4))).getAsString(headerName);
    }

    private static String getJwtPayload(String jwt) {
        int p;
        int p2 = jwt.indexOf(46, (p = jwt.indexOf(46)) + 1);
        String headerBase4 = jwt.substring(p + 1, p2 != -1 ? p2 : jwt.length());
        return new String(BaseEncoding.base64Url().decode((CharSequence)headerBase4));
    }

    private DocNode updateAuthTokenServiceConfig(DocNode newConfig) throws Exception {
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = restClient.putJson("/_searchguard/config", (Document)DocNode.of((String)"auth_token_service.content", (Object)newConfig));
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            response = restClient.get("/_searchguard/config", new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode().get("auth_token_service", new String[]{"content"}), (Matcher)Matchers.equalTo((Object)newConfig.toMap()));
            DocNode docNode = response.getBodyAsDocNode().findSingleNodeByJsonPath("auth_token_service.content");
            return docNode;
        }
    }
}

