/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.dlic.rest.api.Endpoint;
import com.floragunn.searchguard.dlic.rest.api.RestApiPrivilegesEvaluator;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentBuilder;

public class PermissionsInfoAction
extends BaseRestHandler {
    private final RestApiPrivilegesEvaluator restApiPrivilegesEvaluator;
    private final ThreadPool threadPool;
    private final AuthorizationService authorizationService;
    private final SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry;

    protected PermissionsInfoAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, ClusterService cs, PrincipalExtractor principalExtractor, AuthorizationService authorizationService, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, ThreadPool threadPool, AuditLog auditLog) {
        this.threadPool = threadPool;
        this.authorizationService = authorizationService;
        this.restApiPrivilegesEvaluator = new RestApiPrivilegesEvaluator(settings, adminDNs, authorizationService, specialPrivilegesEvaluationContextProviderRegistry, principalExtractor, configPath, threadPool);
        this.specialPrivilegesEvaluationContextProviderRegistry = specialPrivilegesEvaluationContextProviderRegistry;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/api/permissionsinfo"));
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        switch (request.method()) {
            case GET: {
                return this.handleGet(request, client);
            }
        }
        throw new IllegalArgumentException(String.valueOf(request.method()) + " not supported");
    }

    private BaseRestHandler.RestChannelConsumer handleGet(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                RestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    ImmutableSet userRoles;
                    User user = (User)PermissionsInfoAction.this.threadPool.getThreadContext().getTransient("_sg_user");
                    SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext = null;
                    if (PermissionsInfoAction.this.specialPrivilegesEvaluationContextProviderRegistry != null) {
                        specialPrivilegesEvaluationContext = PermissionsInfoAction.this.specialPrivilegesEvaluationContextProviderRegistry.provide(user, PermissionsInfoAction.this.threadPool.getThreadContext());
                    }
                    boolean hasApiAccess = true;
                    if (specialPrivilegesEvaluationContext == null) {
                        remoteAddress = (TransportAddress)PermissionsInfoAction.this.threadPool.getThreadContext().getTransient("_sg_remote_address");
                        userRoles = PermissionsInfoAction.this.authorizationService.getMappedRoles(user, remoteAddress);
                    } else {
                        user = specialPrivilegesEvaluationContext.getUser();
                        remoteAddress = specialPrivilegesEvaluationContext.getCaller() != null ? specialPrivilegesEvaluationContext.getCaller() : (TransportAddress)PermissionsInfoAction.this.threadPool.getThreadContext().getTransient("_sg_remote_address");
                        userRoles = specialPrivilegesEvaluationContext.getMappedRoles();
                        hasApiAccess = specialPrivilegesEvaluationContext.isSgConfigRestApiAllowed();
                    }
                    hasApiAccess = hasApiAccess && PermissionsInfoAction.this.restApiPrivilegesEvaluator.currentUserHasRestApiAccess((Set<String>)userRoles);
                    Map<Endpoint, List<RestRequest.Method>> disabledEndpoints = PermissionsInfoAction.this.restApiPrivilegesEvaluator.getDisabledEndpointsForCurrentUser(user, (Set<String>)userRoles);
                    builder.startObject();
                    builder.field("user", user == null ? null : user.toString());
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("has_api_access", hasApiAccess);
                    builder.startObject("disabled_endpoints");
                    for (Map.Entry<Endpoint, List<RestRequest.Method>> entry : disabledEndpoints.entrySet()) {
                        builder.field(entry.getKey().name(), (Iterable)entry.getValue());
                    }
                    builder.endObject();
                    builder.endObject();
                    response = new RestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse(response);
            }
        };
    }
}

