/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import com.floragunn.codova.config.templates.Template;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authtoken.AuthTokenService;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RequestedPrivileges
implements Writeable,
ToXContentObject,
Serializable {
    static final String RESTRICTION_ROLE = "_requested_privileges";
    static final ImmutableSet<String> RESTRICTION_ROLES = ImmutableSet.of((Object)"_requested_privileges");
    private static final long serialVersionUID = 5862219250642101795L;
    private static final ImmutableList<String> WILDCARD_LIST = ImmutableList.of((Object)"*");
    private static final ImmutableList<Template<Pattern>> WILDCARD_TEMPLATE_PATTERN_LIST = ImmutableList.of((Object)Template.constant((Object)Pattern.wildcard(), (String)"*"));
    public static final RequestedPrivileges ALL = new RequestedPrivileges((List<String>)WILDCARD_LIST, (List<IndexPermissions>)IndexPermissions.ALL, (List<TenantPermissions>)TenantPermissions.ALL, (List<AliasPermissions>)AliasPermissions.ALL, (List<DataStreamPermissions>)DataStreamPermissions.ALL);
    private static final Logger log = LogManager.getLogger(AuthTokenService.class);
    private ImmutableList<String> clusterPermissions;
    private ImmutableList<IndexPermissions> indexPermissions;
    private ImmutableList<TenantPermissions> tenantPermissions;
    private ImmutableList<AliasPermissions> aliasPermissions;
    private ImmutableList<DataStreamPermissions> dataStreamPermissions;
    private ImmutableList<String> roles;
    private ImmutableList<String> excludedClusterPermissions;
    @Deprecated
    private ImmutableList<ExcludedIndexPermissions> excludedIndexPermissions;

    public RequestedPrivileges(StreamInput in) throws IOException {
        this.clusterPermissions = ImmutableList.of((Collection)in.readStringCollectionAsList());
        this.indexPermissions = ImmutableList.of((Collection)in.readCollectionAsList(IndexPermissions::new));
        this.tenantPermissions = ImmutableList.of((Collection)in.readCollectionAsList(TenantPermissions::new));
        this.excludedClusterPermissions = ImmutableList.of((Collection)in.readStringCollectionAsList());
        this.excludedIndexPermissions = ImmutableList.of((Collection)in.readCollectionAsList(ExcludedIndexPermissions::new));
        List roles = in.readOptionalStringCollectionAsList();
        this.roles = roles != null ? ImmutableList.of((Collection)roles) : null;
        this.aliasPermissions = ImmutableList.of((Collection)in.readCollectionAsList(AliasPermissions::new));
        this.dataStreamPermissions = ImmutableList.of((Collection)in.readCollectionAsList(DataStreamPermissions::new));
    }

    RequestedPrivileges(List<String> clusterPermissions, List<IndexPermissions> indexPermissions, List<TenantPermissions> tenantPermissions, List<AliasPermissions> aliasPermissions, List<DataStreamPermissions> dataStreamPermissions) {
        this.clusterPermissions = ImmutableList.of(clusterPermissions);
        this.indexPermissions = ImmutableList.of(indexPermissions);
        this.tenantPermissions = ImmutableList.of(tenantPermissions);
        this.aliasPermissions = ImmutableList.of(aliasPermissions);
        this.dataStreamPermissions = ImmutableList.of(dataStreamPermissions);
        this.excludedClusterPermissions = ImmutableList.empty();
        this.excludedIndexPermissions = ImmutableList.empty();
    }

    private RequestedPrivileges() {
    }

    public ImmutableList<String> getClusterPermissions() {
        return this.clusterPermissions;
    }

    public ImmutableList<IndexPermissions> getIndexPermissions() {
        return this.indexPermissions;
    }

    public ImmutableList<TenantPermissions> getTenantPermissions() {
        return this.tenantPermissions;
    }

    public ImmutableList<AliasPermissions> getAliasPermissions() {
        return this.aliasPermissions;
    }

    public ImmutableList<DataStreamPermissions> getDataStreamPermissions() {
        return this.dataStreamPermissions;
    }

    public ImmutableList<String> getRoles() {
        return this.roles;
    }

    public ImmutableList<String> getExcludedClusterPermissions() {
        return this.excludedClusterPermissions;
    }

    public RequestedPrivileges excludeClusterPermissions(List<String> excludeAddionalClusterPermissions) {
        if (excludeAddionalClusterPermissions == null || excludeAddionalClusterPermissions.size() == 0) {
            return this;
        }
        RequestedPrivileges result = new RequestedPrivileges();
        result.clusterPermissions = this.clusterPermissions;
        result.indexPermissions = this.indexPermissions;
        result.tenantPermissions = this.tenantPermissions;
        result.aliasPermissions = this.aliasPermissions;
        result.dataStreamPermissions = this.dataStreamPermissions;
        result.roles = this.roles;
        result.excludedIndexPermissions = this.excludedIndexPermissions;
        result.excludedClusterPermissions = this.excludedClusterPermissions.with(excludeAddionalClusterPermissions);
        return result;
    }

    public boolean isTotalWildcard() {
        if (!this.clusterPermissions.contains((Object)"*")) {
            return false;
        }
        if (this.excludedClusterPermissions != null && this.excludedClusterPermissions.size() > 0) {
            return false;
        }
        if (this.excludedIndexPermissions != null && this.excludedIndexPermissions.size() > 0) {
            return false;
        }
        if (this.roles != null && this.roles.size() > 0) {
            return false;
        }
        if (this.indexPermissions.size() != 1) {
            return false;
        }
        if (!((IndexPermissions)this.indexPermissions.get(0)).isWildcard()) {
            return false;
        }
        if (this.tenantPermissions.size() != 1) {
            return false;
        }
        if (!((TenantPermissions)this.tenantPermissions.get(0)).isWildcard()) {
            return false;
        }
        if (this.aliasPermissions.size() != 1) {
            return false;
        }
        if (!((AliasPermissions)this.aliasPermissions.get(0)).isWildcard()) {
            return false;
        }
        if (this.dataStreamPermissions.size() != 1) {
            return false;
        }
        return ((DataStreamPermissions)this.dataStreamPermissions.get(0)).isWildcard();
    }

    SgDynamicConfiguration<Role> toRolesConfig() {
        ImmutableList indexPermissions = this.indexPermissions.map(p -> p.toRoleIndex());
        ImmutableList tenantPermissions = this.tenantPermissions.map(p -> p.toRoleTenant());
        ImmutableList aliasPermissions = this.aliasPermissions.map(p -> p.toRoleAlias());
        ImmutableList dataStreamPermissions = this.dataStreamPermissions.map(p -> p.toRoleDataStream());
        Role role = new Role(null, false, false, false, "requested privileges", this.clusterPermissions, indexPermissions, aliasPermissions, dataStreamPermissions, tenantPermissions, this.excludedClusterPermissions);
        return SgDynamicConfiguration.of((CType)CType.ROLES, (String)RESTRICTION_ROLE, (Object)role);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.clusterPermissions);
        out.writeCollection(this.indexPermissions);
        out.writeCollection(this.tenantPermissions);
        out.writeStringCollection(this.excludedClusterPermissions);
        out.writeCollection(this.excludedIndexPermissions);
        out.writeOptionalStringCollection(this.roles);
        out.writeCollection(this.aliasPermissions);
        out.writeCollection(this.dataStreamPermissions);
    }

    public static RequestedPrivileges parse(DocNode jsonNode) throws ConfigValidationException {
        if (jsonNode.toBasicObject() instanceof String && jsonNode.toString().equals("*")) {
            return RequestedPrivileges.totalWildcard();
        }
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        RequestedPrivileges result = new RequestedPrivileges();
        result.clusterPermissions = vJsonNode.hasNonNull("cluster_permissions") ? ImmutableList.of((Collection)vJsonNode.get("cluster_permissions").asListOfStrings()) : null;
        result.indexPermissions = vJsonNode.hasNonNull("index_permissions") ? ImmutableList.of((Collection)vJsonNode.get("index_permissions").asList(IndexPermissions::parse)) : null;
        result.tenantPermissions = vJsonNode.hasNonNull("tenant_permissions") ? ImmutableList.of((Collection)vJsonNode.get("tenant_permissions").asList(TenantPermissions::parse)) : null;
        result.aliasPermissions = vJsonNode.hasNonNull("alias_permissions") ? ImmutableList.of((Collection)vJsonNode.get("alias_permissions").asList(AliasPermissions::parse)) : null;
        result.dataStreamPermissions = vJsonNode.hasNonNull("data_stream_permissions") ? ImmutableList.of((Collection)vJsonNode.get("data_stream_permissions").asList(DataStreamPermissions::parse)) : null;
        result.excludedClusterPermissions = vJsonNode.hasNonNull("exclude_cluster_permissions") ? ImmutableList.of((Collection)vJsonNode.get("exclude_cluster_permissions").asListOfStrings()) : null;
        result.excludedIndexPermissions = null;
        result.roles = vJsonNode.hasNonNull("roles") ? ImmutableList.of((Collection)vJsonNode.get("roles").asListOfStrings()) : null;
        validationErrors.throwExceptionForPresentErrors();
        if (result.clusterPermissions == null && result.indexPermissions == null && result.tenantPermissions == null && result.aliasPermissions == null && result.dataStreamPermissions == null) {
            if (result.roles == null || result.roles.isEmpty()) {
                validationErrors.add(new ValidationError(null, "No permissions or roles have been specified"));
            } else {
                result.clusterPermissions = WILDCARD_LIST;
                result.indexPermissions = IndexPermissions.ALL;
                result.tenantPermissions = TenantPermissions.ALL;
                result.aliasPermissions = AliasPermissions.ALL;
                result.dataStreamPermissions = DataStreamPermissions.ALL;
                return result;
            }
        }
        if (result.clusterPermissions == null) {
            result.clusterPermissions = ImmutableList.empty();
        }
        if (result.indexPermissions == null) {
            result.indexPermissions = ImmutableList.empty();
        }
        if (result.tenantPermissions == null) {
            result.tenantPermissions = ImmutableList.empty();
        }
        if (result.aliasPermissions == null) {
            result.aliasPermissions = ImmutableList.empty();
        }
        if (result.dataStreamPermissions == null) {
            result.dataStreamPermissions = ImmutableList.empty();
        }
        if (result.excludedClusterPermissions == null) {
            result.excludedClusterPermissions = ImmutableList.empty();
        }
        if (result.excludedIndexPermissions == null) {
            result.excludedIndexPermissions = ImmutableList.empty();
        }
        if (!validationErrors.hasErrors() && result.clusterPermissions.isEmpty() && result.indexPermissions.isEmpty() && result.tenantPermissions.isEmpty() && result.aliasPermissions.isEmpty() && result.dataStreamPermissions.isEmpty() && (result.roles == null || result.roles.isEmpty())) {
            validationErrors.add(new ValidationError(null, "No permissions or roles have been specified"));
        }
        validationErrors.throwExceptionForPresentErrors();
        return result;
    }

    public static RequestedPrivileges totalWildcard() {
        RequestedPrivileges result = new RequestedPrivileges();
        result.clusterPermissions = WILDCARD_LIST;
        result.indexPermissions = IndexPermissions.ALL;
        result.tenantPermissions = TenantPermissions.ALL;
        result.aliasPermissions = AliasPermissions.ALL;
        result.dataStreamPermissions = DataStreamPermissions.ALL;
        return result;
    }

    public static RequestedPrivileges parseYaml(String yaml) throws ConfigValidationException {
        return RequestedPrivileges.parse(DocNode.parse((Format)Format.YAML).from(yaml));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.clusterPermissions != null && this.clusterPermissions.size() > 0) {
            builder.field("cluster_permissions", this.clusterPermissions);
        }
        if (this.indexPermissions != null && this.indexPermissions.size() > 0) {
            builder.field("index_permissions", this.indexPermissions);
        }
        if (this.tenantPermissions != null && this.tenantPermissions.size() > 0) {
            builder.field("tenant_permissions", this.tenantPermissions);
        }
        if (this.aliasPermissions != null && this.aliasPermissions.size() > 0) {
            builder.field("alias_permissions", this.aliasPermissions);
        }
        if (this.dataStreamPermissions != null && this.dataStreamPermissions.size() > 0) {
            builder.field("data_stream_permissions", this.dataStreamPermissions);
        }
        if (this.excludedClusterPermissions != null && this.excludedClusterPermissions.size() > 0) {
            builder.field("exclude_cluster_permissions", this.excludedClusterPermissions);
        }
        if (this.excludedIndexPermissions != null && this.excludedIndexPermissions.size() > 0) {
            builder.field("exclude_index_permissions", this.excludedIndexPermissions);
        }
        if (this.roles != null && this.roles.size() > 0) {
            builder.field("roles", this.roles);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clusterPermissions == null ? 0 : this.clusterPermissions.hashCode());
        result = 31 * result + (this.excludedClusterPermissions == null ? 0 : this.excludedClusterPermissions.hashCode());
        result = 31 * result + (this.excludedIndexPermissions == null ? 0 : this.excludedIndexPermissions.hashCode());
        result = 31 * result + (this.indexPermissions == null ? 0 : this.indexPermissions.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.tenantPermissions == null ? 0 : this.tenantPermissions.hashCode());
        result = 31 * result + (this.aliasPermissions == null ? 0 : this.aliasPermissions.hashCode());
        result = 31 * result + (this.dataStreamPermissions == null ? 0 : this.dataStreamPermissions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestedPrivileges other = (RequestedPrivileges)obj;
        if (this.clusterPermissions == null ? other.clusterPermissions != null : !this.clusterPermissions.equals(other.clusterPermissions)) {
            return false;
        }
        if (this.excludedClusterPermissions == null ? other.excludedClusterPermissions != null : !this.excludedClusterPermissions.equals(other.excludedClusterPermissions)) {
            return false;
        }
        if (this.excludedIndexPermissions == null ? other.excludedIndexPermissions != null : !this.excludedIndexPermissions.equals(other.excludedIndexPermissions)) {
            return false;
        }
        if (this.indexPermissions == null ? other.indexPermissions != null : !this.indexPermissions.equals(other.indexPermissions)) {
            return false;
        }
        if (this.roles == null ? other.roles != null : !this.roles.equals(other.roles)) {
            return false;
        }
        if (this.tenantPermissions == null ? other.tenantPermissions != null : !this.tenantPermissions.equals(other.tenantPermissions)) {
            return false;
        }
        if (this.aliasPermissions == null ? other.aliasPermissions != null : !this.aliasPermissions.equals(other.aliasPermissions)) {
            return false;
        }
        return !(this.dataStreamPermissions == null ? other.dataStreamPermissions != null : !this.dataStreamPermissions.equals(other.dataStreamPermissions));
    }

    public String toString() {
        return "RequestedPrivileges [clusterPermissions=" + String.valueOf(this.clusterPermissions) + ", indexPermissions=" + String.valueOf(this.indexPermissions) + ", tenantPermissions=" + String.valueOf(this.tenantPermissions) + ", aliasPermissions=" + String.valueOf(this.aliasPermissions) + ", dataStreamPermissions=" + String.valueOf(this.dataStreamPermissions) + ", roles=" + String.valueOf(this.roles) + ", excludedClusterPermissions=" + String.valueOf(this.excludedClusterPermissions) + ", excludedIndexPermissions=" + String.valueOf(this.excludedIndexPermissions) + "]";
    }

    public static class IndexPermissions
    implements Writeable,
    ToXContentObject,
    Serializable {
        public static final ImmutableList<IndexPermissions> ALL = ImmutableList.of((Object)new IndexPermissions(WILDCARD_TEMPLATE_PATTERN_LIST, WILDCARD_LIST));
        private static final long serialVersionUID = -2567351561923741922L;
        private ImmutableList<Template<Pattern>> indexPatterns;
        private ImmutableList<String> allowedActions;

        IndexPermissions(ImmutableList<Template<Pattern>> indexPatterns, ImmutableList<String> allowedActions) {
            this.indexPatterns = indexPatterns;
            this.allowedActions = allowedActions;
        }

        IndexPermissions(StreamInput in) throws IOException {
            this.indexPatterns = ImmutableList.map((Collection)in.readStringCollectionAsList(), s -> {
                try {
                    return new Template(s, Pattern::create);
                }
                catch (ConfigValidationException e) {
                    log.error("Error compiling " + s, (Throwable)e);
                    return null;
                }
            });
            this.allowedActions = ImmutableList.of((Collection)in.readStringCollectionAsList());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection((Collection)this.indexPatterns.map(t -> t.getSource()));
            out.writeStringCollection(this.allowedActions);
        }

        public static IndexPermissions parse(DocNode jsonNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
            ImmutableList indexPatterns = vJsonNode.get("index_patterns").required().asList().minElements(1).ofTemplates(Pattern::create);
            ImmutableList allowedActions = vJsonNode.get("allowed_actions").required().asList().minElements(1).ofStrings();
            validationErrors.throwExceptionForPresentErrors();
            return new IndexPermissions((ImmutableList<Template<Pattern>>)ImmutableList.of((Collection)indexPatterns), (ImmutableList<String>)ImmutableList.of((Collection)allowedActions));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("index_patterns", (Collection)this.indexPatterns.map(t -> t.getSource()));
            builder.field("allowed_actions", this.allowedActions);
            builder.endObject();
            return builder;
        }

        public String toString() {
            return "IndexPermissions [indexPatterns=" + String.valueOf(this.indexPatterns) + ", allowedActions=" + String.valueOf(this.allowedActions) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.allowedActions == null ? 0 : this.allowedActions.hashCode());
            result = 31 * result + (this.indexPatterns == null ? 0 : this.indexPatterns.hashCode());
            return result;
        }

        public Role.Index toRoleIndex() {
            return new Role.Index(this.indexPatterns, null, null, null, this.allowedActions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexPermissions other = (IndexPermissions)obj;
            if (this.allowedActions == null ? other.allowedActions != null : !this.allowedActions.equals(other.allowedActions)) {
                return false;
            }
            return !(this.indexPatterns == null ? other.indexPatterns != null : !this.indexPatterns.equals(other.indexPatterns));
        }

        public boolean isWildcard() {
            return this.allowedActions.contains((Object)"*") && this.indexPatterns.forAnyApplies(t -> t.isConstant() && ((Pattern)t.getConstantValue()).isWildcard());
        }
    }

    public static class TenantPermissions
    implements Writeable,
    ToXContentObject,
    Serializable {
        public static final ImmutableList<TenantPermissions> ALL = ImmutableList.of((Object)new TenantPermissions(WILDCARD_TEMPLATE_PATTERN_LIST, WILDCARD_LIST));
        private static final long serialVersionUID = 170036537583928629L;
        private ImmutableList<Template<Pattern>> tenantPatterns;
        private ImmutableList<String> allowedActions;

        TenantPermissions(ImmutableList<Template<Pattern>> tenantPatterns, ImmutableList<String> allowedActions) {
            this.tenantPatterns = tenantPatterns;
            this.allowedActions = allowedActions;
        }

        TenantPermissions(StreamInput in) throws IOException {
            this.tenantPatterns = ImmutableList.map((Collection)in.readStringCollectionAsList(), s -> {
                try {
                    return new Template(s, Pattern::create);
                }
                catch (ConfigValidationException e) {
                    log.error("Error compiling " + s, (Throwable)e);
                    return null;
                }
            });
            this.allowedActions = ImmutableList.of((Collection)in.readStringCollectionAsList());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection((Collection)this.tenantPatterns.map(t -> t.getSource()));
            out.writeStringCollection(this.allowedActions);
        }

        public static TenantPermissions parse(DocNode jsonNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
            ImmutableList tenantPatterns = vJsonNode.get("tenant_patterns").required().asList().minElements(1).ofTemplates(Pattern::create);
            ImmutableList allowedActions = vJsonNode.get("allowed_actions").required().asList().minElements(1).ofStrings();
            validationErrors.throwExceptionForPresentErrors();
            return new TenantPermissions((ImmutableList<Template<Pattern>>)ImmutableList.of((Collection)tenantPatterns), (ImmutableList<String>)ImmutableList.of((Collection)allowedActions));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("tenant_patterns", (Collection)this.tenantPatterns.map(t -> t.getSource()));
            builder.field("allowed_actions", this.allowedActions);
            builder.endObject();
            return builder;
        }

        public String toString() {
            return "TenantPermissions [tenantPatterns=" + String.valueOf(this.tenantPatterns) + ", allowedActions=" + String.valueOf(this.allowedActions) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.allowedActions == null ? 0 : this.allowedActions.hashCode());
            result = 31 * result + (this.tenantPatterns == null ? 0 : this.tenantPatterns.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TenantPermissions other = (TenantPermissions)obj;
            if (this.allowedActions == null ? other.allowedActions != null : !this.allowedActions.equals(other.allowedActions)) {
                return false;
            }
            return !(this.tenantPatterns == null ? other.tenantPatterns != null : !this.tenantPatterns.equals(other.tenantPatterns));
        }

        public boolean isWildcard() {
            return this.allowedActions.contains((Object)"*") && this.tenantPatterns.forAnyApplies(t -> t.isConstant() && ((Pattern)t.getConstantValue()).isWildcard());
        }

        Role.Tenant toRoleTenant() {
            return new Role.Tenant(this.tenantPatterns, this.allowedActions);
        }
    }

    public static class AliasPermissions
    implements Writeable,
    ToXContentObject,
    Serializable {
        public static final ImmutableList<AliasPermissions> ALL = ImmutableList.of((Object)new AliasPermissions(WILDCARD_TEMPLATE_PATTERN_LIST, WILDCARD_LIST));
        private static final long serialVersionUID = 9149970087895696366L;
        private ImmutableList<Template<Pattern>> aliasPatterns;
        private ImmutableList<String> allowedActions;

        AliasPermissions(ImmutableList<Template<Pattern>> aliasPatterns, ImmutableList<String> allowedActions) {
            this.aliasPatterns = aliasPatterns;
            this.allowedActions = allowedActions;
        }

        AliasPermissions(StreamInput in) throws IOException {
            this.aliasPatterns = ImmutableList.map((Collection)in.readStringCollectionAsList(), s -> {
                try {
                    return new Template(s, Pattern::create);
                }
                catch (ConfigValidationException e) {
                    log.error("Error compiling {}", s, (Object)e);
                    return null;
                }
            });
            this.allowedActions = ImmutableList.of((Collection)in.readStringCollectionAsList());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection((Collection)this.aliasPatterns.map(t -> t.getSource()));
            out.writeStringCollection(this.allowedActions);
        }

        public static AliasPermissions parse(DocNode jsonNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
            ImmutableList aliasPatterns = vJsonNode.get("alias_patterns").required().asList().minElements(1).ofTemplates(Pattern::create);
            ImmutableList allowedActions = vJsonNode.get("allowed_actions").required().asList().minElements(1).ofStrings();
            validationErrors.throwExceptionForPresentErrors();
            return new AliasPermissions((ImmutableList<Template<Pattern>>)ImmutableList.of((Collection)aliasPatterns), (ImmutableList<String>)ImmutableList.of((Collection)allowedActions));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("alias_patterns", (Collection)this.aliasPatterns.map(t -> t.getSource()));
            builder.field("allowed_actions", this.allowedActions);
            builder.endObject();
            return builder;
        }

        public String toString() {
            return "AliasPermissions [aliasPatterns=" + String.valueOf(this.aliasPatterns) + ", allowedActions=" + String.valueOf(this.allowedActions) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.allowedActions == null ? 0 : this.allowedActions.hashCode());
            result = 31 * result + (this.aliasPatterns == null ? 0 : this.aliasPatterns.hashCode());
            return result;
        }

        public Role.Alias toRoleAlias() {
            return new Role.Alias(this.aliasPatterns, null, null, null, this.allowedActions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AliasPermissions other = (AliasPermissions)obj;
            if (this.allowedActions == null ? other.allowedActions != null : !this.allowedActions.equals(other.allowedActions)) {
                return false;
            }
            return !(this.aliasPatterns == null ? other.aliasPatterns != null : !this.aliasPatterns.equals(other.aliasPatterns));
        }

        public boolean isWildcard() {
            return this.allowedActions.contains((Object)"*") && this.aliasPatterns.forAnyApplies(t -> t.isConstant() && ((Pattern)t.getConstantValue()).isWildcard());
        }
    }

    public static class DataStreamPermissions
    implements Writeable,
    ToXContentObject,
    Serializable {
        public static final ImmutableList<DataStreamPermissions> ALL = ImmutableList.of((Object)new DataStreamPermissions(WILDCARD_TEMPLATE_PATTERN_LIST, WILDCARD_LIST));
        private static final long serialVersionUID = 6013062077364983299L;
        private ImmutableList<Template<Pattern>> dataStreamPatterns;
        private ImmutableList<String> allowedActions;

        DataStreamPermissions(ImmutableList<Template<Pattern>> dataStreamPatterns, ImmutableList<String> allowedActions) {
            this.dataStreamPatterns = dataStreamPatterns;
            this.allowedActions = allowedActions;
        }

        DataStreamPermissions(StreamInput in) throws IOException {
            this.dataStreamPatterns = ImmutableList.map((Collection)in.readStringCollectionAsList(), s -> {
                try {
                    return new Template(s, Pattern::create);
                }
                catch (ConfigValidationException e) {
                    log.error("Error compiling " + s, (Throwable)e);
                    return null;
                }
            });
            this.allowedActions = ImmutableList.of((Collection)in.readStringCollectionAsList());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection((Collection)this.dataStreamPatterns.map(t -> t.getSource()));
            out.writeStringCollection(this.allowedActions);
        }

        public static DataStreamPermissions parse(DocNode jsonNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
            ImmutableList dataStreamPatterns = vJsonNode.get("data_stream_patterns").required().asList().minElements(1).ofTemplates(Pattern::create);
            ImmutableList allowedActions = vJsonNode.get("allowed_actions").required().asList().minElements(1).ofStrings();
            validationErrors.throwExceptionForPresentErrors();
            return new DataStreamPermissions((ImmutableList<Template<Pattern>>)ImmutableList.of((Collection)dataStreamPatterns), (ImmutableList<String>)ImmutableList.of((Collection)allowedActions));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("data_stream_patterns", (Collection)this.dataStreamPatterns.map(t -> t.getSource()));
            builder.field("allowed_actions", this.allowedActions);
            builder.endObject();
            return builder;
        }

        public String toString() {
            return "DataStreamPermissions [dataStreamPatterns=" + String.valueOf(this.dataStreamPatterns) + ", allowedActions=" + String.valueOf(this.allowedActions) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.allowedActions == null ? 0 : this.allowedActions.hashCode());
            result = 31 * result + (this.dataStreamPatterns == null ? 0 : this.dataStreamPatterns.hashCode());
            return result;
        }

        public Role.DataStream toRoleDataStream() {
            return new Role.DataStream(this.dataStreamPatterns, null, null, null, this.allowedActions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataStreamPermissions other = (DataStreamPermissions)obj;
            if (this.allowedActions == null ? other.allowedActions != null : !this.allowedActions.equals(other.allowedActions)) {
                return false;
            }
            return !(this.dataStreamPatterns == null ? other.dataStreamPatterns != null : !this.dataStreamPatterns.equals(other.dataStreamPatterns));
        }

        public boolean isWildcard() {
            return this.allowedActions.contains((Object)"*") && this.dataStreamPatterns.forAnyApplies(t -> t.isConstant() && ((Pattern)t.getConstantValue()).isWildcard());
        }
    }

    public static class ExcludedIndexPermissions
    implements Writeable,
    ToXContentObject,
    Serializable {
        private static final long serialVersionUID = -2567351561923741922L;
        private ImmutableList<Template<Pattern>> indexPatterns;
        private ImmutableList<String> actions;

        ExcludedIndexPermissions(StreamInput in) throws IOException {
            this.indexPatterns = ImmutableList.map((Collection)in.readStringCollectionAsList(), s -> {
                try {
                    return new Template(s, Pattern::create);
                }
                catch (ConfigValidationException e) {
                    log.error("Error compiling " + s, (Throwable)e);
                    return null;
                }
            });
            this.actions = ImmutableList.of((Collection)in.readStringCollectionAsList());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection((Collection)this.indexPatterns.map(t -> t.getSource()));
            out.writeStringCollection(this.actions);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("index_patterns", this.indexPatterns);
            builder.field("actions", this.actions);
            builder.endObject();
            return builder;
        }

        public String toString() {
            return "ExcludedIndexPermissions [indexPatterns=" + String.valueOf(this.indexPatterns) + ", actions=" + String.valueOf(this.actions) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
            result = 31 * result + (this.indexPatterns == null ? 0 : this.indexPatterns.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexPermissions other = (IndexPermissions)obj;
            if (this.actions == null ? other.allowedActions != null : !this.actions.equals(other.allowedActions)) {
                return false;
            }
            return !(this.indexPatterns == null ? other.indexPatterns != null : !this.indexPatterns.equals(other.indexPatterns));
        }
    }
}

