/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.VariableResolvers;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.session.ActivatedFrontendConfig;
import com.floragunn.searchguard.authc.session.GetActivatedFrontendConfigAction;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auth.oidc.MockIpdServer;
import com.floragunn.searchguard.enterprise.auth.oidc.OidcAuthenticator;
import com.floragunn.searchguard.enterprise.auth.oidc.TestJwk;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OidcAuthenticatorRedirectUrlTest {
    private static final Logger log = LogManager.getLogger(OidcAuthenticatorRedirectUrlTest.class);
    private static final ActivatedFrontendConfig.AuthMethod OIDC_AUTH_METHOD = new ActivatedFrontendConfig.AuthMethod("oidc", "OIDC", null);
    private OidcAuthenticator authenticator;
    private static MockIpdServer mockIdpServer;
    private final String frontendBaseUrl;
    private final String expectedOidcRedirectUrl;

    @Parameterized.Parameters
    public static Collection<Object[]> testParameters() {
        return Arrays.asList({"https://search.frontend.com", "https://search.frontend.com/auth/openid/login"}, {"https://search.frontend.com/", "https://search.frontend.com/auth/openid/login"}, {"https://search.com/frontend", "https://search.com/frontend/auth/openid/login"}, {"https://search.com/frontend/", "https://search.com/frontend/auth/openid/login"}, {"https://search.com/evem/more/hidden/frontend/", "https://search.com/evem/more/hidden/frontend/auth/openid/login"}, {"https://search.com/evem/more/hidden/frontend", "https://search.com/evem/more/hidden/frontend/auth/openid/login"});
    }

    public OidcAuthenticatorRedirectUrlTest(String frontendBaseUrl, String expectedOidcRedirectUrl) {
        this.frontendBaseUrl = frontendBaseUrl;
        this.expectedOidcRedirectUrl = expectedOidcRedirectUrl;
    }

    @BeforeClass
    public static void startIdpServer() throws IOException {
        mockIdpServer = MockIpdServer.forKeySet(TestJwk.Jwks.ALL).start();
    }

    @AfterClass
    public static void tearDown() {
        if (mockIdpServer != null) {
            try {
                mockIdpServer.close();
            }
            catch (Exception e) {
                log.error("Cannot stop IdP server", (Throwable)e);
            }
        }
    }

    @Before
    public void before() throws ConfigValidationException {
        ConfigurationRepository.Context testContext = new ConfigurationRepository.Context(VariableResolvers.ALL, null, null, null, null);
        ImmutableMap basicAuthenticatorSettings = ImmutableMap.of((Object)"idp.openid_configuration_url", (Object)mockIdpServer.getDiscoverUri().toString(), (Object)"client_id", (Object)"search-guard-client", (Object)"client_secret", (Object)"s3cret", (Object)"pkce", (Object)false);
        this.authenticator = new OidcAuthenticator((Map)basicAuthenticatorSettings, testContext);
    }

    @Test
    public void shouldCreateValidOidcRedirectUrl() throws AuthenticatorUnavailableException, MalformedURLException {
        ActivatedFrontendConfig.AuthMethod authMethod = this.authenticator.activateFrontendConfig(OIDC_AUTH_METHOD, new GetActivatedFrontendConfigAction.Request(null, null, this.frontendBaseUrl));
        String redirectUrl = URLEncodedUtils.parse((String)authMethod.getSsoLocation(), (Charset)Charset.forName("UTF-8")).stream().filter(nameValuePair -> "redirect_uri".equals(nameValuePair.getName())).map(pair -> pair.getValue()).findFirst().orElseThrow(() -> new IllegalStateException("Redirect url not found"));
        MatcherAssert.assertThat((Object)redirectUrl, (Matcher)Matchers.equalTo((Object)this.expectedOidcRedirectUrl));
    }
}

