/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import com.floragunn.searchguard.authc.AuthenticationDebugLogger;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authtoken.AuthTokenHttpJwtAuthenticator;
import com.floragunn.searchguard.authtoken.AuthTokenService;
import com.floragunn.searchguard.authtoken.InvalidTokenException;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.ElasticsearchSecurityException;

public class AuthTokenAuthenticationDomain
implements AuthenticationDomain<HttpAuthenticationFrontend> {
    private final AuthTokenService authTokenService;
    private final AuthTokenHttpJwtAuthenticator httpAuthenticator;
    private final ComponentState componentState;

    public AuthTokenAuthenticationDomain(AuthTokenService authTokenService) {
        this.authTokenService = authTokenService;
        this.httpAuthenticator = new AuthTokenHttpJwtAuthenticator(authTokenService);
        this.componentState = new ComponentState(0, "auth_domain", "sg_auth_token", AuthTokenAuthenticationDomain.class);
        this.componentState.addPart(this.httpAuthenticator.getComponentState());
        this.componentState.updateStateFromParts();
    }

    public String getType() {
        return "sg_auth_token";
    }

    public CompletableFuture<User> authenticate(AuthCredentials credentials, AuthenticationDebugLogger debug) {
        try {
            CompletableFuture<User> result = new CompletableFuture<User>();
            this.authTokenService.getByClaims(credentials.getClaims(), authToken -> {
                if (authToken.isRevoked()) {
                    result.completeExceptionally((Throwable)new ElasticsearchSecurityException("Auth token " + authToken.getId() + " has been revoked", new Object[0]));
                } else if (authToken.getBase().getConfigVersions() == null && authToken.getRequestedPrivileges().isTotalWildcard()) {
                    result.complete(User.forUser((String)authToken.getUserName()).type("sg_auth_token_full_current_permissions").authDomainInfo(credentials.getAuthDomainInfo().authBackendType(this.getType())).backendRoles(authToken.getBase().getBackendRoles()).searchGuardRoles(authToken.getBase().getSearchGuardRoles()).specialAuthzConfig((Object)authToken.getId()).attributes(authToken.getBase().getAttributes()).authzComplete().build());
                } else {
                    result.complete(User.forUser((String)authToken.getUserName()).authDomainInfo(credentials.getAuthDomainInfo().authBackendType(this.getType())).subName("AuthToken " + authToken.getTokenName() + " [" + authToken.getId() + "]").type("sg_auth_token").specialAuthzConfig((Object)authToken.getId()).attributes(authToken.getBase().getAttributes()).authzComplete().build());
                }
            }, noSuchAuthTokenException -> result.completeExceptionally((Throwable)new ElasticsearchSecurityException(noSuchAuthTokenException.getMessage(), (Exception)noSuchAuthTokenException, new Object[0])), e -> result.completeExceptionally((Throwable)e));
            return result;
        }
        catch (InvalidTokenException e2) {
            return CompletableFuture.completedFuture(null);
        }
    }

    public AuthTokenHttpJwtAuthenticator getFrontend() {
        return this.httpAuthenticator;
    }

    public String getId() {
        return this.getType();
    }

    public boolean accept(RequestMetaData<?> request) {
        return true;
    }

    public boolean accept(AuthCredentials authCredentials) {
        return true;
    }

    public boolean isEnabled() {
        return this.authTokenService.isEnabled();
    }

    public CompletableFuture<User> impersonate(User originalUser, AuthCredentials authCredentials) throws AuthenticatorUnavailableException, CredentialsException {
        return null;
    }

    public boolean cacheUser() {
        return false;
    }

    public String toString() {
        return this.getType();
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

