/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.authtoken.AuthTokenPrivilegeBase;
import com.floragunn.searchguard.authtoken.RequestedPrivileges;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class AuthToken
implements ToXContentObject,
Writeable,
Serializable {
    public static final String EXPIRES_AT = "expires_at";
    public static final String DYNAMIC_EXPIRES_AT = "dynamic_expires_at";
    public static final Map<String, Object> INDEX_MAPPING = ImmutableMap.of((Object)"dynamic", (Object)true, (Object)"properties", (Object)ImmutableMap.of((Object)"created_at", (Object)ImmutableMap.of((Object)"type", (Object)"date"), (Object)"expires_at", (Object)ImmutableMap.of((Object)"type", (Object)"date"), (Object)"dynamic_expires_at", (Object)ImmutableMap.of((Object)"type", (Object)"date")));
    private static final long serialVersionUID = 6038589333544878668L;
    private final String userName;
    private final String tokenName;
    private final String id;
    private final Instant creationTime;
    private final Instant expiryTime;
    private final Instant revokedAt;
    private final RequestedPrivileges requestedPrivileges;
    private final AuthTokenPrivilegeBase base;

    AuthToken(String id, String userName, String tokenName, RequestedPrivileges requestedPrivileges, AuthTokenPrivilegeBase base, Instant creationTime, Instant expiryTime, Instant revokedAt) {
        this.id = id;
        this.userName = userName;
        this.tokenName = tokenName;
        this.requestedPrivileges = requestedPrivileges;
        this.base = base;
        this.creationTime = creationTime;
        this.expiryTime = expiryTime;
        this.revokedAt = revokedAt;
    }

    public AuthToken(StreamInput in) throws IOException {
        this.id = in.readString();
        this.userName = in.readString();
        this.tokenName = in.readOptionalString();
        this.creationTime = in.readInstant();
        this.expiryTime = in.readOptionalInstant();
        this.revokedAt = in.readOptionalInstant();
        this.requestedPrivileges = new RequestedPrivileges(in);
        this.base = new AuthTokenPrivilegeBase(in);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("user_name", this.userName);
        builder.field("token_name", this.tokenName);
        builder.field("requested", (ToXContent)this.requestedPrivileges);
        builder.field("base");
        this.base.toXContent(builder, params);
        builder.field("created_at", this.creationTime.toEpochMilli());
        if (this.expiryTime != null) {
            builder.field(EXPIRES_AT, this.expiryTime.toEpochMilli());
        }
        if (this.revokedAt != null) {
            builder.field("revoked_at", this.revokedAt.toEpochMilli());
        }
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public RequestedPrivileges getRequestedPrivileges() {
        return this.requestedPrivileges;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public AuthTokenPrivilegeBase getBase() {
        return this.base;
    }

    public boolean isRevoked() {
        return this.revokedAt != null;
    }

    AuthToken getRevokedInstance() {
        AuthToken revoked = new AuthToken(this.id, this.userName, this.tokenName, this.requestedPrivileges, this.base, this.creationTime, this.expiryTime, Instant.now());
        revoked.getBase().setConfigSnapshot(null);
        return revoked;
    }

    public static AuthToken parse(String id, DocNode jsonNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        String userName = vJsonNode.get("user_name").required().asString();
        String tokenName = vJsonNode.get("token_name").asString();
        AuthTokenPrivilegeBase base = null;
        RequestedPrivileges requestedPrivilges = null;
        if (vJsonNode.hasNonNull("base")) {
            try {
                base = AuthTokenPrivilegeBase.parse(jsonNode.getAsNode("base"));
            }
            catch (ConfigValidationException e) {
                validationErrors.add("base", e);
            }
        } else {
            validationErrors.add((ValidationError)new MissingAttribute("base", (Object)jsonNode));
        }
        if (vJsonNode.hasNonNull("requested")) {
            try {
                requestedPrivilges = RequestedPrivileges.parse(jsonNode.getAsNode("requested"));
            }
            catch (ConfigValidationException e) {
                validationErrors.add("requested", e);
            }
        } else {
            validationErrors.add((ValidationError)new MissingAttribute("requested", (Object)jsonNode));
        }
        Instant createdAt = vJsonNode.get("created_at").asInstantFromEpochMilli();
        Instant expiry = vJsonNode.get(EXPIRES_AT).asInstantFromEpochMilli();
        Instant revokedAt = vJsonNode.get("revoked_at").asInstantFromEpochMilli();
        validationErrors.throwExceptionForPresentErrors();
        return new AuthToken(id, userName, tokenName, requestedPrivilges, base, createdAt, expiry, revokedAt);
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getExpiryTime() {
        return this.expiryTime;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.userName);
        out.writeOptionalString(this.tokenName);
        out.writeInstant(this.creationTime);
        out.writeOptionalInstant(this.expiryTime);
        out.writeOptionalInstant(this.revokedAt);
        this.requestedPrivileges.writeTo(out);
        this.base.writeTo(out);
    }

    public Instant getRevokedAt() {
        return this.revokedAt;
    }

    public String toString() {
        return "AuthToken [userName=" + this.userName + ", tokenName=" + this.tokenName + ", id=" + this.id + ", creationTime=" + String.valueOf(this.creationTime) + ", expiryTime=" + String.valueOf(this.expiryTime) + ", revokedAt=" + String.valueOf(this.revokedAt) + ", requestedPrivilges=" + String.valueOf(this.requestedPrivileges) + ", base=" + String.valueOf(this.base) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + (this.creationTime == null ? 0 : this.creationTime.hashCode());
        result = 31 * result + (this.expiryTime == null ? 0 : this.expiryTime.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.requestedPrivileges == null ? 0 : this.requestedPrivileges.hashCode());
        result = 31 * result + (this.tokenName == null ? 0 : this.tokenName.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthToken other = (AuthToken)obj;
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        if (this.creationTime == null ? other.creationTime != null : !this.creationTime.equals(other.creationTime)) {
            return false;
        }
        if (this.expiryTime == null ? other.expiryTime != null : !this.expiryTime.equals(other.expiryTime)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.requestedPrivileges == null ? other.requestedPrivileges != null : !this.requestedPrivileges.equals(other.requestedPrivileges)) {
            return false;
        }
        if (this.tokenName == null ? other.tokenName != null : !this.tokenName.equals(other.tokenName)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }
}

