/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.jwt;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.enterprise.auth.oidc.TestJwts;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.BearerAuthorization;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;

public class HTTPJwtAuthenticatorIntegrationTest {
    private static final Logger log = LogManager.getLogger(HTTPJwtAuthenticatorIntegrationTest.class);
    public static final TestSgConfig.JwtDomain JWK_DOMAIN = new TestSgConfig.JwtDomain().signing(new TestSgConfig.Signing().jwks(new TestSgConfig.Jwks().addKey(new TestSgConfig.JsonWebKey().kty("oct").kid("kid/a").use("sig").alg("HS256").k("eTDZjSqRD9Abhod9iqeGX_7o93a-eElTeXWAF6FmzQshmRIrPD-C9ET3pFjJ_IBrzmWIZDk8ig-X_PIyGmKsxNMsrU-0BNWF5gJq5xOp4rYTl8z66Tw9wr8tHLxLxgJqkLSuUCRBZvlZlQ7jNdhBBxgM-hdSSzsN1T33qdIwhrUeJ-KXI5yKUXHjoWFYb9tETbYQ4NvONowkCsXK_flp-E3F_OcKe_z5iVUszAV8QfCod1zhbya540kDejXCL6N_XMmhWJqum7UJ3hgf6DEtroPSnVpHt4iR5w9ArKK-IBgluPght03gNcoNqwz7p77TFbdOmUKF_PWy1bcdbaUoSg")))).urlParameter("custom_jwt_param");
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().sslEnabled().enterpriseModulesEnabled().roles(new TestSgConfig.Role[]{TestSgConfig.Role.ALL_ACCESS}).roleMapping(new TestSgConfig.RoleMapping[]{new TestSgConfig.RoleMapping(TestSgConfig.Role.ALL_ACCESS.getName()).backendRoles(new String[]{"role1"})}).authc(new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("jwt").jwt(JWK_DOMAIN).userMapping(new TestSgConfig.Authc.Domain.UserMapping().rolesFromCommaSeparatedString("jwt.roles").attrsFrom("from_jwt_claim_n", "jwt.m"))})).build();

    @Test
    public void simple() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[]{new BearerAuthorization(TestJwts.MC_LIST_CLAIM_SIGNED_OCT_1)});){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.json((BaseMatcher[])new BaseMatcher[]{RestMatchers.nodeAt((String)"user_name", (Matcher)Matchers.is((Object)"McList"))}));
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.json((BaseMatcher[])new BaseMatcher[]{RestMatchers.nodeAt((String)"backend_roles", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"role1", "kibana_user"}))}));
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.json((BaseMatcher[])new BaseMatcher[]{RestMatchers.nodeAt((String)"attribute_names", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"from_jwt_claim_n", "__auth_type"}))}));
        }
    }

    @Test
    public void urlParam() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo?custom_jwt_param=" + TestJwts.MC_LIST_CLAIM_SIGNED_OCT_1, new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.json((BaseMatcher[])new BaseMatcher[]{RestMatchers.nodeAt((String)"user_name", (Matcher)Matchers.is((Object)"McList"))}));
        }
    }

    @Test
    public void headerAndUrlParamMixed() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[]{new BearerAuthorization(TestJwts.MC_COY_SIGNED_OCT_1)});){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo?custom_jwt_param=" + TestJwts.MC_LIST_CLAIM_SIGNED_OCT_1, new Header[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.isOk());
            MatcherAssert.assertThat((Object)response, (Matcher)RestMatchers.json((BaseMatcher[])new BaseMatcher[]{RestMatchers.nodeAt((String)"user_name", (Matcher)Matchers.is((Object)"Leonard McCoy"))}));
        }
    }

    @Test
    public void shouldCreateSessionWithJwtToken() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("kibanaserver", "kibanaserver", new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/auth/config?next_url=/abc/def", new Header[0]);
            log.info("Auth config response: '{}'", (Object)response.getBody());
            String body = DocNode.of((String)"method", (Object)"jwt", (String)"jwt", (Object)TestJwts.MC_COY_SIGNED_OCT_1).toJsonString();
            response = client.postJson("/_searchguard/auth/session", body, new Header[0]);
            log.info("POST /_searchguard/auth/session response '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
            String token = response.getBodyAsDocNode().getAsString("token");
            try (GenericRestClient tokenClient = cluster.getRestClient(new Header[]{new BearerAuthorization(token)});){
                response = tokenClient.get("/_searchguard/authinfo", new Header[0]);
                log.info("Session token '{}' used to retrieve auth info '{}'.", (Object)token, (Object)response.getBody());
                MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            }
        }
    }

    @Test
    public void shouldNotCreateSessionWhenTokenSignatureIsIncorrect() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("kibanaserver", "kibanaserver", new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/auth/config?next_url=/abc/def", new Header[0]);
            log.info("Auth config response: '{}'", (Object)response.getBody());
            String body = DocNode.of((String)"method", (Object)"jwt", (String)"jwt", (Object)TestJwts.MC_COY_SIGNED_RSA_1).toJsonString();
            response = client.postJson("/_searchguard/auth/session", body, new Header[0]);
            log.info("POST /_searchguard/auth/session response '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)401));
        }
    }

    @Test
    public void shouldNotCreateSessionWhenTokenIsMissing() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("kibanaserver", "kibanaserver", new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/auth/config?next_url=/abc/def", new Header[0]);
            log.info("Auth config response: '{}'", (Object)response.getBody());
            String body = DocNode.of((String)"method", (Object)"jwt").toJsonString();
            response = client.postJson("/_searchguard/auth/session", body, new Header[0]);
            log.info("POST /_searchguard/auth/session response '{}'.", (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)401));
        }
    }
}

