/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.enterprise.auth.oidc.BadCredentialsException;
import com.floragunn.searchguard.enterprise.auth.oidc.KeySetProvider;
import com.floragunn.searchguard.enterprise.auth.oidc.SelfRefreshingKeySet;
import com.floragunn.searchguard.enterprise.auth.oidc.TestJwk;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.junit.Assert;
import org.junit.Test;

public class SelfRefreshingKeySetTest {
    @Test
    public void basicTest() throws AuthenticatorUnavailableException, BadCredentialsException {
        SelfRefreshingKeySet selfRefreshingKeySet = new SelfRefreshingKeySet((KeySetProvider)new MockKeySetProvider());
        JsonWebKey key1 = selfRefreshingKeySet.getKey("kid/a");
        Assert.assertEquals((Object)"eTDZjSqRD9Abhod9iqeGX_7o93a-eElTeXWAF6FmzQshmRIrPD-C9ET3pFjJ_IBrzmWIZDk8ig-X_PIyGmKsxNMsrU-0BNWF5gJq5xOp4rYTl8z66Tw9wr8tHLxLxgJqkLSuUCRBZvlZlQ7jNdhBBxgM-hdSSzsN1T33qdIwhrUeJ-KXI5yKUXHjoWFYb9tETbYQ4NvONowkCsXK_flp-E3F_OcKe_z5iVUszAV8QfCod1zhbya540kDejXCL6N_XMmhWJqum7UJ3hgf6DEtroPSnVpHt4iR5w9ArKK-IBgluPght03gNcoNqwz7p77TFbdOmUKF_PWy1bcdbaUoSg", (Object)key1.getProperty("k"));
        Assert.assertEquals((long)1L, (long)selfRefreshingKeySet.getRefreshCount());
        JsonWebKey key2 = selfRefreshingKeySet.getKey("kid/b");
        Assert.assertEquals((Object)"YP6Q3IF2qJEagV948dsicXKpG43Ci2W7ZxUpiVTBLZr1vFN9ZGUKxeXGgVWuMFYTmoHvv5AOC8BvoNOpcE3rcJNuNOqTMdujxD92CxjOykiLEKQ0Te_7xQ4LnSQjlqdIJ4U3S7qCnJLd1LxhKOGZcUhE_pjhwf7q2RUUpvC3UOyZZLog9yeflnp9nqqDy5yVqRYWZRcPI06kJTh3Z8IFi2JRJV14iUFQtOHQKuyJRMcsldKnfWl7YW3JdQ9IRN-c1lEYSEBmsavEejcqHZkbli2svqLfmCBJVWffXDRxhq0_VafiL83HC0bP9qeNKivhemw6foVmg8UMs7yJ6ao02A", (Object)key2.getProperty("k"));
        Assert.assertEquals((long)1L, (long)selfRefreshingKeySet.getRefreshCount());
        try {
            selfRefreshingKeySet.getKey("kid/X");
            Assert.fail((String)"Expected a BadCredentialsException");
        }
        catch (BadCredentialsException e) {
            Assert.assertEquals((long)2L, (long)selfRefreshingKeySet.getRefreshCount());
        }
    }

    @Test(timeout=10000L)
    public void twoThreadedTest() throws Exception {
        BlockingMockKeySetProvider provider = new BlockingMockKeySetProvider();
        SelfRefreshingKeySet selfRefreshingKeySet = new SelfRefreshingKeySet((KeySetProvider)provider);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future<JsonWebKey> f1 = executorService.submit(() -> selfRefreshingKeySet.getKey("kid/a"));
        provider.waitForCalled();
        Future<JsonWebKey> f2 = executorService.submit(() -> selfRefreshingKeySet.getKey("kid/b"));
        while (selfRefreshingKeySet.getQueuedGetCount() == 0L) {
            Thread.sleep(10L);
        }
        provider.unblock();
        Assert.assertEquals((Object)"eTDZjSqRD9Abhod9iqeGX_7o93a-eElTeXWAF6FmzQshmRIrPD-C9ET3pFjJ_IBrzmWIZDk8ig-X_PIyGmKsxNMsrU-0BNWF5gJq5xOp4rYTl8z66Tw9wr8tHLxLxgJqkLSuUCRBZvlZlQ7jNdhBBxgM-hdSSzsN1T33qdIwhrUeJ-KXI5yKUXHjoWFYb9tETbYQ4NvONowkCsXK_flp-E3F_OcKe_z5iVUszAV8QfCod1zhbya540kDejXCL6N_XMmhWJqum7UJ3hgf6DEtroPSnVpHt4iR5w9ArKK-IBgluPght03gNcoNqwz7p77TFbdOmUKF_PWy1bcdbaUoSg", (Object)f1.get().getProperty("k"));
        Assert.assertEquals((Object)"YP6Q3IF2qJEagV948dsicXKpG43Ci2W7ZxUpiVTBLZr1vFN9ZGUKxeXGgVWuMFYTmoHvv5AOC8BvoNOpcE3rcJNuNOqTMdujxD92CxjOykiLEKQ0Te_7xQ4LnSQjlqdIJ4U3S7qCnJLd1LxhKOGZcUhE_pjhwf7q2RUUpvC3UOyZZLog9yeflnp9nqqDy5yVqRYWZRcPI06kJTh3Z8IFi2JRJV14iUFQtOHQKuyJRMcsldKnfWl7YW3JdQ9IRN-c1lEYSEBmsavEejcqHZkbli2svqLfmCBJVWffXDRxhq0_VafiL83HC0bP9qeNKivhemw6foVmg8UMs7yJ6ao02A", (Object)f2.get().getProperty("k"));
        Assert.assertEquals((long)1L, (long)selfRefreshingKeySet.getRefreshCount());
        Assert.assertEquals((long)1L, (long)selfRefreshingKeySet.getQueuedGetCount());
    }

    static class MockKeySetProvider
    implements KeySetProvider {
        MockKeySetProvider() {
        }

        public JsonWebKeys get() throws AuthenticatorUnavailableException {
            return TestJwk.OCT_1_2_3;
        }
    }

    static class BlockingMockKeySetProvider
    extends MockKeySetProvider {
        private boolean blocked = true;
        private boolean called = false;

        BlockingMockKeySetProvider() {
        }

        @Override
        public synchronized JsonWebKeys get() throws AuthenticatorUnavailableException {
            this.called = true;
            this.notifyAll();
            this.waitForUnblock();
            return super.get();
        }

        public synchronized void unblock() {
            this.blocked = false;
            this.notifyAll();
        }

        public synchronized void waitForCalled() throws InterruptedException {
            while (!this.called) {
                this.wait();
            }
        }

        private synchronized void waitForUnblock() {
            while (this.blocked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

