/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.searchguard.dlic.rest.api.AbstractRestApiUnitTest;
import com.floragunn.searchguard.legacy.test.RestHelper;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;

public class FlushCacheApiTest
extends AbstractRestApiUnitTest {
    @Test
    public void testFlushCache() throws Exception {
        this.setup();
        this.rh.keystore = "restapi/kirk-keystore.jks";
        this.rh.sendHTTPClientCertificate = true;
        RestHelper.HttpResponse response = this.rh.executeGetRequest("/_searchguard/api/cache", new Header[0]);
        Assert.assertEquals((long)501L, (long)response.getStatusCode());
        Settings settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((Object)settings.get("message"), (Object)"Method GET not supported for this action.");
        response = this.rh.executePutRequest("/_searchguard/api/cache", "{}", new Header[0]);
        Assert.assertEquals((long)501L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((Object)settings.get("message"), (Object)"Method PUT not supported for this action.");
        response = this.rh.executePostRequest("/_searchguard/api/cache", "{}", new Header[0]);
        Assert.assertEquals((long)501L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((Object)settings.get("message"), (Object)"Method POST not supported for this action.");
        response = this.rh.executeDeleteRequest("/_searchguard/api/cache", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((Object)settings.get("message"), (Object)"Cache flushed successfully.");
    }
}

