/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.ldap;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.UnbindRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import java.time.Duration;
import java.util.List;

class DelayedBindRequestHandler
extends LDAPListenerRequestHandler {
    private final LDAPListenerRequestHandler delegate;
    private final Duration bindRequestDelay;

    DelayedBindRequestHandler(LDAPListenerRequestHandler delegate, Duration bindRequestDelay) {
        this.delegate = delegate;
        this.bindRequestDelay = bindRequestDelay;
    }

    public void closeInstance() {
        this.delegate.closeInstance();
    }

    public void processAbandonRequest(int messageID, AbandonRequestProtocolOp request, List<Control> controls) {
        this.delegate.processAbandonRequest(messageID, request, controls);
    }

    public LDAPMessage processAddRequest(int messageID, AddRequestProtocolOp request, List<Control> controls) {
        return this.delegate.processAddRequest(messageID, request, controls);
    }

    public LDAPMessage processBindRequest(int messageID, BindRequestProtocolOp request, List<Control> controls) {
        try {
            Thread.sleep(this.bindRequestDelay.toMillis());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.delegate.processBindRequest(messageID, request, controls);
    }

    public LDAPMessage processCompareRequest(int messageID, CompareRequestProtocolOp request, List<Control> controls) {
        return this.delegate.processCompareRequest(messageID, request, controls);
    }

    public LDAPMessage processDeleteRequest(int messageID, DeleteRequestProtocolOp request, List<Control> controls) {
        return this.delegate.processDeleteRequest(messageID, request, controls);
    }

    public LDAPMessage processExtendedRequest(int messageID, ExtendedRequestProtocolOp request, List<Control> controls) {
        return this.delegate.processExtendedRequest(messageID, request, controls);
    }

    public LDAPMessage processModifyRequest(int messageID, ModifyRequestProtocolOp request, List<Control> controls) {
        return this.delegate.processModifyRequest(messageID, request, controls);
    }

    public LDAPMessage processModifyDNRequest(int messageID, ModifyDNRequestProtocolOp request, List<Control> controls) {
        return this.delegate.processModifyDNRequest(messageID, request, controls);
    }

    public LDAPMessage processSearchRequest(int messageID, SearchRequestProtocolOp request, List<Control> controls) {
        return this.delegate.processSearchRequest(messageID, request, controls);
    }

    public void processUnbindRequest(int messageID, UnbindRequestProtocolOp request, List<Control> controls) {
        this.delegate.processUnbindRequest(messageID, request, controls);
    }

    public LDAPListenerRequestHandler newInstance(LDAPListenerClientConnection connection) throws LDAPException {
        return new DelayedBindRequestHandler(this.delegate.newInstance(connection), this.bindRequestDelay);
    }
}

