/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken.api;

import com.floragunn.searchguard.authtoken.api.SearchAuthTokensRequest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.TimeValue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SearchAuthTokensRequestTest {
    private static final String SERIALIZED_CLASS_FROM_ES_8_18 = "AAEOBP//////////AAAAAA==";

    @Test
    public void deserializationBackwardsCompatibilityTest() throws IOException {
        SearchAuthTokensRequest deserializedRequest = this.deserializeFromBaseEncodedString(SERIALIZED_CLASS_FROM_ES_8_18);
        TimeValue deserializedRequestScroll = deserializedRequest.getScroll();
        MatcherAssert.assertThat((Object)deserializedRequestScroll, (Matcher)Matchers.equalTo((Object)TimeValue.timeValueMinutes((long)7L)));
    }

    private SearchAuthTokensRequest deserializeFromBaseEncodedString(String base64Encoded) throws IOException {
        byte[] decodedBytes = Base64.getDecoder().decode(base64Encoded);
        return SearchAuthTokensRequestTest.deserializeFromBaseEncodedString(decodedBytes);
    }

    private static SearchAuthTokensRequest deserializeFromBaseEncodedString(byte[] decodedBytes) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(decodedBytes);
        ByteBufferStreamInput in = new ByteBufferStreamInput(buffer);
        return new SearchAuthTokensRequest((StreamInput)in);
    }
}

