/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.ldap;

import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.google.common.collect.ImmutableList;
import com.unboundid.ldap.sdk.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class TestLdapDirectory {
    public static final Entry ROOT = new Entry("o=TEST").dc("TEST").objectClass("top", "domain");
    public static final Entry PEOPLE = new Entry("ou=people,o=TEST").ou("people").objectClass("top", "organizationalUnit");
    public static final Entry GROUPS = new Entry("ou=groups,o=TEST").ou("groups").objectClass("top", "organizationalUnit");
    public static final ImmutableList<Entry> BASE = ImmutableList.of((Object)ROOT, (Object)PEOPLE, (Object)GROUPS);

    public static class Entry
    implements EsClientProvider.UserCredentialsHolder {
        private final String dn;
        private List<Attribute> attributes = new ArrayList<Attribute>();
        private String uid;
        private String password;

        public Entry(String dn) {
            this.dn = dn;
        }

        public String getDn() {
            return this.dn;
        }

        public Entry cn(String ... cn) {
            this.attributes.add(new Attribute("cn", cn));
            return this;
        }

        public Entry dc(String ... dc) {
            this.attributes.add(new Attribute("dc", dc));
            return this;
        }

        public Entry ou(String ... ou) {
            this.attributes.add(new Attribute("ou", ou));
            return this;
        }

        public Entry sn(String ... sn) {
            this.attributes.add(new Attribute("sn", sn));
            return this;
        }

        public Entry uid(String ... uid) {
            this.attributes.add(new Attribute("uid", uid));
            this.uid = uid[0];
            return this;
        }

        public Entry objectClass(String ... objectclass) {
            this.attributes.add(new Attribute("objectclass", objectclass));
            if (Arrays.asList(objectclass).contains("inetOrgPerson")) {
                this.sn("Test");
            }
            return this;
        }

        public Entry ref(String ... ref) {
            this.attributes.add(new Attribute("ref", ref));
            return this;
        }

        public Entry userpassword(String ... userpassword) {
            this.attributes.add(new Attribute("userpassword", userpassword));
            this.password = userpassword[0];
            return this;
        }

        public Entry displayName(String ... displayName) {
            this.attributes.add(new Attribute("displayName", displayName));
            return this;
        }

        public Entry uniqueMember(String ... uniqueMember) {
            this.attributes.add(new Attribute("uniquemember", uniqueMember));
            return this;
        }

        public Entry uniqueMember(Entry ... uniqueMember) {
            this.attributes.add(new Attribute("uniquemember", (Collection)Arrays.asList(uniqueMember).stream().map(m -> m.getDn()).collect(Collectors.toList())));
            return this;
        }

        public Entry attr(String name, String ... values) {
            this.attributes.add(new Attribute(name, values));
            return this;
        }

        com.unboundid.ldap.sdk.Entry build() {
            return new com.unboundid.ldap.sdk.Entry(this.dn, this.attributes.toArray(new Attribute[this.attributes.size()]));
        }

        public String getName() {
            return this.uid;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

