/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.enterprise.auth.oidc.MockIpdServer;
import com.floragunn.searchguard.enterprise.auth.oidc.TestJwk;
import com.floragunn.searchguard.enterprise.auth.oidc.TestJwts;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.proxy.wiremock.WireMockRequestHeaderAddingFilter;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.junit.WireMockClassRule;
import java.io.FileNotFoundException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class OidcAuthenticatorIntegrationTest {
    protected static MockIpdServer mockIdpServer;
    private static final TestCertificates testCertificates;
    private static final WireMockRequestHeaderAddingFilter REQUEST_HEADER_ADDING_FILTER;
    @ClassRule
    public static WireMockClassRule wireMockProxy;
    private static String FRONTEND_BASE_URL;
    private static final TLSConfig IDP_TLS_CONFIG;
    public static LocalCluster.Embedded cluster;

    @BeforeClass
    public static void setUp() throws Exception {
        mockIdpServer = MockIpdServer.forKeySet(TestJwk.Jwks.ALL).acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader()).useCustomTlsConfig(IDP_TLS_CONFIG).start();
        TestSgConfig testSgConfig = new TestSgConfig().resources("oidc").frontendAuthc(new TestSgConfig.FrontendAuthc[]{new TestSgConfig.FrontendAuthc().authDomain(new TestSgConfig.FrontendAuthDomain("oidc").label("Label").config("oidc.idp.openid_configuration_url", (Object)mockIdpServer.getDiscoverUri().toString(), new Object[]{"oidc.client_id", "Der Klient", "oidc.client_secret", "Das Geheimnis", "user_mapping.roles.from", ImmutableMap.of((Object)"json_path", (Object)"jwt.roles", (Object)"split", (Object)","), "oidc.idp.proxy.host", "127.0.0.8", "oidc.idp.proxy.port", wireMockProxy.port(), "oidc.idp.proxy.scheme", "http", "oidc.idp.tls.trusted_cas", "#{file:" + testCertificates.getCaCertificate().getCertificateFile().getAbsolutePath() + "}", "oidc.idp.tls.verify_hostnames", false}))});
        cluster = new LocalCluster.Builder().sslEnabled().enterpriseModulesEnabled().singleNode().resources("oidc").sgConfig(testSgConfig).embedded().start();
    }

    @AfterClass
    public static void tearDown() {
        if (mockIdpServer != null) {
            try {
                mockIdpServer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (cluster != null) {
            try {
                cluster.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cluster = null;
        }
    }

    @Test
    public void basicTest() throws Exception {
        try (GenericRestClient client = cluster.getRestClient("kibanaserver", "kibanaserver", new Header[0]);){
            String nextUrl = "/abc/def";
            GenericRestClient.HttpResponse response = client.get("/_searchguard/auth/config?next_url=" + nextUrl + "&frontend_base_url=" + FRONTEND_BASE_URL, new Header[0]);
            String ssoLocation = ((DocNode)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").get(0)).getAsString("sso_location");
            String ssoContext = ((DocNode)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").get(0)).getAsString("sso_context");
            String id = ((DocNode)response.getBodyAsDocNode().getAsListOfNodes("auth_methods").get(0)).getAsString("id");
            Assert.assertNotNull((String)response.getBody(), (Object)ssoLocation);
            String ssoResult = mockIdpServer.handleSsoGetRequestURI(ssoLocation, TestJwts.MC_COY_SIGNED_OCT_1);
            response = client.postJson("/_searchguard/auth/session", (Map)DocNode.of((String)"method", (Object)"oidc", (String)"id", (Object)id, (String)"sso_result", (Object)ssoResult, (String)"sso_context", (Object)ssoContext, (String)"frontend_base_url", (Object)FRONTEND_BASE_URL, (Object[])new Object[0]), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            Assert.assertEquals((Object)nextUrl, (Object)response.getBodyAsDocNode().getAsString("redirect_uri"));
            String token = response.getBodyAsDocNode().getAsString("token");
            BasicHeader tokenAuth = new BasicHeader("Authorization", "Bearer " + token);
            try (GenericRestClient tokenClient = cluster.getRestClient(new Header[]{tokenAuth});){
                response = tokenClient.get("/_searchguard/auth/session", new Header[0]);
                String logoutAddress = response.getBodyAsDocNode().getAsString("sso_logout_url");
                Assert.assertNotNull((Object)logoutAddress);
            }
        }
    }

    static {
        testCertificates = TestCertificates.builder().ca("CN=root.ca.example.com,OU=SearchGuard,O=SearchGuard", 2, "password").addClients(new String[]{"CN=client.ca.example.com,OU=SearchGuard,O=SearchGuard"}).build();
        REQUEST_HEADER_ADDING_FILTER = new WireMockRequestHeaderAddingFilter("Proxy", "wire-mock");
        wireMockProxy = new WireMockClassRule((Options)WireMockConfiguration.options().bindAddress("127.0.0.8").caKeystorePath(testCertificates.getCaCertificate().getJksFile().getAbsolutePath()).trustAllProxyTargets(true).enableBrowserProxying(true).dynamicPort().extensions(new Extension[]{REQUEST_HEADER_ADDING_FILTER}));
        FRONTEND_BASE_URL = "http://whereever";
        try {
            IDP_TLS_CONFIG = new TLSConfig.Builder().trust(FileHelper.getAbsoluteFilePathFromClassPath((String)"oidc/idp/root-ca.pem").toFile()).clientCert(FileHelper.getAbsoluteFilePathFromClassPath((String)"oidc/idp/idp.pem").toFile(), FileHelper.getAbsoluteFilePathFromClassPath((String)"oidc/idp/idp.key").toFile(), "secret").build();
        }
        catch (ConfigValidationException | FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

