/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.searchguard.dlic.rest.api.AbstractRestApiUnitTest;
import com.floragunn.searchguard.dlic.rest.validation.AbstractConfigurationValidator;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.util.List;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;

public class ActionGroupsApiTest
extends AbstractRestApiUnitTest {
    @Test
    public void testActionGroupsApi() throws Exception {
        this.setup();
        this.rh.keystore = "restapi/kirk-keystore.jks";
        this.rh.sendHTTPClientCertificate = true;
        RestHelper.HttpResponse response = this.rh.executeGetRequest("/_searchguard/api/actiongroups/CRUD_UT", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Settings settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        List permissions = settings.getAsList("CRUD_UT.allowed_actions");
        Assert.assertNotNull((Object)permissions);
        Assert.assertEquals((long)2L, (long)permissions.size());
        Assert.assertTrue((boolean)permissions.contains("READ_UT"));
        Assert.assertTrue((boolean)permissions.contains("WRITE"));
        response = this.rh.executeGetRequest("/_searchguard/api/actiongroups/nothinghthere", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/actiongroups/", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/actiongroups", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/actiongroups/", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/actiongroups", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/actiongroups/GROUP_WITHOUT_TYPE", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        permissions = settings.getAsList("GROUP_WITHOUT_TYPE.allowed_actions");
        Assert.assertNotNull((Object)permissions);
        Assert.assertEquals((long)1L, (long)permissions.size());
        Assert.assertTrue((boolean)permissions.contains("indices:*"));
        this.setupStarfleetIndex();
        this.addUserWithPassword("picard", "picard", new String[]{"starfleet"}, 201);
        this.checkReadAccess(200, "picard", "picard", "sf", 0);
        this.checkWriteAccess(403, "picard", "picard", "sf", 0);
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executeDeleteRequest("/_searchguard/api/actiongroups/idonotexist", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        response = this.rh.executeDeleteRequest("/_searchguard/api/actiongroups/READ_UT", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = false;
        this.checkReadAccess(403, "picard", "picard", "sf", 0);
        this.addUserWithPassword("picard", "picard", new String[]{"captains"}, 200);
        this.checkWriteAccess(200, "picard", "picard", "sf", 0);
        this.checkReadAccess(403, "picard", "picard", "sf", 0);
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executeDeleteRequest("/_searchguard/api/actiongroups/CRUD_UT", new Header[0]);
        this.rh.sendHTTPClientCertificate = false;
        this.checkWriteAccess(403, "picard", "picard", "sf", 0);
        this.checkReadAccess(403, "picard", "picard", "sf", 0);
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePutRequest("/_searchguard/api/actiongroups/SOMEGROUP", "", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.PAYLOAD_MANDATORY.getMessage(), (Object)settings.get("reason"));
        response = this.rh.executePutRequest("/_searchguard/api/actiongroups/SOMEGROUP", "{\n \"allowed_actions\": [\"indices:data/read*\"]\n}\n", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().contains("\\\"type\\\":[{\\\"error\\\":\\\"Required attribute is missing"));
        response = this.rh.executePutRequest("/_searchguard/api/actiongroups/SOMEGROUP", FileHelper.loadFile((String)"restapi/actiongroup_not_parseable.json"), new Header[0]);
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.BODY_NOT_PARSEABLE.getMessage(), (Object)settings.get("reason"));
        response = this.rh.executePutRequest("/_searchguard/api/actiongroups/CRUD_UT", FileHelper.loadFile((String)"restapi/actiongroup_crud.json"), new Header[0]);
        Assert.assertEquals((long)201L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = false;
        this.checkReadAccess(403, "picard", "picard", "sf", 0);
        this.checkWriteAccess(200, "picard", "picard", "sf", 0);
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePutRequest("/_searchguard/api/actiongroups/READ_UT", FileHelper.loadFile((String)"restapi/actiongroup_read.json"), new Header[0]);
        Assert.assertEquals((long)201L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = false;
        this.checkReadAccess(200, "picard", "picard", "sf", 0);
        this.checkWriteAccess(200, "picard", "picard", "sf", 0);
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePutRequest("/_searchguard/api/actiongroups/CRUD_UT", FileHelper.loadFile((String)"restapi/actiongroup_readonly.json"), new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executeDeleteRequest("/_searchguard/api/actiongroups/GET_UT", new Header[0]);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePutRequest("/_searchguard/api/actiongroups/GET_UT", FileHelper.loadFile((String)"restapi/actiongroup_read.json"), new Header[0]);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().contains("Resource 'GET_UT' is read-only."));
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executeGetRequest("/_searchguard/api/actiongroups/INTERNAL", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executeDeleteRequest("/_searchguard/api/actiongroups/INTERNAL", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePutRequest("/_searchguard/api/actiongroups/INTERNAL", FileHelper.loadFile((String)"restapi/actiongroup_read.json"), new Header[0]);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups/imnothere", "[{ \"op\": \"add\", \"path\": \"/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups/GET_UT", "[{ \"op\": \"add\", \"path\": \"/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]", new Header[0]);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups/INTERNAL", "[{ \"op\": \"add\", \"path\": \"/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups/CRUD_UT", "[{ \"op\": \"add\", \"path\": \"/hidden\", \"value\": true }]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().matches(".*\"invalid_keys\"\\s*:\\s*\\{\\s*\"keys\"\\s*:\\s*\"hidden\"\\s*\\}.*"));
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups/GROUP_WITHOUT_TYPE", "[{ \"op\": \"replace\", \"path\": \"/description\", \"value\": \"must fail\" }]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().contains("'type': Required attribute is missing"));
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups/CRUD_UT", "[{ \"op\": \"add\", \"path\": \"1/INTERNAL/allowed_actions/-\", \"value\": \"DELETE\" }]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups/CRUD_UT", "[{ \"op\": \"add\", \"path\": \"/allowed_actions/-\", \"value\": \"DELETE\" }]", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/actiongroups/CRUD_UT", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        permissions = settings.getAsList("CRUD_UT.allowed_actions");
        Assert.assertNotNull((Object)permissions);
        Assert.assertEquals((long)3L, (long)permissions.size());
        Assert.assertTrue((boolean)permissions.contains("READ_UT"));
        Assert.assertTrue((boolean)permissions.contains("WRITE"));
        Assert.assertTrue((boolean)permissions.contains("DELETE"));
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups", "[{ \"op\": \"add\", \"path\": \"/GET_UT/a\", \"value\": [ \"foo\", \"bar\" ] }]", new Header[0]);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups", "[{ \"op\": \"add\", \"path\": \"/INTERNAL/a\", \"value\": [ \"foo\", \"bar\" ] }]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups", "[{ \"op\": \"replace\", \"path\": \"/GROUP_WITHOUT_TYPE/description\", \"value\": \"must fail\" }]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().contains("'GROUP_WITHOUT_TYPE.type': Required attribute is missing"));
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups", "[{ \"op\": \"remove\", \"path\": \"/GET_UT\" }]", new Header[0]);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups", "[{ \"op\": \"remove\", \"path\": \"/INTERNAL\" }]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups", "[{ \"op\": \"add\", \"path\": \"/CRUD_UT/hidden\", \"value\": true }]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().matches(".*\"invalid_keys\"\\s*:\\s*\\{\\s*\"keys\"\\s*:\\s*\"hidden\"\\s*\\}.*"));
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups", "[{ \"op\": \"add\", \"path\": \"/NEWNEWNEW\", \"value\": {\"allowed_actions\": [\"indices:data/write*\"], \"hidden\":true }}]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().matches(".*\"invalid_keys\"\\s*:\\s*\\{\\s*\"keys\"\\s*:\\s*\"hidden\"\\s*\\}.*"));
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups", "[{ \"op\": \"add\", \"path\": \"/BULKNEW1\", \"value\": {\"allowed_actions\": [\"indices:data/*\", \"cluster:monitor/*\"], \"type\": \"index\" } },{ \"op\": \"add\", \"path\": \"/BULKNEW2\", \"value\": {\"allowed_actions\": [\"READ_UT\"], \"type\": \"index\" } }]", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/actiongroups/BULKNEW1", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        permissions = settings.getAsList("BULKNEW1.allowed_actions");
        Assert.assertNotNull((Object)permissions);
        Assert.assertEquals((long)2L, (long)permissions.size());
        Assert.assertTrue((boolean)permissions.contains("indices:data/*"));
        Assert.assertTrue((boolean)permissions.contains("cluster:monitor/*"));
        response = this.rh.executeGetRequest("/_searchguard/api/actiongroups/BULKNEW2", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        permissions = settings.getAsList("BULKNEW2.allowed_actions");
        Assert.assertNotNull((Object)permissions);
        Assert.assertEquals((long)1L, (long)permissions.size());
        Assert.assertTrue((boolean)permissions.contains("READ_UT"));
        response = this.rh.executePatchRequest("/_searchguard/api/actiongroups", "[{ \"op\": \"remove\", \"path\": \"/BULKNEW1\" }]", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/actiongroups/BULKNEW1", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/actiongroups/BULKNEW2", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        permissions = settings.getAsList("BULKNEW2.allowed_actions");
        Assert.assertNotNull((Object)permissions);
        Assert.assertEquals((long)1L, (long)permissions.size());
        Assert.assertTrue((boolean)permissions.contains("READ_UT"));
    }
}

