/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.ldap;

import com.floragunn.searchguard.enterprise.auth.ldap.TestInMemoryDirectoryServer;
import com.floragunn.searchguard.enterprise.auth.ldap.TestLdapDirectory;
import com.floragunn.searchguard.test.helper.certificate.TestCertificate;
import com.floragunn.searchguard.test.helper.network.PortAllocator;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import java.io.File;
import java.net.BindException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import org.junit.rules.ExternalResource;

public class TestLdapServer
extends ExternalResource
implements AutoCloseable {
    private final InMemoryListenerConfig inMemoryListenerConfig;
    private final List<Entry> entries;
    private final String rootObjectDN;
    private final Duration bindRequestDelay;
    private TestInMemoryDirectoryServer server;
    private int port;

    public TestLdapServer(InMemoryListenerConfig inMemoryListenerConfig, List<Entry> entries, String rootObjectDN, Duration bindRequestDelay) {
        this.inMemoryListenerConfig = inMemoryListenerConfig;
        this.entries = entries;
        this.rootObjectDN = rootObjectDN;
        this.bindRequestDelay = bindRequestDelay;
    }

    protected void before() throws Throwable {
        this.server = this.tryStart(this.inMemoryListenerConfig, this.rootObjectDN);
        try {
            this.server.addEntries(this.entries);
        }
        catch (LDAPException e) {
            throw new RuntimeException(e);
        }
    }

    protected void after() {
        if (this.server != null) {
            this.server.shutDown(true);
            this.server = null;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.server != null) {
            this.server.shutDown(true);
            this.server = null;
        }
    }

    public String hostAndPort() {
        if (this.port == 0) {
            throw new IllegalStateException("Ldap server has not been started yet");
        }
        return "localhost:" + this.port;
    }

    private TestInMemoryDirectoryServer start(InMemoryListenerConfig inMemoryListenerConfig, String rootObjectDN) throws BindException {
        TestInMemoryDirectoryServer server;
        try {
            InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new DN[]{new DN(rootObjectDN)});
            config.setListenerConfigs(new InMemoryListenerConfig[]{inMemoryListenerConfig});
            config.setEnforceAttributeSyntaxCompliance(false);
            config.setEnforceSingleStructuralObjectClass(false);
            server = new TestInMemoryDirectoryServer(config, this.bindRequestDelay);
        }
        catch (LDAPException e) {
            throw new RuntimeException(e);
        }
        try {
            server.startListening();
            this.port = inMemoryListenerConfig.getListenPort();
        }
        catch (LDAPException e) {
            if (e.getCause() instanceof BindException) {
                throw (BindException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        return server;
    }

    private TestInMemoryDirectoryServer tryStart(InMemoryListenerConfig inMemoryListenerConfig, String rootObjectDN) {
        for (int i = 0; i < 10; ++i) {
            try {
                return this.start(inMemoryListenerConfig, rootObjectDN);
            }
            catch (BindException e) {
                PortAllocator.TCP.blacklist(new int[]{inMemoryListenerConfig.getListenPort()});
                int newPort = PortAllocator.TCP.allocateSingle("ldap", inMemoryListenerConfig.getListenPort() + 1);
                try {
                    inMemoryListenerConfig = new InMemoryListenerConfig(inMemoryListenerConfig.getListenerName(), inMemoryListenerConfig.getListenAddress(), newPort, inMemoryListenerConfig.getServerSocketFactory(), inMemoryListenerConfig.getClientSocketFactory(), inMemoryListenerConfig.getStartTLSSocketFactory());
                    continue;
                }
                catch (LDAPException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        throw new RuntimeException("Could not start server");
    }

    public static Builder with(List<TestLdapDirectory.Entry> list, TestLdapDirectory.Entry ... entries) {
        return new Builder().with(list).with(entries);
    }

    public static Builder with(TestLdapDirectory.Entry ... entries) {
        return new Builder().with(entries);
    }

    public static class Builder {
        private InMemoryListenerConfig inMemoryListenerConfig;
        private List<Entry> entries = new ArrayList<Entry>(30);
        private String rootObjectDN = "o=TEST";
        private Duration bindRequestDelay;

        public Builder with(List<TestLdapDirectory.Entry> entries) {
            for (TestLdapDirectory.Entry entry : entries) {
                this.entries.add(entry.build());
            }
            return this;
        }

        public Builder with(TestLdapDirectory.Entry ... entries) {
            for (TestLdapDirectory.Entry entry : entries) {
                this.entries.add(entry.build());
            }
            return this;
        }

        public Builder tls(TestCertificate testCertificate) {
            this.inMemoryListenerConfig = this.createTlsInMemoryListenerConfig(testCertificate);
            return this;
        }

        public Builder bindRequestDelay(Duration bindRequestDelay) {
            this.bindRequestDelay = bindRequestDelay;
            return this;
        }

        public TestLdapServer build() {
            return new TestLdapServer(this.inMemoryListenerConfig, this.entries, this.rootObjectDN, this.bindRequestDelay);
        }

        private InMemoryListenerConfig createTlsInMemoryListenerConfig(TestCertificate testCertificate) {
            try {
                File certJks = testCertificate.getJksFile();
                SSLUtil serverSSLUtil = new SSLUtil((KeyManager)new KeyStoreKeyManager(certJks, testCertificate.getPrivateKeyPassword().toCharArray()), (TrustManager)new TrustStoreTrustManager(certJks));
                return InMemoryListenerConfig.createLDAPSConfig((String)"ldaps", (int)PortAllocator.TCP.allocateSingle("ldap", 3890), (SSLServerSocketFactory)serverSSLUtil.createSSLServerSocketFactory());
            }
            catch (Exception e) {
                throw new RuntimeException("Error while creating SSLServerSocketFactory", e);
            }
        }
    }
}

