/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.SearchGuardModulesRegistry;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.TypedComponentRegistry;
import com.floragunn.searchguard.authc.AuthenticationBackend;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ResourceLeaksTest {
    private static final TestSgConfig.Authc.Domain MOCK_DOMAIN = new TestSgConfig.Authc.Domain("basic/mock");
    private static final TestSgConfig.Authc.Domain BASIC_INT_USER_DB_DOMAIN = new TestSgConfig.Authc.Domain("basic/internal_users_db");
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().singleNode().authc(new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{BASIC_INT_USER_DB_DOMAIN})).sslEnabled().enterpriseModulesEnabled().embedded().build();

    @BeforeClass
    public static void addMockAuthToTypedComponentRegistry() {
        SearchGuardModulesRegistry searchGuardModulesRegistry = (SearchGuardModulesRegistry)cluster.getInjectable(SearchGuardModulesRegistry.class);
        MatcherAssert.assertThat((String)"SearchGuardModulesRegistry is not null", (Object)searchGuardModulesRegistry, (Matcher)Matchers.notNullValue());
        TypedComponentRegistry typedComponentRegistry = searchGuardModulesRegistry.getTypedComponentRegistry();
        MatcherAssert.assertThat((String)"TypedComponentRegistry is not null", (Object)typedComponentRegistry, (Matcher)Matchers.notNullValue());
        typedComponentRegistry.register(MockAuthBackend.INFO);
    }

    @Before
    public void setUpMockAuthDomain() throws Exception {
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = restClient.putJson("/_searchguard/config/authc", (Document)DocNode.of((String)"auth_domains", (Object)DocNode.array((Object[])new Object[]{MOCK_DOMAIN})));
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
    }

    @Test
    public void getAndUpdateConfig_shouldNotCauseResourceLeaks() throws Exception {
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = restClient.get("/_searchguard/config/authc", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)response.getBody(), (Object)response.getBodyAsDocNode().findByJsonPath("content.auth_domains[*].type"), (Matcher)Matchers.contains((Object[])new Object[]{MOCK_DOMAIN.toDocNode().getAsString("type")}));
            DocNode mockAuthDomainConfig = DocNode.of((String)"type", (Object)"basic/mock");
            DocNode authDomainsConfig = DocNode.of((String)"auth_domains", (Object)DocNode.array((Object[])new Object[]{BASIC_INT_USER_DB_DOMAIN, mockAuthDomainConfig}));
            response = restClient.putJson("/_searchguard/config/authc", (Document)authDomainsConfig);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            authDomainsConfig = DocNode.of((String)"auth_domains", (Object)DocNode.array((Object[])new Object[]{BASIC_INT_USER_DB_DOMAIN, mockAuthDomainConfig.with("test", (Object)"test")}));
            response = restClient.patchJsonMerge("/_searchguard/config/authc", (Document)authDomainsConfig, new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            Awaitility.await((String)"Number of config instances doesn't increase after getting, putting and patching config").atMost(Duration.ofSeconds(20L)).untilAsserted(() -> MatcherAssert.assertThat((String)"Number of MockAuthBackend instances", (Object)MockAuthBackend.NUMBER_OF_INSTANCES.get(), (Matcher)Matchers.equalTo((Object)1)));
        }
    }

    @Test
    public void purgeCache_shouldNotCauseResourceLeaks() throws Exception {
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = restClient.delete("/_searchguard/api/cache", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            Awaitility.await((String)"Number of config instances doesn't increase after purging cache").atMost(Duration.ofSeconds(20L)).untilAsserted(() -> MatcherAssert.assertThat((String)"Number of MockAuthBackend instances", (Object)MockAuthBackend.NUMBER_OF_INSTANCES.get(), (Matcher)Matchers.equalTo((Object)1)));
        }
    }

    private static class MockAuthBackend
    implements AuthenticationBackend,
    AutoCloseable {
        private static final String TYPE = "mock";
        private static final ComponentState COMPONENT_STATE = new ComponentState(0, "authentication_backend", "mock", MockAuthBackend.class).initialized();
        private static final AtomicInteger NUMBER_OF_INSTANCES = new AtomicInteger(0);
        private static final TypedComponent.Info<AuthenticationBackend> INFO = new TypedComponent.Info<AuthenticationBackend>(){

            public Class<AuthenticationBackend> getType() {
                return AuthenticationBackend.class;
            }

            public String getName() {
                return MockAuthBackend.TYPE;
            }

            public TypedComponent.Factory<AuthenticationBackend> getFactory() {
                return MockAuthBackend::new;
            }
        };

        public MockAuthBackend(Map<String, Object> config, ConfigurationRepository.Context context) throws ConfigValidationException {
            if (context.isExternalResourceCreationEnabled()) {
                NUMBER_OF_INSTANCES.incrementAndGet();
            }
        }

        public CompletableFuture<AuthCredentials> authenticate(AuthCredentials authCredentials, Meter meter) throws AuthenticatorUnavailableException, CredentialsException {
            return null;
        }

        @Override
        public void close() {
            NUMBER_OF_INSTANCES.decrementAndGet();
        }

        public ComponentState getComponentState() {
            return COMPONENT_STATE;
        }

        public String getType() {
            return TYPE;
        }
    }
}

