/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.searchguard.dlic.rest.api.AbstractRestApiUnitTest;
import com.floragunn.searchguard.dlic.rest.api.Endpoint;
import com.floragunn.searchguard.legacy.test.RestHelper;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;

public class RestApInfoEndpointTest
extends AbstractRestApiUnitTest {
    @Test
    public void testLicenseApiWithSettings() throws Exception {
        this.setupWithRestRoles();
        this.rh.sendHTTPClientCertificate = false;
        RestHelper.HttpResponse response = this.rh.executeGetRequest("/_searchguard/api/permissionsinfo", new Header[]{RestApInfoEndpointTest.encodeBasicHeader((String)"worf", (String)"worf")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Settings settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        String enabled = settings.get("has_api_access");
        Assert.assertEquals((Object)"true", (Object)enabled);
        Settings disabled = settings.getByPrefix("disabled_endpoints.");
        Assert.assertEquals((long)disabled.getAsList(Endpoint.CACHE.name()).size(), (long)RestRequest.Method.values().length);
        Assert.assertEquals((long)disabled.getAsList(Endpoint.LICENSE.name()).size(), (long)RestRequest.Method.values().length);
        Assert.assertEquals((long)disabled.getAsList(Endpoint.ROLESMAPPING.name()).size(), (long)2L);
        this.tearDown();
    }

    @Test
    public void testLicenseApiWithoutSettings() throws Exception {
        this.setup();
        this.rh.sendHTTPClientCertificate = false;
        RestHelper.HttpResponse response = this.rh.executeGetRequest("/_searchguard/api/permissionsinfo", new Header[]{RestApInfoEndpointTest.encodeBasicHeader((String)"admin", (String)"admin")});
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Settings settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        String enabled = settings.get("has_api_access");
        Assert.assertEquals((Object)"false", (Object)enabled);
        Settings disabled = settings.getByPrefix("disabled_endpoints.");
        Assert.assertEquals((long)Endpoint.values().length, (long)disabled.size());
        this.tearDown();
    }
}

