/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.license;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Collection;
import org.apache.http.Header;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class LicenseInfoIntegrationTest {
    static TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/ldap").backend(DocNode.of((String)"idp.hosts", (Object)"localhost")), new TestSgConfig.Authc.Domain("basic/internal_users_db")});
    static TestSgConfig.User ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("role").clusterPermissions(new String[]{"*"})});
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().enterpriseModulesEnabled().authc(AUTHC).users(new TestSgConfig.User[]{ADMIN}).embedded().build();

    @Test
    public void basicTest() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)ADMIN, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/license/info", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (Object)ImmutableSet.of((Object)"authentication_backend/ldap", (Object)"dlsfls"), (Object)ImmutableSet.of((Collection)response.getBodyAsDocNode().getAsNode("licenses_required").getAsNode("enterprise").toListOfStrings()));
        }
    }
}

