/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken.api;

import com.floragunn.codova.config.temporal.TemporalAmountFormat;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.authtoken.RequestedPrivileges;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class CreateAuthTokenRequest
extends ActionRequest
implements ToXContentObject {
    private String tokenName;
    private String audience;
    private TemporalAmount expiresAfter;
    private RequestedPrivileges requestedPrivileges;
    private boolean freezePrivileges = true;

    public CreateAuthTokenRequest() {
    }

    public CreateAuthTokenRequest(String tokenName, RequestedPrivileges requestedPrivileges) {
        this.tokenName = tokenName;
        this.requestedPrivileges = requestedPrivileges;
    }

    public CreateAuthTokenRequest(RequestedPrivileges requestedPrivileges) {
        this.tokenName = "";
        this.requestedPrivileges = requestedPrivileges;
    }

    public CreateAuthTokenRequest(StreamInput in) throws IOException {
        super(in);
        this.tokenName = in.readString();
        this.audience = in.readOptionalString();
        String expiresAfter = in.readOptionalString();
        try {
            this.expiresAfter = TemporalAmountFormat.INSTANCE.parse(expiresAfter);
        }
        catch (ConfigValidationException e) {
            throw new IOException("Error while parsing " + expiresAfter, e);
        }
        this.requestedPrivileges = new RequestedPrivileges(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.tokenName);
        out.writeOptionalString(this.audience);
        out.writeOptionalString(TemporalAmountFormat.INSTANCE.format(this.expiresAfter));
        this.requestedPrivileges.writeTo(out);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public static CreateAuthTokenRequest parse(BytesReference document, XContentType contentType) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(DocReader.format((Format)(contentType == XContentType.YAML ? Format.YAML : Format.JSON)).readObject(BytesReference.toBytes((BytesReference)document)), validationErrors);
        CreateAuthTokenRequest result = new CreateAuthTokenRequest();
        result.tokenName = vJsonNode.get("name").asString();
        result.audience = vJsonNode.get("audience").asString();
        result.expiresAfter = vJsonNode.get("expires_after").asTemporalAmount();
        result.freezePrivileges = vJsonNode.get("freeze_privileges").withDefault(true).asBoolean();
        if (vJsonNode.hasNonNull("requested")) {
            try {
                result.requestedPrivileges = RequestedPrivileges.parse(vJsonNode.getDocumentNode().getAsNode("requested"));
            }
            catch (ConfigValidationException e) {
                validationErrors.add("requested", e);
            }
        } else {
            validationErrors.add((ValidationError)new MissingAttribute("requested", (Object)vJsonNode));
        }
        validationErrors.throwExceptionForPresentErrors();
        return result;
    }

    public RequestedPrivileges getRequestedPrivileges() {
        return this.requestedPrivileges;
    }

    public void setRequestedPrivileges(RequestedPrivileges requestedPrivileges) {
        this.requestedPrivileges = requestedPrivileges;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public TemporalAmount getExpiresAfter() {
        return this.expiresAfter;
    }

    public void setExpiresAfter(Duration expiresAfter) {
        this.expiresAfter = expiresAfter;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public boolean isFreezePrivileges() {
        return this.freezePrivileges;
    }

    public void setFreezePrivileges(boolean snapshotPrivileges) {
        this.freezePrivileges = snapshotPrivileges;
    }

    public String toJson() {
        return Strings.toString((ToXContent)this);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.tokenName != null) {
            builder.field("name", this.tokenName);
        }
        if (this.expiresAfter != null) {
            builder.field("expires_after", TemporalAmountFormat.INSTANCE.format(this.expiresAfter));
        }
        if (this.requestedPrivileges != null) {
            builder.field("requested", (ToXContent)this.requestedPrivileges);
        }
        builder.field("freeze_privileges", this.freezePrivileges);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "CreateAuthTokenRequest [tokenName=" + this.tokenName + ", audience=" + this.audience + ", expiresAfter=" + String.valueOf(this.expiresAfter) + ", requestedPrivileges=" + String.valueOf(this.requestedPrivileges) + ", freezePrivileges=" + this.freezePrivileges + "]";
    }
}

