/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.io.FileNotFoundException;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;

public abstract class AbstractRestApiUnitTest
extends SingleClusterTest {
    protected RestHelper rh = null;
    protected boolean init = true;

    protected String getResourceFolder() {
        return "restapi";
    }

    protected final void setup() throws Exception {
        Settings.Builder builder = Settings.builder();
        builder.put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"restapi/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"restapi/truststore.jks"));
        this.setup(Settings.EMPTY, new DynamicSgConfig(), builder.build(), this.init);
        this.rh = this.restHelper();
        this.rh.keystore = "restapi/kirk-keystore.jks";
    }

    protected final void setup(Settings nodeOverride) throws Exception {
        Settings.Builder builder = Settings.builder();
        builder.put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"restapi/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"restapi/truststore.jks")).put(nodeOverride);
        this.setup(Settings.EMPTY, new DynamicSgConfig(), builder.build(), this.init);
        this.rh = this.restHelper();
        this.rh.keystore = "restapi/kirk-keystore.jks";
    }

    protected final void setupAllowInvalidLicenses() throws Exception {
        Settings.Builder builder = Settings.builder();
        builder.put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"restapi/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"restapi/truststore.jks")).put("searchguard.unsupported.restapi.accept_invalid_license", true);
        this.setup(Settings.EMPTY, new DynamicSgConfig(), builder.build(), this.init);
        this.rh = this.restHelper();
        this.rh.keystore = "restapi/kirk-keystore.jks";
    }

    protected final void setupWithRestRoles() throws Exception {
        Settings.Builder builder = Settings.builder();
        builder.put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"restapi/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"restapi/truststore.jks"));
        builder.put("searchguard.restapi.roles_enabled.0", "sg_role_klingons");
        builder.put("searchguard.restapi.roles_enabled.1", "sg_role_vulcans");
        builder.put("searchguard.restapi.roles_enabled.2", "sg_test");
        builder.put("searchguard.restapi.endpoints_disabled.global.CACHE.0", "*");
        builder.put("searchguard.restapi.endpoints_disabled.sg_role_klingons.LICENSE.0", "*");
        builder.put("searchguard.restapi.endpoints_disabled.sg_role_klingons.conFiGuration.0", "*");
        builder.put("searchguard.restapi.endpoints_disabled.sg_role_klingons.wRongType.0", "WRONGType");
        builder.put("searchguard.restapi.endpoints_disabled.sg_role_klingons.ROLESMAPPING.0", "PUT");
        builder.put("searchguard.restapi.endpoints_disabled.sg_role_klingons.ROLESMAPPING.1", "DELETE");
        builder.put("searchguard.restapi.endpoints_disabled.sg_role_vulcans.SGCONFIG.0", "*");
        this.setup(Settings.EMPTY, new DynamicSgConfig(), builder.build(), this.init);
        this.rh = this.restHelper();
        this.rh.keystore = "restapi/kirk-keystore.jks";
    }

    protected void addUserWithPassword(String username, String password, String[] roles, int status) throws Exception {
        boolean sendHTTPClientCertificate = this.rh.sendHTTPClientCertificate;
        this.rh.sendHTTPClientCertificate = true;
        String payload = "{\"password\": \"" + password + "\",\"backend_roles\": [";
        for (int i = 0; i < roles.length; ++i) {
            payload = payload + "\"" + roles[i] + "\"";
            if (i + 1 >= roles.length) continue;
            payload = payload + ",";
        }
        payload = payload + "]}";
        RestHelper.HttpResponse response = this.rh.executePutRequest("/_searchguard/api/internalusers/" + username, payload, new Header[0]);
        Assert.assertEquals((long)status, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = sendHTTPClientCertificate;
    }

    protected String checkReadAccess(int status, String username, String password, String indexName, int id) throws Exception {
        boolean sendHTTPClientCertificate = this.rh.sendHTTPClientCertificate;
        this.rh.sendHTTPClientCertificate = false;
        String action = indexName + "/_doc/" + id;
        RestHelper.HttpResponse response = this.rh.executeGetRequest(action, new Header[]{AbstractRestApiUnitTest.encodeBasicHeader((String)username, (String)password)});
        int returnedStatus = response.getStatusCode();
        Assert.assertEquals((String)response.getBody(), (long)status, (long)returnedStatus);
        this.rh.sendHTTPClientCertificate = sendHTTPClientCertificate;
        return response.getBody();
    }

    protected String checkWriteAccess(int status, String username, String password, String indexName, int id) throws Exception {
        boolean sendHTTPClientCertificate = this.rh.sendHTTPClientCertificate;
        this.rh.sendHTTPClientCertificate = false;
        String action = indexName + "/_doc/" + id;
        String payload = "{\"value\" : \"true\"}";
        RestHelper.HttpResponse response = this.rh.executePutRequest(action, payload, new Header[]{AbstractRestApiUnitTest.encodeBasicHeader((String)username, (String)password)});
        int returnedStatus = response.getStatusCode();
        Assert.assertEquals((long)status, (long)returnedStatus);
        this.rh.sendHTTPClientCertificate = sendHTTPClientCertificate;
        return response.getBody();
    }

    protected void setupStarfleetIndex() throws Exception {
        boolean sendHTTPClientCertificate = this.rh.sendHTTPClientCertificate;
        this.rh.sendHTTPClientCertificate = true;
        this.rh.executePutRequest("sf", null, new Header[0]);
        this.rh.executePutRequest("sf/_doc/0", "{\"number\" : \"NCC-1701-D\"}", new Header[0]);
        this.rh.executePutRequest("sf/_doc/0", "{\"some\" : \"value\"}", new Header[0]);
        this.rh.sendHTTPClientCertificate = sendHTTPClientCertificate;
    }

    protected Settings defaultNodeSettings(boolean enableRestSSL) throws FileNotFoundException {
        Settings.Builder builder = Settings.builder();
        if (enableRestSSL) {
            builder.put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"restapi/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"restapi/truststore.jks"));
        }
        return builder.build();
    }
}

