/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.searchguard.dlic.rest.api.AbstractRestApiUnitTest;
import com.floragunn.searchguard.dlic.rest.validation.AbstractConfigurationValidator;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.util.List;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;

public class RolesMappingApiTest
extends AbstractRestApiUnitTest {
    @Test
    public void testRolesMappingApi() throws Exception {
        this.setup();
        this.rh.keystore = "restapi/kirk-keystore.jks";
        this.rh.sendHTTPClientCertificate = true;
        RestHelper.HttpResponse response = this.rh.executeGetRequest("_searchguard/api/rolesmapping", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((String)response.getHeaders().toString(), (boolean)response.getHeaders().stream().filter(h -> h.getName().equalsIgnoreCase("X-elastic-product") && h.getValue().equals("Elasticsearch")).findFirst().isPresent());
        response = this.rh.executeGetRequest("_searchguard/api/rolesmapping", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((String)response.getContentType(), (boolean)response.isJsonContentType());
        response = this.rh.executeGetRequest("/_searchguard/api/rolesmapping/sg_role_starfleet", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((String)response.getContentType(), (boolean)response.isJsonContentType());
        Settings settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((Object)"starfleet", settings.getAsList("sg_role_starfleet.backend_roles").get(0));
        Assert.assertEquals((Object)"captains", settings.getAsList("sg_role_starfleet.backend_roles").get(1));
        Assert.assertEquals((Object)"*.starfleetintranet.com", settings.getAsList("sg_role_starfleet.hosts").get(0));
        Assert.assertEquals((Object)"nagilum", settings.getAsList("sg_role_starfleet.users").get(0));
        response = this.rh.executeGetRequest("/_searchguard/api/rolesmapping/nothinghthere", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/rolesmapping/", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((String)response.getContentType(), (boolean)response.isJsonContentType());
        response = this.rh.executeGetRequest("/_searchguard/api/rolesmapping", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((String)response.getContentType(), (boolean)response.isJsonContentType());
        response = this.rh.executeGetRequest("/_searchguard/api/rolesmapping/sg_role_internal", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        this.setupStarfleetIndex();
        this.addUserWithPassword("picard", "picard", new String[]{"captains"}, 201);
        this.checkWriteAccess(201, "picard", "picard", "sf", 1);
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executeDeleteRequest("/_searchguard/api/rolesmapping/idonotexist", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        response = this.rh.executeDeleteRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_library", new Header[0]);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        response = this.rh.executeDeleteRequest("/_searchguard/api/rolesmapping/sg_role_internal", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        response = this.rh.executeDeleteRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_captains", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((String)response.getContentType(), (boolean)response.isJsonContentType());
        response = this.rh.executeGetRequest("_searchguard/api/rolesmapping", new Header[0]);
        this.rh.sendHTTPClientCertificate = false;
        this.checkWriteAccess(403, "picard", "picard", "sf", 1);
        this.checkWriteAccess(403, "picard", "picard", "sf", 1);
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executeDeleteRequest("/_searchguard/api/rolesmapping/sg_role_starfleet", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = false;
        this.checkAllSfForbidden();
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePutRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_captains", "", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.PAYLOAD_MANDATORY.getMessage(), (Object)settings.get("reason"));
        response = this.rh.executePutRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/rolesmapping_not_parseable.json"), new Header[0]);
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.BODY_NOT_PARSEABLE.getMessage(), (Object)settings.get("reason"));
        response = this.rh.executePutRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/rolesmapping_invalid_keys.json"), new Header[0]);
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.INVALID_CONFIGURATION.getMessage(), (Object)settings.get("reason"));
        Assert.assertTrue((boolean)settings.get("invalid_keys.keys").contains("theusers"));
        Assert.assertTrue((boolean)settings.get("invalid_keys.keys").contains("thebackendroles"));
        Assert.assertTrue((boolean)settings.get("invalid_keys.keys").contains("thehosts"));
        response = this.rh.executePutRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/rolesmapping_backendroles_captains_single_wrong_datatype.json"), new Header[0]);
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.WRONG_DATATYPE.getMessage(), (Object)settings.get("reason"));
        Assert.assertTrue((boolean)settings.get("backend_roles").equals("Array expected"));
        Assert.assertTrue((settings.get("hosts") == null ? 1 : 0) != 0);
        Assert.assertTrue((settings.get("users") == null ? 1 : 0) != 0);
        response = this.rh.executePutRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/rolesmapping_hosts_single_wrong_datatype.json"), new Header[0]);
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.WRONG_DATATYPE.getMessage(), (Object)settings.get("reason"));
        Assert.assertTrue((boolean)settings.get("hosts").equals("Array expected"));
        Assert.assertTrue((settings.get("backend_roles") == null ? 1 : 0) != 0);
        Assert.assertTrue((settings.get("users") == null ? 1 : 0) != 0);
        response = this.rh.executePutRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/rolesmapping_users_picard_single_wrong_datatype.json"), new Header[0]);
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertEquals((Object)AbstractConfigurationValidator.ErrorType.WRONG_DATATYPE.getMessage(), (Object)settings.get("reason"));
        Assert.assertTrue((boolean)settings.get("hosts").equals("Array expected"));
        Assert.assertTrue((boolean)settings.get("users").equals("Array expected"));
        Assert.assertTrue((boolean)settings.get("backend_roles").equals("Array expected"));
        response = this.rh.executePutRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_library", FileHelper.loadFile((String)"restapi/rolesmapping_all_access.json"), new Header[0]);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        response = this.rh.executePutRequest("/_searchguard/api/rolesmapping/sg_role_internal", FileHelper.loadFile((String)"restapi/rolesmapping_all_access.json"), new Header[0]);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        response = this.rh.executePutRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_captains", FileHelper.loadFile((String)"restapi/rolesmapping_all_access.json"), new Header[0]);
        Assert.assertEquals((long)201L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/rolesmapping/imnothere", "[{ \"op\": \"add\", \"path\": \"/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_library", "[{ \"op\": \"add\", \"path\": \"/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]", new Header[0]);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/rolesmapping/sg_role_internal", "[{ \"op\": \"add\", \"path\": \"/a/b/c\", \"value\": [ \"foo\", \"bar\" ] }]", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/rolesmapping/sg_role_vulcans", "[{ \"op\": \"add\", \"path\": \"/hidden\", \"value\": true }]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertTrue((String)response.getBody(), (boolean)response.getBody().matches(".*\"invalid_keys\"\\s*:\\s*\\{\\s*\"keys\"\\s*:\\s*\"hidden\"\\s*\\}.*"));
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/rolesmapping/sg_role_vulcans", "[{ \"op\": \"add\", \"path\": \"/backend_roles/-\", \"value\": \"spring\" }]", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/rolesmapping/sg_role_vulcans", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        List permissions = settings.getAsList("sg_role_vulcans.backend_roles");
        Assert.assertNotNull((Object)permissions);
        Assert.assertTrue((boolean)permissions.contains("spring"));
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/rolesmapping", "[{ \"op\": \"add\", \"path\": \"/imnothere/a\", \"value\": [ \"foo\", \"bar\" ] }]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/rolesmapping", "[{ \"op\": \"add\", \"path\": \"/sg_role_starfleet_library/a\", \"value\": [ \"foo\", \"bar\" ] }]", new Header[0]);
        Assert.assertEquals((long)403L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/rolesmapping", "[{ \"op\": \"add\", \"path\": \"/sg_role_internal/a\", \"value\": [ \"foo\", \"bar\" ] }]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/rolesmapping", "[{ \"op\": \"add\", \"path\": \"/sg_role_vulcans/hidden\", \"value\": true }]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().matches(".*\"invalid_keys\"\\s*:\\s*\\{\\s*\"keys\"\\s*:\\s*\"hidden\"\\s*\\}.*"));
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/rolesmapping", "[{ \"op\": \"add\", \"path\": \"/bulknew1\", \"value\": {  \"backend_roles\":[\"vulcanadmin\"]} }]", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/rolesmapping/bulknew1", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        settings = Settings.builder().loadFromSource(response.getBody(), XContentType.JSON).build();
        permissions = settings.getAsList("bulknew1.backend_roles");
        Assert.assertNotNull((Object)permissions);
        Assert.assertTrue((boolean)permissions.contains("vulcanadmin"));
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/rolesmapping", "[{ \"op\": \"add\", \"path\": \"/bulknew1\", \"value\": {  \"unknownfield\":[\"vulcanadmin\"]} }]", new Header[0]);
        Assert.assertEquals((long)400L, (long)response.getStatusCode());
        Assert.assertTrue((String)response.getContentType(), (boolean)response.isJsonContentType());
        this.rh.sendHTTPClientCertificate = true;
        response = this.rh.executePatchRequest("/_searchguard/api/rolesmapping", "[{ \"op\": \"remove\", \"path\": \"/bulknew1\"}]", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rh.executeGetRequest("/_searchguard/api/rolesmapping/bulknew1", new Header[0]);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        this.deleteAndputNewMapping("rolesmapping_backendroles_captains_list.json");
        this.checkAllSfAllowed();
        this.deleteAndputNewMapping("rolesmapping_backendroles_captains_single.json");
        this.checkAllSfAllowed();
        this.deleteAndputNewMapping("rolesmapping_users_picard_list.json");
        this.checkAllSfAllowed();
        this.deleteAndputNewMapping("rolesmapping_users_picard_single.json");
        this.checkAllSfAllowed();
        this.deleteAndputNewMapping("rolesmapping_hosts_list.json");
        this.checkAllSfAllowed();
        this.deleteAndputNewMapping("rolesmapping_hosts_single.json");
        this.checkAllSfAllowed();
        this.deleteAndputNewMapping("rolesmapping_all_access.json");
        this.checkAllSfAllowed();
        this.deleteAndputNewMapping("rolesmapping_all_noaccess.json");
        this.checkAllSfForbidden();
    }

    private void checkAllSfAllowed() throws Exception {
        this.rh.sendHTTPClientCertificate = false;
        this.checkReadAccess(200, "picard", "picard", "sf", 1);
        this.checkWriteAccess(200, "picard", "picard", "sf", 1);
    }

    private void checkAllSfForbidden() throws Exception {
        this.rh.sendHTTPClientCertificate = false;
        this.checkReadAccess(403, "picard", "picard", "sf", 1);
        this.checkWriteAccess(403, "picard", "picard", "sf", 1);
    }

    private RestHelper.HttpResponse deleteAndputNewMapping(String fileName) throws Exception {
        this.rh.sendHTTPClientCertificate = true;
        RestHelper.HttpResponse response = this.rh.executeDeleteRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_captains", new Header[0]);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.rh.executePutRequest("/_searchguard/api/rolesmapping/sg_role_starfleet_captains", FileHelper.loadFile((String)("restapi/" + fileName)), new Header[0]);
        Assert.assertEquals((long)201L, (long)response.getStatusCode());
        this.rh.sendHTTPClientCertificate = false;
        return response;
    }
}

