/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.Watch;
import com.floragunn.signals.watch.WatchBuilder;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.common.throttle.ThrottlePeriodParser;
import com.floragunn.signals.watch.common.throttle.ValidatingThrottlePeriodParser;
import com.floragunn.signals.watch.init.WatchInitializationService;
import org.apache.http.Header;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class RestApiTest {
    private static ScriptService scriptService;
    private static ThrottlePeriodParser throttlePeriodParser;
    @ClassRule
    public static LocalCluster cluster;

    @BeforeClass
    public static void setupTestData() {
        try (Client client = cluster.getInternalNodeClient();){
            client.index(new IndexRequest("testsource").source(XContentType.JSON, new Object[]{"key1", "val1", "key2", "val2"})).actionGet();
            client.index(((IndexRequest)new IndexRequest("testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "x", "b", "y"})).actionGet();
            client.index(((IndexRequest)new IndexRequest("testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "xx", "b", "yy"})).actionGet();
        }
    }

    @BeforeClass
    public static void setupDependencies() {
        scriptService = (ScriptService)cluster.getInjectable(ScriptService.class);
        throttlePeriodParser = new ValidatingThrottlePeriodParser(((Signals)cluster.getInjectable(Signals.class)).getSignalsSettings());
    }

    @Test
    public void testPutWatchWithEnterpriseFeatures() throws Exception {
        String tenant = "_main";
        String watchId = "put_test_with_enterprise_features";
        String watchPath = "/_signals/watch/" + tenant + "/" + watchId;
        try (GenericRestClient restClient = cluster.getRestClient("uhura", "uhura", new Header[0]).trackResources();){
            GenericRestClient.HttpResponse response = restClient.putJson("/_signals/account/jira/default", "{\"url\": \"http://localhost:1234\", \"user_name\": \"horst\", \"auth_token\": \"xyz\"}", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            Watch watch = new WatchBuilder(watchId).cronTrigger("* * * * * ?").search(new String[]{"testsource"}).query("{\"match_all\" : {} }").as("testsearch").put("{\"bla\": {\"blub\": 42}}").as("teststatic").then().act("jira", new Object[]{"project", "Test", "issue.type", "Bug", "issue.summary", "Bla", "issue.description", "Blub"}).name("testsink").build();
            response = restClient.putJson(watchPath, watch.toJson(), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = restClient.get(watchPath, new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            WatchInitializationService initService = new WatchInitializationService(null, scriptService, (TrustManagerRegistry)Mockito.mock(TrustManagerRegistry.class), (HttpProxyHostRegistry)Mockito.mock(HttpProxyHostRegistry.class), throttlePeriodParser, ValidationLevel.STRICT);
            watch = Watch.parseFromElasticDocument((WatchInitializationService)initService, (String)"test", (String)"put_test", (String)response.getBody(), (long)-1L);
        }
    }

    static {
        cluster = new LocalCluster.Builder().singleNode().sslEnabled().resources("sg_config/signals").nodeSettings(new Object[]{"signals.enabled", true, "signals.index_names.log", "signals_main_log"}).enterpriseModulesEnabled().enableModule(SignalsModule.class).build();
    }
}

