/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.enterprise.watch.action.handlers.pagerduty;

import com.floragunn.signals.watch.severity.SeverityLevel;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class PagerDutyEvent
implements ToXContentObject {
    private String routingKey;
    private EventAction eventAction;
    private String dedupKey;
    private Payload payload;

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public EventAction getEventAction() {
        return this.eventAction;
    }

    public void setEventAction(EventAction eventAction) {
        this.eventAction = eventAction;
    }

    public String getDedupKey() {
        return this.dedupKey;
    }

    public void setDedupKey(String dedupKey) {
        this.dedupKey = dedupKey;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public String toJson() {
        return Strings.toString((ToXContent)this);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("routing_key", this.routingKey);
        builder.field("event_action", (Enum)this.eventAction);
        builder.field("dedup_key", this.dedupKey);
        builder.field("payload", (ToXContent)this.payload);
        builder.endObject();
        return builder;
    }

    static enum EventAction {
        TRIGGER,
        ACKNOWLEDGE,
        RESOLVE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    static class Payload
    implements ToXContentObject {
        private String summary;
        private String source;
        private Severity severity;
        private String component;
        private String group;
        private String eventClass;
        private Map<String, Object> customDetails;

        Payload() {
        }

        public String getSummary() {
            return this.summary;
        }

        public void setSummary(String summary) {
            this.summary = summary;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public void setSeverity(Severity severity) {
            this.severity = severity;
        }

        public String getComponent() {
            return this.component;
        }

        public void setComponent(String component) {
            this.component = component;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getEventClass() {
            return this.eventClass;
        }

        public void setEventClass(String eventClass) {
            this.eventClass = eventClass;
        }

        public Map<String, Object> getCustomDetails() {
            return this.customDetails;
        }

        public void setCustomDetails(Map<String, Object> customDetails) {
            this.customDetails = customDetails;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("summary", this.summary);
            builder.field("source", this.source);
            builder.field("severity", (Enum)this.severity);
            builder.field("component", this.component);
            builder.field("group", this.group);
            builder.field("class", this.eventClass);
            builder.field("custom_details", this.customDetails);
            builder.endObject();
            return builder;
        }

        static enum Severity {
            INFO,
            WARNING,
            ERROR,
            CRITICAL;


            public String toString() {
                return this.name().toLowerCase();
            }

            public static Severity from(SeverityLevel severityLevel) {
                switch (severityLevel) {
                    case CRITICAL: {
                        return CRITICAL;
                    }
                    case ERROR: {
                        return ERROR;
                    }
                    case INFO: {
                        return INFO;
                    }
                    case WARNING: {
                        return WARNING;
                    }
                }
                return null;
            }
        }
    }
}

