/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.proxy.wiremock.WireMockRequestHeaderAddingFilter;
import com.floragunn.signals.MockWebserviceProvider;
import com.floragunn.signals.SignalsModule;
import com.floragunn.signals.accounts.AccountRegistry;
import com.floragunn.signals.enterprise.watch.action.handlers.jira.JiraAccount;
import com.floragunn.signals.enterprise.watch.action.handlers.jira.JiraAction;
import com.floragunn.signals.enterprise.watch.action.handlers.jira.JiraIssueConfig;
import com.floragunn.signals.enterprise.watch.action.handlers.pagerduty.PagerDutyAccount;
import com.floragunn.signals.enterprise.watch.action.handlers.pagerduty.PagerDutyAction;
import com.floragunn.signals.enterprise.watch.action.handlers.pagerduty.PagerDutyEventConfig;
import com.floragunn.signals.execution.ExecutionEnvironment;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.execution.WatchExecutionContextData;
import com.floragunn.signals.proxy.service.HttpProxyHostRegistry;
import com.floragunn.signals.support.InlineMustacheTemplate;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.truststore.service.TrustManagerRegistry;
import com.floragunn.signals.watch.action.invokers.ActionInvocationType;
import com.floragunn.signals.watch.common.HttpClientConfig;
import com.floragunn.signals.watch.common.HttpProxyConfig;
import com.floragunn.signals.watch.common.TlsConfig;
import com.floragunn.signals.watch.common.ValidationLevel;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import java.net.URI;
import java.util.Optional;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.http.HttpHost;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@PowerMockIgnore(value={"javax.script.*", "javax.crypto.*", "javax.management.*", "sun.security.*", "java.security.*", "javax.net.ssl.*", "javax.net.*", "javax.security.*"})
@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={AccountRegistry.class})
public class ActionTest {
    private static NamedXContentRegistry xContentRegistry;
    private static ScriptService scriptService;
    private static final String UPLOADED_TRUSTSTORE_ID = "my-uploaded-truststore-id";
    private final TrustManagerRegistry trustManagerRegistry = (TrustManagerRegistry)Mockito.mock(TrustManagerRegistry.class);
    private final X509ExtendedTrustManager trustManager = (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class);
    private final HttpProxyHostRegistry httpProxyHostRegistry = (HttpProxyHostRegistry)Mockito.mock(HttpProxyHostRegistry.class);
    private final ClusterService clusterService = (ClusterService)Mockito.mock(ClusterService.class);
    private final FeatureService featureService = (FeatureService)Mockito.mock(FeatureService.class);
    private final AccountRegistry accountRegistry = (AccountRegistry)Mockito.mock(AccountRegistry.class);
    private final WatchInitializationService watchInitializationService = new WatchInitializationService(this.accountRegistry, scriptService, this.trustManagerRegistry, this.httpProxyHostRegistry, null, ValidationLevel.STRICT);
    private static final WireMockRequestHeaderAddingFilter REQUEST_HEADER_ADDING_FILTER;
    @Rule
    public WireMockRule wireMockProxy = new WireMockRule((Options)WireMockConfiguration.options().bindAddress("127.0.0.8").enableBrowserProxying(true).proxyPassThrough(true).dynamicPort().extensions(new Extension[]{REQUEST_HEADER_ADDING_FILTER}));
    @ClassRule
    public static LocalCluster.Embedded cluster;

    @BeforeClass
    public static void setupTestData() throws Throwable {
        cluster.before();
        Client client = cluster.getInternalNodeClient();
        client.index(((IndexRequest)new IndexRequest("testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "x", "b", "y"})).actionGet();
        client.index(((IndexRequest)new IndexRequest("testsource").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(XContentType.JSON, new Object[]{"a", "xx", "b", "yy"})).actionGet();
    }

    @BeforeClass
    public static void setupDependencies() throws Exception {
        xContentRegistry = (NamedXContentRegistry)cluster.getInjectable(NamedXContentRegistry.class);
        scriptService = (ScriptService)cluster.getInjectable(ScriptService.class);
    }

    @Before
    public void resetMock() {
        Mockito.reset((Object[])new Object[]{this.trustManagerRegistry, this.trustManager, this.httpProxyHostRegistry, this.clusterService, this.featureService, this.accountRegistry});
    }

    @Test
    public void testPagerDutyAction() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/mockerduty");){
            PagerDutyAccount account = new PagerDutyAccount("bla");
            account.setUri(webhookProvider.getUri());
            Mockito.when((Object)((PagerDutyAccount)this.accountRegistry.lookupAccount("test_account", PagerDutyAccount.class))).thenReturn((Object)account);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("component", (Object)"stuff");
            runtimeData.put("summary", (Object)"kaputt");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            PagerDutyEventConfig eventConfig = new PagerDutyEventConfig();
            eventConfig.setDedupKey(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"my_key"));
            PagerDutyEventConfig.Payload payload = new PagerDutyEventConfig.Payload();
            payload.setComponent(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"{{data.component}}"));
            payload.setEventClass(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"my_class"));
            payload.setSource(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"hell"));
            payload.setSummary(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"{{data.summary}}"));
            eventConfig.setPayload(payload);
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, null);
            PagerDutyAction pagerDutyAction = new PagerDutyAction("test_account", eventConfig, false, httpClientConfig);
            pagerDutyAction.execute(ctx);
            Assert.assertEquals((Object)"{\"routing_key\":\"bla\",\"event_action\":\"trigger\",\"dedup_key\":\"my_key\",\"payload\":{\"summary\":\"kaputt\",\"source\":\"hell\",\"severity\":\"error\",\"component\":\"stuff\",\"group\":null,\"class\":\"my_class\",\"custom_details\":null}}", (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testPagerDutyActionWithTLS() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/mockerduty");){
            PagerDutyAccount account = new PagerDutyAccount("bla");
            account.setUri(webhookProvider.getUri());
            Mockito.when((Object)((PagerDutyAccount)this.accountRegistry.lookupAccount("test_account", PagerDutyAccount.class))).thenReturn((Object)account);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("component", (Object)"stuff");
            runtimeData.put("summary", (Object)"kaputt");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            PagerDutyEventConfig eventConfig = new PagerDutyEventConfig();
            eventConfig.setDedupKey(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"my_key"));
            PagerDutyEventConfig.Payload payload = new PagerDutyEventConfig.Payload();
            payload.setComponent(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"{{data.component}}"));
            payload.setEventClass(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"my_class"));
            payload.setSource(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"hell"));
            payload.setSummary(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"{{data.summary}}"));
            eventConfig.setPayload(payload);
            Mockito.when((Object)this.trustManagerRegistry.findTrustManager(UPLOADED_TRUSTSTORE_ID)).thenReturn(Optional.of(this.trustManager));
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setTruststoreId(UPLOADED_TRUSTSTORE_ID);
            tlsConfig.init();
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, tlsConfig, null);
            PagerDutyAction pagerDutyAction = new PagerDutyAction("test_account", eventConfig, false, httpClientConfig);
            pagerDutyAction.execute(ctx);
            Assert.assertEquals((Object)"{\"routing_key\":\"bla\",\"event_action\":\"trigger\",\"dedup_key\":\"my_key\",\"payload\":{\"summary\":\"kaputt\",\"source\":\"hell\",\"severity\":\"error\",\"component\":\"stuff\",\"group\":null,\"class\":\"my_class\",\"custom_details\":null}}", (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testPagerDutyActionWithStoredProxyConfig() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/mockerduty");){
            webhookProvider.acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader());
            String proxyId = "test-proxy";
            PagerDutyAccount account = new PagerDutyAccount("bla");
            account.setUri(webhookProvider.getUri());
            Mockito.when((Object)((PagerDutyAccount)this.accountRegistry.lookupAccount("test_account", PagerDutyAccount.class))).thenReturn((Object)account);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("component", (Object)"stuff");
            runtimeData.put("summary", (Object)"kaputt");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            PagerDutyEventConfig eventConfig = new PagerDutyEventConfig();
            eventConfig.setDedupKey(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"my_key"));
            PagerDutyEventConfig.Payload payload = new PagerDutyEventConfig.Payload();
            payload.setComponent(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"{{data.component}}"));
            payload.setEventClass(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"my_class"));
            payload.setSource(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"hell"));
            payload.setSummary(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"{{data.summary}}"));
            eventConfig.setPayload(payload);
            Mockito.when((Object)this.httpProxyHostRegistry.findHttpProxyHost(proxyId)).thenReturn(Optional.of(HttpHost.create((String)("127.0.0.8:" + this.wireMockProxy.port()))));
            HttpProxyConfig proxyConfig = HttpProxyConfig.create((ValidatingDocNode)new ValidatingDocNode(DocNode.of((String)"proxy", (Object)proxyId), new ValidationErrors()), (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.STRICT);
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, proxyConfig);
            PagerDutyAction pagerDutyAction = new PagerDutyAction("test_account", eventConfig, false, httpClientConfig);
            pagerDutyAction.execute(ctx);
            Assert.assertEquals((Object)"{\"routing_key\":\"bla\",\"event_action\":\"trigger\",\"dedup_key\":\"my_key\",\"payload\":{\"summary\":\"kaputt\",\"source\":\"hell\",\"severity\":\"error\",\"component\":\"stuff\",\"group\":null,\"class\":\"my_class\",\"custom_details\":null}}", (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testJiraAction() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/mockra/*");){
            JiraAccount account = new JiraAccount(new URI(webhookProvider.getUri()), "x", "y");
            Mockito.when((Object)((JiraAccount)this.accountRegistry.lookupAccount("test_account", JiraAccount.class))).thenReturn((Object)account);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("component", (Object)"stuff");
            runtimeData.put("summary", (Object)"kaputt");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            JiraIssueConfig jiraIssueConfig = new JiraIssueConfig("bug", InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"Look: {{data.summary}}"), InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"Indeed: {{data.summary}}"));
            jiraIssueConfig.setComponentTemplate(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"{{data.component}}"));
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, null);
            JiraAction jiraAction = new JiraAction("test_account", "Project", jiraIssueConfig, httpClientConfig);
            jiraAction.execute(ctx);
            Assert.assertEquals((Object)"{\"fields\":{\"project\":{\"key\":\"Project\"},\"summary\":\"Look: kaputt\",\"description\":\"Indeed: kaputt\",\"issuetype\":{\"name\":\"bug\"},\"components\":[{\"name\":\"stuff\"}]}}", (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testJiraActionWithTLS() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/mockra/*");){
            JiraAccount account = new JiraAccount(new URI(webhookProvider.getUri()), "x", "y");
            Mockito.when((Object)((JiraAccount)this.accountRegistry.lookupAccount("test_account", JiraAccount.class))).thenReturn((Object)account);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("component", (Object)"stuff");
            runtimeData.put("summary", (Object)"kaputt");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            JiraIssueConfig jiraIssueConfig = new JiraIssueConfig("bug", InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"Look: {{data.summary}}"), InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"Indeed: {{data.summary}}"));
            jiraIssueConfig.setComponentTemplate(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"{{data.component}}"));
            Mockito.when((Object)this.trustManagerRegistry.findTrustManager(UPLOADED_TRUSTSTORE_ID)).thenReturn(Optional.of(this.trustManager));
            TlsConfig tlsConfig = new TlsConfig(this.trustManagerRegistry, ValidationLevel.STRICT);
            tlsConfig.setTruststoreId(UPLOADED_TRUSTSTORE_ID);
            tlsConfig.init();
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, tlsConfig, null);
            JiraAction jiraAction = new JiraAction("test_account", "Project", jiraIssueConfig, httpClientConfig);
            jiraAction.execute(ctx);
            Assert.assertEquals((Object)"{\"fields\":{\"project\":{\"key\":\"Project\"},\"summary\":\"Look: kaputt\",\"description\":\"Indeed: kaputt\",\"issuetype\":{\"name\":\"bug\"},\"components\":[{\"name\":\"stuff\"}]}}", (Object)webhookProvider.getLastRequestBody());
        }
    }

    @Test
    public void testJiraActionWithStoredProxyConfig() throws Exception {
        try (MockWebserviceProvider webhookProvider = new MockWebserviceProvider("/mockra/*");){
            webhookProvider.acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader());
            String proxyId = "test-proxy";
            JiraAccount account = new JiraAccount(new URI(webhookProvider.getUri()), "x", "y");
            Mockito.when((Object)((JiraAccount)this.accountRegistry.lookupAccount("test_account", JiraAccount.class))).thenReturn((Object)account);
            NestedValueMap runtimeData = new NestedValueMap();
            runtimeData.put("path", (Object)"hook");
            runtimeData.put("component", (Object)"stuff");
            runtimeData.put("summary", (Object)"kaputt");
            WatchExecutionContext ctx = this.buildWatchExecutionContext(runtimeData);
            JiraIssueConfig jiraIssueConfig = new JiraIssueConfig("bug", InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"Look: {{data.summary}}"), InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"Indeed: {{data.summary}}"));
            jiraIssueConfig.setComponentTemplate(InlineMustacheTemplate.parse((ScriptService)this.watchInitializationService.getScriptService(), (String)"{{data.component}}"));
            Mockito.when((Object)this.httpProxyHostRegistry.findHttpProxyHost(proxyId)).thenReturn(Optional.of(HttpHost.create((String)("127.0.0.8:" + this.wireMockProxy.port()))));
            HttpProxyConfig proxyConfig = HttpProxyConfig.create((ValidatingDocNode)new ValidatingDocNode(DocNode.of((String)"proxy", (Object)proxyId), new ValidationErrors()), (HttpProxyHostRegistry)this.httpProxyHostRegistry, (ValidationLevel)ValidationLevel.STRICT);
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, proxyConfig);
            JiraAction jiraAction = new JiraAction("test_account", "Project", jiraIssueConfig, httpClientConfig);
            jiraAction.execute(ctx);
            Assert.assertEquals((Object)"{\"fields\":{\"project\":{\"key\":\"Project\"},\"summary\":\"Look: kaputt\",\"description\":\"Indeed: kaputt\",\"issuetype\":{\"name\":\"bug\"},\"components\":[{\"name\":\"stuff\"}]}}", (Object)webhookProvider.getLastRequestBody());
        }
    }

    private WatchExecutionContext buildWatchExecutionContext(NestedValueMap runtimeData) {
        return new WatchExecutionContext(cluster.getInternalNodeClient(), scriptService, xContentRegistry, this.accountRegistry, ExecutionEnvironment.SCHEDULED, ActionInvocationType.ALERT, new WatchExecutionContextData(runtimeData), this.trustManagerRegistry, this.clusterService, this.featureService);
    }

    static {
        REQUEST_HEADER_ADDING_FILTER = new WireMockRequestHeaderAddingFilter("Proxy", "wire-mock");
        cluster = new LocalCluster.Builder().singleNode().sslEnabled().nodeSettings(new Object[]{"signals.enabled", true}).resources("sg_config/signals").enterpriseModulesEnabled().enableModule(SignalsModule.class).waitForComponents(new String[]{"signals"}).embedded().build();
    }
}

