/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.enterprise.watch.action.handlers.pagerduty;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.signals.accounts.Account;
import java.io.IOException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class PagerDutyAccount
extends Account {
    public static final String TYPE = "pagerduty";
    private String url;
    private String integrationKey;

    public PagerDutyAccount(String integrationKey) {
        this.integrationKey = integrationKey;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", TYPE);
        builder.field("_name", this.getId());
        builder.field("integration_key", this.integrationKey);
        if (this.url != null) {
            builder.field("url", this.url);
        }
        builder.endObject();
        return builder;
    }

    public SearchSourceBuilder getReferencingWatchesQuery() {
        return new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"actions.type", (String)TYPE)).must((QueryBuilder)QueryBuilders.termQuery((String)"actions.account", (String)this.getId())));
    }

    public String getType() {
        return TYPE;
    }

    public String getIntegrationKey() {
        return this.integrationKey;
    }

    public void setIntegrationKey(String integrationKey) {
        this.integrationKey = integrationKey;
    }

    public String getUri() {
        return this.url;
    }

    public void setUri(String url) {
        this.url = url;
    }

    public static class Factory
    extends Account.Factory<PagerDutyAccount> {
        public Factory() {
            super(PagerDutyAccount.TYPE);
        }

        protected PagerDutyAccount create(String id, ValidatingDocNode vJsonNode, ValidationErrors validationErrors) throws ConfigValidationException {
            PagerDutyAccount result = new PagerDutyAccount(vJsonNode.get("integration_key").required().asString());
            result.setId(id);
            result.url = vJsonNode.get("url").asString();
            validationErrors.throwExceptionForPresentErrors();
            return result;
        }

        public Class<PagerDutyAccount> getImplClass() {
            return PagerDutyAccount.class;
        }
    }
}

