/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.enterprise.watch.action.handlers.jira;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.signals.enterprise.watch.action.handlers.jira.JiraAccount;
import com.floragunn.signals.enterprise.watch.action.handlers.jira.JiraAction;
import com.floragunn.signals.enterprise.watch.action.handlers.jira.JiraIssueApiCall;
import com.floragunn.signals.execution.ActionExecutionException;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.support.InlineMustacheTemplate;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class JiraIssueConfig
implements ToXContentObject {
    private InlineMustacheTemplate<String> summaryTemplate;
    private InlineMustacheTemplate<String> descriptionTemplate;
    private InlineMustacheTemplate<String> parentIssueTemplate;
    private InlineMustacheTemplate<String> priorityTemplate;
    private InlineMustacheTemplate<String> componentTemplate;
    private InlineMustacheTemplate<String> labelTemplate;
    private String issueType;

    public JiraIssueConfig(String issueType, InlineMustacheTemplate<String> summaryTemplate, InlineMustacheTemplate<String> descriptionTemplate) {
        this.issueType = issueType;
        this.summaryTemplate = summaryTemplate;
        this.descriptionTemplate = descriptionTemplate;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", this.issueType);
        if (this.parentIssueTemplate != null) {
            builder.field("parent", this.parentIssueTemplate);
        }
        builder.field("summary", this.summaryTemplate);
        builder.field("description", this.descriptionTemplate);
        if (this.priorityTemplate != null) {
            builder.field("priority", this.priorityTemplate);
        }
        if (this.componentTemplate != null) {
            builder.field("component", this.componentTemplate);
        }
        if (this.labelTemplate != null) {
            builder.field("label", this.labelTemplate);
        }
        builder.endObject();
        return builder;
    }

    JiraIssueApiCall render(WatchExecutionContext ctx, JiraAccount account, JiraAction action) throws ActionExecutionException {
        ValidationErrors validationErrors = new ValidationErrors();
        JiraIssueApiCall call = new JiraIssueApiCall();
        call.setProject(action.getProject());
        call.setIssueType(this.issueType);
        if (this.parentIssueTemplate != null) {
            call.setParent((String)this.parentIssueTemplate.get(ctx.getTemplateScriptParamsAsMap(), "parent", validationErrors));
        }
        if (this.summaryTemplate != null) {
            call.setSummary((String)this.summaryTemplate.get(ctx.getTemplateScriptParamsAsMap(), "summary", validationErrors));
        }
        if (this.descriptionTemplate != null) {
            call.setDescription((String)this.descriptionTemplate.get(ctx.getTemplateScriptParamsAsMap(), "description", validationErrors));
        }
        if (this.priorityTemplate != null) {
            call.setDescription((String)this.priorityTemplate.get(ctx.getTemplateScriptParamsAsMap(), "priority", validationErrors));
        }
        if (this.labelTemplate != null) {
            call.setLabels(Collections.singletonList((String)this.labelTemplate.get(ctx.getTemplateScriptParamsAsMap(), "label", validationErrors)));
        }
        if (this.componentTemplate != null) {
            call.setComponents(Collections.singletonList((String)this.componentTemplate.get(ctx.getTemplateScriptParamsAsMap(), "component", validationErrors)));
        }
        if (validationErrors.hasErrors()) {
            throw new ActionExecutionException(null, "Error while rendering Jira API call", validationErrors);
        }
        return call;
    }

    public InlineMustacheTemplate<String> getPriorityTemplate() {
        return this.priorityTemplate;
    }

    public void setPriorityTemplate(InlineMustacheTemplate<String> priorityTemplate) {
        this.priorityTemplate = priorityTemplate;
    }

    static JiraIssueConfig create(WatchInitializationService watchInitializationService, DocNode jsonNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        ScriptService scriptService = watchInitializationService.getScriptService();
        String issueType = vJsonNode.get("type").required().asString();
        InlineMustacheTemplate summaryTemplate = (InlineMustacheTemplate)vJsonNode.get("summary").required().byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s));
        InlineMustacheTemplate descriptionTemplate = (InlineMustacheTemplate)vJsonNode.get("description").required().byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s));
        JiraIssueConfig result = new JiraIssueConfig(issueType, (InlineMustacheTemplate<String>)summaryTemplate, (InlineMustacheTemplate<String>)descriptionTemplate);
        result.priorityTemplate = (InlineMustacheTemplate)vJsonNode.get("priority").byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s));
        result.parentIssueTemplate = (InlineMustacheTemplate)vJsonNode.get("parent").byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s));
        result.componentTemplate = (InlineMustacheTemplate)vJsonNode.get("component").byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s));
        result.labelTemplate = (InlineMustacheTemplate)vJsonNode.get("label").byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s));
        validationErrors.throwExceptionForPresentErrors();
        return result;
    }

    public InlineMustacheTemplate<String> getSummaryTemplate() {
        return this.summaryTemplate;
    }

    public void setSummaryTemplate(InlineMustacheTemplate<String> summaryTemplate) {
        this.summaryTemplate = summaryTemplate;
    }

    public InlineMustacheTemplate<String> getDescriptionTemplate() {
        return this.descriptionTemplate;
    }

    public void setDescriptionTemplate(InlineMustacheTemplate<String> descriptionTemplate) {
        this.descriptionTemplate = descriptionTemplate;
    }

    public InlineMustacheTemplate<String> getParentIssueTemplate() {
        return this.parentIssueTemplate;
    }

    public void setParentIssueTemplate(InlineMustacheTemplate<String> parentIssueTemplate) {
        this.parentIssueTemplate = parentIssueTemplate;
    }

    public InlineMustacheTemplate<String> getComponentTemplate() {
        return this.componentTemplate;
    }

    public void setComponentTemplate(InlineMustacheTemplate<String> componentTemplate) {
        this.componentTemplate = componentTemplate;
    }

    public InlineMustacheTemplate<String> getLabelTemplate() {
        return this.labelTemplate;
    }

    public void setLabelTemplate(InlineMustacheTemplate<String> labelTemplate) {
        this.labelTemplate = labelTemplate;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }
}

