/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.enterprise.watch.action.handlers.pagerduty;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.enterprise.watch.action.handlers.pagerduty.PagerDutyAccount;
import com.floragunn.signals.enterprise.watch.action.handlers.pagerduty.PagerDutyEvent;
import com.floragunn.signals.execution.ActionExecutionException;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.script.types.SignalsObjectFunctionScript;
import com.floragunn.signals.support.EnumValueParser;
import com.floragunn.signals.support.InlineMustacheTemplate;
import com.floragunn.signals.support.InlinePainlessScript;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.support.ScriptExecutionError;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class PagerDutyEventConfig
implements ToXContent {
    private InlineMustacheTemplate<PagerDutyEvent.EventAction> eventAction;
    private InlineMustacheTemplate<String> dedupKey;
    private Payload payload;

    PagerDutyEvent render(WatchExecutionContext ctx, PagerDutyAccount account) throws ActionExecutionException {
        ValidationErrors validationErrors = new ValidationErrors();
        PagerDutyEvent event = new PagerDutyEvent();
        event.setRoutingKey(account.getIntegrationKey());
        if (this.eventAction != null) {
            event.setEventAction((PagerDutyEvent.EventAction)((Object)this.eventAction.get(ctx.getTemplateScriptParamsAsMap(), "event_action", validationErrors)));
        }
        if (this.dedupKey != null) {
            event.setDedupKey((String)this.dedupKey.get(ctx.getTemplateScriptParamsAsMap(), "dedup_key", validationErrors));
        }
        if (this.payload != null) {
            try {
                event.setPayload(this.payload.render(ctx));
            }
            catch (ConfigValidationException e) {
                validationErrors.add("payload", e);
            }
        }
        if (validationErrors.hasErrors()) {
            throw new ActionExecutionException(null, "Error while rendering PagerDuty event", validationErrors);
        }
        return event;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("event_action", this.eventAction);
        builder.field("dedup_key", this.dedupKey);
        builder.field("payload", (ToXContent)this.payload);
        builder.endObject();
        return builder;
    }

    static PagerDutyEventConfig create(WatchInitializationService watchInitializationService, DocNode jsonNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        ScriptService scriptService = watchInitializationService.getScriptService();
        PagerDutyEventConfig result = new PagerDutyEventConfig();
        result.eventAction = (InlineMustacheTemplate)vJsonNode.get("event_action").byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s, (Function)new EnumValueParser(PagerDutyEvent.EventAction.class), PagerDutyEvent.EventAction.class));
        result.dedupKey = (InlineMustacheTemplate)vJsonNode.get("dedup_key").byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s));
        if (vJsonNode.hasNonNull("payload")) {
            try {
                result.payload = Payload.create(watchInitializationService, jsonNode.getAsNode("payload"));
            }
            catch (ConfigValidationException e) {
                validationErrors.add("payload", e);
            }
        } else {
            validationErrors.add((ValidationError)new MissingAttribute("payload", (Object)jsonNode));
        }
        validationErrors.throwExceptionForPresentErrors();
        return result;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public InlineMustacheTemplate<PagerDutyEvent.EventAction> getEventAction() {
        return this.eventAction;
    }

    public void setEventAction(InlineMustacheTemplate<PagerDutyEvent.EventAction> eventAction) {
        this.eventAction = eventAction;
    }

    public InlineMustacheTemplate<String> getDedupKey() {
        return this.dedupKey;
    }

    public void setDedupKey(InlineMustacheTemplate<String> dedupKey) {
        this.dedupKey = dedupKey;
    }

    public static class Payload
    implements ToXContent {
        private InlineMustacheTemplate<String> summary;
        private InlineMustacheTemplate<String> source;
        private InlineMustacheTemplate<PagerDutyEvent.Payload.Severity> severity;
        private InlineMustacheTemplate<String> component;
        private InlineMustacheTemplate<String> group;
        private InlineMustacheTemplate<String> eventClass;
        private InlinePainlessScript<SignalsObjectFunctionScript.Factory> customDetails;

        PagerDutyEvent.Payload render(WatchExecutionContext ctx) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            PagerDutyEvent.Payload payload = new PagerDutyEvent.Payload();
            if (this.summary != null) {
                payload.setSummary((String)this.summary.get(ctx.getTemplateScriptParamsAsMap(), "summary", validationErrors));
            }
            if (this.source != null) {
                payload.setSource((String)this.source.get(ctx.getTemplateScriptParamsAsMap(), "source", validationErrors));
            }
            if (this.severity != null) {
                payload.setSeverity((PagerDutyEvent.Payload.Severity)((Object)this.severity.get(ctx.getTemplateScriptParamsAsMap(), "severity", validationErrors)));
            }
            if (this.component != null) {
                payload.setComponent((String)this.component.get(ctx.getTemplateScriptParamsAsMap(), "component", validationErrors));
            }
            if (this.group != null) {
                payload.setGroup((String)this.group.get(ctx.getTemplateScriptParamsAsMap(), "group", validationErrors));
            }
            if (this.eventClass != null) {
                payload.setEventClass((String)this.eventClass.get(ctx.getTemplateScriptParamsAsMap(), "class", validationErrors));
            }
            if (this.customDetails != null && this.customDetails.getScriptFactory() != null) {
                try {
                    Object details = ((SignalsObjectFunctionScript.Factory)this.customDetails.getScriptFactory()).newInstance(Collections.emptyMap(), ctx).execute();
                    if (details instanceof Map) {
                        payload.setCustomDetails((Map<String, Object>)NestedValueMap.copy((Map)((Map)details)));
                    } else {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("_value", details);
                        payload.setCustomDetails(map);
                    }
                }
                catch (ScriptException e) {
                    validationErrors.add((ValidationError)new ScriptExecutionError("custom_details", e));
                }
            }
            validationErrors.throwExceptionForPresentErrors();
            return payload;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("summary", this.summary);
            builder.field("source", this.source);
            builder.field("severity", this.severity);
            builder.field("component", this.component);
            builder.field("group", this.group);
            builder.field("class", this.eventClass);
            builder.field("custom_details", this.customDetails);
            builder.endObject();
            return builder;
        }

        static Payload create(WatchInitializationService watchInitializationService, DocNode jsonNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
            ScriptService scriptService = watchInitializationService.getScriptService();
            Payload result = new Payload();
            result.summary = (InlineMustacheTemplate)vJsonNode.get("summary").required().byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s));
            result.source = (InlineMustacheTemplate)vJsonNode.get("source").required().byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s));
            result.severity = (InlineMustacheTemplate)vJsonNode.get("severity").byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s, (Function)new EnumValueParser(PagerDutyEvent.Payload.Severity.class), PagerDutyEvent.Payload.Severity.class));
            result.component = (InlineMustacheTemplate)vJsonNode.get("component").byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s));
            result.group = (InlineMustacheTemplate)vJsonNode.get("group").byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s));
            result.eventClass = (InlineMustacheTemplate)vJsonNode.get("class").byString(s -> InlineMustacheTemplate.parse((ScriptService)scriptService, (String)s));
            result.customDetails = (InlinePainlessScript)vJsonNode.get("custom_details").byString(s -> InlinePainlessScript.parse((String)s, (ScriptContext)SignalsObjectFunctionScript.CONTEXT, (WatchInitializationService)watchInitializationService));
            validationErrors.throwExceptionForPresentErrors();
            return result;
        }

        public InlinePainlessScript<SignalsObjectFunctionScript.Factory> getCustomDetails() {
            return this.customDetails;
        }

        public void setCustomDetails(InlinePainlessScript<SignalsObjectFunctionScript.Factory> customDetails) {
            this.customDetails = customDetails;
        }

        public InlineMustacheTemplate<String> getSummary() {
            return this.summary;
        }

        public void setSummary(InlineMustacheTemplate<String> summary) {
            this.summary = summary;
        }

        public InlineMustacheTemplate<String> getSource() {
            return this.source;
        }

        public void setSource(InlineMustacheTemplate<String> source) {
            this.source = source;
        }

        public InlineMustacheTemplate<PagerDutyEvent.Payload.Severity> getSeverity() {
            return this.severity;
        }

        public void setSeverity(InlineMustacheTemplate<PagerDutyEvent.Payload.Severity> severity) {
            this.severity = severity;
        }

        public InlineMustacheTemplate<String> getComponent() {
            return this.component;
        }

        public void setComponent(InlineMustacheTemplate<String> component) {
            this.component = component;
        }

        public InlineMustacheTemplate<String> getGroup() {
            return this.group;
        }

        public void setGroup(InlineMustacheTemplate<String> group) {
            this.group = group;
        }

        public InlineMustacheTemplate<String> getEventClass() {
            return this.eventClass;
        }

        public void setEventClass(InlineMustacheTemplate<String> eventClass) {
            this.eventClass = eventClass;
        }
    }
}

