/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.enterprise.watch.action.handlers.jira;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.signals.accounts.Account;
import java.io.IOException;
import java.net.URI;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class JiraAccount
extends Account {
    public static final String TYPE = "jira";
    private URI url;
    private String userName;
    private String authToken;

    public JiraAccount(URI url, String userName, String authToken) {
        this.url = url;
        this.userName = userName;
        this.authToken = authToken;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", TYPE);
        builder.field("_name", this.getId());
        builder.field("url", this.url != null ? this.url.toString() : null);
        builder.field("user_name", this.userName);
        builder.field("auth_token", this.authToken);
        builder.endObject();
        return builder;
    }

    public SearchSourceBuilder getReferencingWatchesQuery() {
        return new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"actions.type", (String)TYPE)).must((QueryBuilder)QueryBuilders.termQuery((String)"actions.account", (String)this.getId())));
    }

    public String getType() {
        return TYPE;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public static class Factory
    extends Account.Factory<JiraAccount> {
        public Factory() {
            super(JiraAccount.TYPE);
        }

        protected JiraAccount create(String id, ValidatingDocNode vJsonNode, ValidationErrors validationErrors) throws ConfigValidationException {
            JiraAccount result = new JiraAccount(vJsonNode.get("url").required().asURI(), vJsonNode.get("user_name").required().asString(), vJsonNode.get("auth_token").required().asString());
            result.setId(id);
            validationErrors.throwExceptionForPresentErrors();
            return result;
        }

        public Class<JiraAccount> getImplClass() {
            return JiraAccount.class;
        }
    }
}

