/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedAuthorizationBase;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.meta.Meta;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RoleBasedFieldAuthorization
extends RoleBasedAuthorizationBase<FlsRule, FlsRule> {
    public RoleBasedFieldAuthorization(SgDynamicConfiguration<Role> roles, Meta indexMetadata, MetricsLevel metricsLevel) {
        super(roles, indexMetadata, metricsLevel, RoleBasedFieldAuthorization::roleToRule);
    }

    static FlsRule roleToRule(Role.Index rolePermissions) {
        ImmutableList flsPatterns = rolePermissions.getFls();
        if (flsPatterns != null && !flsPatterns.isEmpty()) {
            return new FlsRule.SingleRole(rolePermissions);
        }
        return null;
    }

    @Override
    protected FlsRule unrestricted() {
        return FlsRule.ALLOW_ALL;
    }

    @Override
    protected FlsRule fullyRestricted() {
        return FlsRule.DENY_ALL;
    }

    @Override
    protected FlsRule compile(PrivilegesEvaluationContext context, Collection<FlsRule> rules) throws PrivilegesEvaluationException {
        if (rules.isEmpty()) {
            return FlsRule.DENY_ALL;
        }
        return FlsRule.merge(rules);
    }

    @Override
    protected String hasRestrictionsMetricName() {
        return "has_fls_restrictions";
    }

    @Override
    protected String evaluateRestrictionsMetricName() {
        return "evaluate_fls_restrictions";
    }

    @Override
    protected String componentName() {
        return "role_based_field_authorization";
    }

    public static abstract class FlsRule {
        public static final FlsRule ALLOW_ALL = new SingleRole((ImmutableList<Role.Index.FlsPattern>)ImmutableList.of((Object)Role.Index.FlsPattern.INCLUDE_ALL));
        public static final FlsRule DENY_ALL = new SingleRole((ImmutableList<Role.Index.FlsPattern>)ImmutableList.of((Object)Role.Index.FlsPattern.EXCLUDE_ALL));

        public static FlsRule of(String ... rules) throws ConfigValidationException {
            ImmutableList.Builder patterns = new ImmutableList.Builder();
            for (String rule : rules) {
                patterns.add((Object)new Role.Index.FlsPattern(rule));
            }
            return new SingleRole((ImmutableList<Role.Index.FlsPattern>)patterns.build());
        }

        static FlsRule merge(Collection<FlsRule> rules) {
            if (rules.size() == 1) {
                return rules.iterator().next();
            }
            ImmutableList.Builder entries = new ImmutableList.Builder(rules.size());
            for (FlsRule rule : rules) {
                if (rule instanceof SingleRole) {
                    entries.add((Object)((SingleRole)rule));
                    continue;
                }
                if (!(rule instanceof MultiRole)) continue;
                for (SingleRole subRule : ((MultiRole)rule).entries) {
                    entries.add((Object)subRule);
                }
            }
            return new MultiRole((ImmutableList<SingleRole>)entries.build());
        }

        public abstract boolean isAllowed(String var1);

        public abstract boolean isAllowAll();

        static String stripKeywordSuffix(String field) {
            if (field.endsWith(".keyword")) {
                return field.substring(0, field.length() - ".keyword".length());
            }
            return field;
        }

        static class SingleRole
        extends FlsRule {
            final Role.Index sourceIndex;
            final ImmutableList<Role.Index.FlsPattern> patterns;
            final Map<String, Boolean> cache;
            final boolean allowAll;

            SingleRole(Role.Index sourceIndex) {
                this.sourceIndex = sourceIndex;
                int exclusions = 0;
                int inclusions = 0;
                for (Role.Index.FlsPattern pattern : sourceIndex.getFls()) {
                    if (pattern.isExcluded()) {
                        ++exclusions;
                        continue;
                    }
                    ++inclusions;
                }
                this.patterns = exclusions == 0 && inclusions == 0 ? ImmutableList.of((Object)Role.Index.FlsPattern.INCLUDE_ALL) : (exclusions != 0 && inclusions == 0 ? ImmutableList.of((Object)Role.Index.FlsPattern.INCLUDE_ALL).with((Collection)sourceIndex.getFls()) : (exclusions == 0 && inclusions != 0 ? ImmutableList.of((Object)Role.Index.FlsPattern.EXCLUDE_ALL).with((Collection)sourceIndex.getFls()) : sourceIndex.getFls()));
                this.allowAll = this.patterns.isEmpty() || this.patterns.size() == 1 && ((Role.Index.FlsPattern)this.patterns.get(0)).getPattern().isWildcard() && !((Role.Index.FlsPattern)this.patterns.get(0)).isExcluded();
                this.cache = this.allowAll ? null : new ConcurrentHashMap<String, Boolean>();
            }

            public SingleRole(ImmutableList<Role.Index.FlsPattern> patterns) {
                this.patterns = patterns;
                this.sourceIndex = null;
                this.allowAll = patterns.isEmpty() || patterns.size() == 1 && ((Role.Index.FlsPattern)patterns.get(0)).getPattern().isWildcard() && !((Role.Index.FlsPattern)patterns.get(0)).isExcluded();
                this.cache = null;
            }

            @Override
            public boolean isAllowed(String field) {
                if (this.allowAll) {
                    return true;
                }
                if (this.cache == null) {
                    return this.internalIsAllowed(field);
                }
                Boolean allowed = this.cache.get(field);
                if (allowed != null) {
                    return allowed;
                }
                allowed = this.internalIsAllowed(field);
                this.cache.put(field, allowed);
                return allowed;
            }

            private boolean internalIsAllowed(String field) {
                field = SingleRole.stripKeywordSuffix(field);
                boolean allowed = false;
                for (Role.Index.FlsPattern pattern : this.patterns) {
                    if (!pattern.getPattern().matches(field)) continue;
                    if (pattern.isExcluded()) {
                        allowed = false;
                        continue;
                    }
                    allowed = true;
                }
                return allowed;
            }

            @Override
            public boolean isAllowAll() {
                return this.allowAll;
            }

            public String toString() {
                if (this.isAllowAll()) {
                    return "FLS:*";
                }
                return "FLS:" + this.patterns;
            }
        }

        static class MultiRole
        extends FlsRule {
            final ImmutableList<SingleRole> entries;
            final Map<String, Boolean> cache;
            final boolean allowAll;

            MultiRole(ImmutableList<SingleRole> entries) {
                this.entries = entries;
                this.allowAll = entries.forAnyApplies(e -> e.isAllowAll());
                this.cache = this.allowAll ? null : new ConcurrentHashMap<String, Boolean>();
            }

            @Override
            public boolean isAllowed(String field) {
                if (this.allowAll) {
                    return true;
                }
                if (this.cache == null) {
                    return this.internalIsAllowed(field);
                }
                Boolean allowed = this.cache.get(field);
                if (allowed != null) {
                    return allowed;
                }
                allowed = this.internalIsAllowed(field);
                this.cache.put(field, allowed);
                return allowed;
            }

            private boolean internalIsAllowed(String field) {
                field = MultiRole.stripKeywordSuffix(field);
                for (SingleRole entry : this.entries) {
                    if (!entry.isAllowed(field)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isAllowAll() {
                return this.allowAll;
            }

            public String toString() {
                if (this.isAllowAll()) {
                    return "FLS:*";
                }
                return "FLS:" + this.entries.map(e -> e.patterns);
            }
        }
    }
}

