/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.documents.patch.PatchableDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class FeMultiTenancyConfig
implements PatchableDocument<FeMultiTenancyConfig> {
    public static CType<FeMultiTenancyConfig> TYPE = new CType("frontend_multi_tenancy", "Frontend Multi-Tenancy", 10001, FeMultiTenancyConfig.class, FeMultiTenancyConfig::parse, CType.Storage.OPTIONAL, CType.Arity.SINGLE);
    public static final FeMultiTenancyConfig DEFAULT = new FeMultiTenancyConfig(null, false, "kibanaserver", ".kibana", true, (List<String>)ImmutableList.empty());
    private final DocNode source;
    private final boolean enabled;
    private final String index;
    private final String serverUsername;
    private final boolean globalTenantEnabled;
    private final boolean privateTenantEnabled;
    private final List<String> preferredTenants;
    private final MetricsLevel metricsLevel = MetricsLevel.DETAILED;

    FeMultiTenancyConfig(DocNode source, boolean enabled, String serverUsername, String index, boolean globalTenantEnabled, List<String> preferredTenants) {
        this.source = source;
        this.enabled = enabled;
        this.serverUsername = serverUsername;
        this.index = index;
        this.globalTenantEnabled = globalTenantEnabled;
        this.privateTenantEnabled = false;
        this.preferredTenants = preferredTenants;
    }

    public static ValidationResult<FeMultiTenancyConfig> parse(DocNode docNode, Parser.Context context) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
        boolean enabled = vNode.get("enabled").withDefault(DEFAULT.isEnabled()).asBoolean();
        String index = vNode.get("index").withDefault(DEFAULT.getIndex()).asString();
        String serverUsername = vNode.get("server_user").withDefault(DEFAULT.getServerUsername()).asString();
        boolean globalTenantEnabled = vNode.get("global_tenant_enabled").withDefault(DEFAULT.isGlobalTenantEnabled()).asBoolean();
        ImmutableList preferredTenants = vNode.get("preferred_tenants").asList().withEmptyListAsDefault().ofStrings();
        vNode.checkForUnusedAttributes();
        return new ValidationResult((Object)new FeMultiTenancyConfig(docNode, enabled, serverUsername, index, globalTenantEnabled, (List<String>)preferredTenants), validationErrors);
    }

    public static FeMultiTenancyConfig parseLegacySgConfig(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors);
        boolean enabled = vNode.get("dynamic.kibana.multitenancy_enabled").withDefault(DEFAULT.isEnabled()).asBoolean();
        String index = vNode.get("dynamic.kibana.index").withDefault(DEFAULT.getIndex()).asString();
        String serverUsername = vNode.get("dynamic.kibana.server_username").withDefault(DEFAULT.getServerUsername()).asString();
        boolean globalTenantEnabled = vNode.get("dynamic.kibana.global_tenant_enabled").withDefault(DEFAULT.isGlobalTenantEnabled()).asBoolean();
        ImmutableList preferredTenants = vNode.get("dynamic.kibana.preferred_tenants").asList().withEmptyListAsDefault().ofStrings();
        vNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        return new FeMultiTenancyConfig(null, enabled, serverUsername, index, globalTenantEnabled, (List<String>)preferredTenants);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDisabled() {
        return !this.isEnabled();
    }

    public String getIndex() {
        return this.index;
    }

    public String getServerUsername() {
        return this.serverUsername;
    }

    public boolean isGlobalTenantEnabled() {
        return this.globalTenantEnabled;
    }

    public boolean isPrivateTenantEnabled() {
        return this.privateTenantEnabled;
    }

    public List<String> getPreferredTenants() {
        return this.preferredTenants;
    }

    public Map<String, Object> toBasicObject() {
        if (this.source != null) {
            return this.source;
        }
        return ImmutableMap.of((Object)"enabled", (Object)this.enabled, (Object)"index", (Object)this.index, (Object)"server_user", (Object)this.serverUsername, (Object)"global_tenant_enabled", (Object)this.globalTenantEnabled, (Object)"preferred_tenants", this.preferredTenants);
    }

    public String toString() {
        return "FeMultiTenancyConfig [source=" + this.source + ", enabled=" + this.enabled + ", index=" + this.index + ", serverUsername=" + this.serverUsername + ", globalTenantEnabled=" + this.globalTenantEnabled + ", preferredTenants=(" + String.join((CharSequence)", ", this.preferredTenants) + ")]";
    }

    public FeMultiTenancyConfig parseI(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        return (FeMultiTenancyConfig)FeMultiTenancyConfig.parse(docNode, (Parser.Context)((ConfigurationRepository.Context)context)).get();
    }

    public MetricsLevel getMetricsLevel() {
        return this.metricsLevel;
    }

    public FeMultiTenancyConfig withEnabled(boolean enabled) {
        DocNode updatedSources = this.source == null ? null : this.source.with("enabled", (Object)enabled);
        return new FeMultiTenancyConfig(updatedSources, enabled, this.serverUsername, this.index, this.globalTenantEnabled, this.preferredTenants);
    }
}

