/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.RequestResponseTenantData;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.TenantIndex;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.IndexSettingsManager;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.search.SearchHit;

class CopyDataToTempIndexStep
implements MigrationStep {
    private static final Logger log = LogManager.getLogger(CopyDataToTempIndexStep.class);
    private final StepRepository repository;
    private final FeMultiTenancyConfigurationProvider configurationProvider;
    private final IndexSettingsManager indexSettingsManager;

    CopyDataToTempIndexStep(StepRepository repository, FeMultiTenancyConfigurationProvider configurationProvider, IndexSettingsManager indexSettingsManager) {
        this.repository = Objects.requireNonNull(repository, "Step repository is required");
        this.configurationProvider = Objects.requireNonNull(configurationProvider, "Multi tenancy configuration provider is required");
        this.indexSettingsManager = Objects.requireNonNull(indexSettingsManager, "Index settings manager is required");
    }

    @Override
    public StepResult execute(DataMigrationContext context) throws StepException {
        AtomicLong documentCounter = new AtomicLong(0L);
        String indexNamePrefix = this.configurationProvider.getKibanaIndex();
        ImmutableList<TenantIndex> sourceIndices = this.chooseSourceIndices(context);
        for (TenantIndex tenantIndex : sourceIndices) {
            log.info("Start moving documents to temp index for tenant '{}'.", (Object)tenantIndex);
            this.repository.forEachDocumentInIndex(tenantIndex.indexName(), 100, searchHits -> {
                HashMap<String, String> map = new HashMap<String, String>();
                for (SearchHit hit : searchHits) {
                    String scopedId = CopyDataToTempIndexStep.scopeId(hit, tenantIndex, indexNamePrefix);
                    log.debug("Scoped id '{}' assigned to document '{}' from index '{}'", (Object)scopedId, (Object)hit.getId(), (Object)hit.getIndex());
                    if (map.containsKey(scopedId)) {
                        String details = "Document with id '" + hit.getId() + "' already exists in index '" + tenantIndex.indexName() + "'.";
                        throw new StepException("Document already exists", StepExecutionStatus.DOCUMENT_ALREADY_EXISTS_ERROR, details);
                    }
                    String source = hit.getSourceAsString();
                    map.put(scopedId, source);
                }
                if (!map.isEmpty()) {
                    log.debug("Creating '{}' documents in temp index.", (Object)map.size());
                    this.repository.bulkCreate(context.getTempIndexName(), map);
                    documentCounter.addAndGet(map.size());
                }
            });
        }
        this.repository.refreshIndex(context.getTempIndexName());
        this.repository.flushIndex(context.getTempIndexName());
        long count = documentCounter.get();
        String message = "Stored '" + count + "' documents in temp index '" + context.getTempIndexName() + "'.";
        String details = sourceIndices.stream().map(TenantIndex::indexName).map(indexName -> "'" + indexName + "'").collect(Collectors.joining(", "));
        return new StepResult(StepExecutionStatus.OK, message, "Source indices: " + details);
    }

    private ImmutableList<TenantIndex> chooseSourceIndices(DataMigrationContext context) {
        if (this.indexSettingsManager.isMigrationMarkerPresent(context.getGlobalTenantIndexName())) {
            String backupIndexName = this.getNewestBackupIndexWithoutMigrationMarker(context);
            return ImmutableList.of((Object)new TenantIndex(backupIndexName, "SGS_GLOBAL_TENANT")).with(context.getTenantIndicesWithoutGlobalTenant());
        }
        return context.getTenantIndices();
    }

    private String getNewestBackupIndexWithoutMigrationMarker(DataMigrationContext context) {
        ImmutableList<String> backupIndices = context.getBackupIndices();
        if (backupIndices.isEmpty()) {
            String message = "Global tenant index contains migration marker and backup index does not exist";
            throw new StepException(message, StepExecutionStatus.BACKUP_FROM_PREVIOUS_MIGRATION_NOT_AVAILABLE_ERROR, null);
        }
        for (String backupIndex : backupIndices) {
            if (this.indexSettingsManager.isMigrationMarkerPresent(backupIndex)) continue;
            return backupIndex;
        }
        Object message = "Backup index without migration marker not found";
        String details = "Existing backup indices: " + backupIndices.stream().map(index -> "'" + index + "'").collect(Collectors.joining(", "));
        throw new StepException((String)message, StepExecutionStatus.BACKUP_INDICES_CONTAIN_MIGRATION_MARKER, details);
    }

    private static String scopeId(SearchHit hit, TenantIndex tenant, String indexNamePrefix) {
        String id = hit.getId();
        if (RequestResponseTenantData.isScopedId(id)) {
            String message = "Index '" + hit.getIndex() + "' contains already migrated document '" + hit.getId() + "'.";
            throw new StepException(message, StepExecutionStatus.DOCUMENT_ALREADY_MIGRATED_ERROR, null);
        }
        if (tenant.belongsToUserPrivateTenant()) {
            if (!tenant.indexName().startsWith(indexNamePrefix)) {
                String message = "Incorrect index name prefix for user private tenant";
                String details = "Invalid index name '" + tenant.indexName() + "'.";
                throw new StepException(message, StepExecutionStatus.INCORRECT_INDEX_NAME_PREFIX_ERROR, details);
            }
            return RequestResponseTenantData.scopedIdForPrivateTenantIndexName(id, tenant.indexName(), indexNamePrefix).orElseThrow(() -> new StepException("Cannot extract user private tenant name from index name '" + tenant.indexName() + "'", StepExecutionStatus.UNKNOWN_USER_PRIVATE_TENANT_NAME_ERROR, null));
        }
        String internalTenantName = TenantManager.toInternalTenantName((String)tenant.tenantName());
        return RequestResponseTenantData.scopedId(id, internalTenantName);
    }

    @Override
    public String name() {
        return "copy data to temp index";
    }
}

