/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.AddMigrationMarkerToGlobalTenantIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CheckIfIndicesAreBlockedStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CheckIndicesStateStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CopyDataToGlobalIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CopyDataToTempIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CreateBackupOfGlobalIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CreateTempIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.DeleteGlobalIndexContentStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.DeleteTempIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.EnableMultitenancyStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.IndexSettingsManager;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.PopulateBackupIndicesStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.PopulateTenantsStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.UnblockDataIndicesStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.VerifyPreviousBackupStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.WriteBlockStep;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import java.util.Objects;

public class StepsFactory {
    private final PrivilegedConfigClient client;
    private final FeMultiTenancyConfigurationProvider configurationProvider;
    private final ConfigurationRepository configurationRepository;

    public StepsFactory(PrivilegedConfigClient privilegedConfigClient, FeMultiTenancyConfigurationProvider provider, ConfigurationRepository configurationRepository) {
        this.client = Objects.requireNonNull(privilegedConfigClient, "Privileged config client is required");
        this.configurationProvider = Objects.requireNonNull(provider, "Multi-tenancy configuration provider is required");
        this.configurationRepository = Objects.requireNonNull(configurationRepository, "Configuration repository is required");
    }

    public ImmutableList<MigrationStep> createSteps() {
        StepRepository repository = new StepRepository(this.client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        return ImmutableList.of((Object)new PopulateTenantsStep(this.configurationProvider, repository), (Object)new PopulateBackupIndicesStep(repository), (Object)new CheckIndicesStateStep(repository), (Object[])new MigrationStep[]{new CheckIfIndicesAreBlockedStep(repository), new WriteBlockStep(repository), new CreateTempIndexStep(settingsManager), new CopyDataToTempIndexStep(repository, this.configurationProvider, settingsManager), new CreateBackupOfGlobalIndexStep(repository, settingsManager), new VerifyPreviousBackupStep(repository, settingsManager), new AddMigrationMarkerToGlobalTenantIndexStep(settingsManager), new DeleteGlobalIndexContentStep(repository), new CopyDataToGlobalIndexStep(repository), new UnblockDataIndicesStep(repository), new DeleteTempIndexStep(repository), new EnableMultitenancyStep(this.configurationProvider, this.configurationRepository)});
    }
}

