/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request.handler;

import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.enterprise.femt.request.handler.RequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.TenantScopedActionListenerWrapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.UpdateByQueryMapper;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;

public class UpdateByQueryRequestHandler
extends RequestHandler<UpdateByQueryRequest> {
    private final Client nodeClient;
    private final ThreadContext threadContext;
    private final UpdateByQueryMapper updateByQueryMapper;

    public UpdateByQueryRequestHandler(Client nodeClient, ThreadContext threadContext, UpdateByQueryMapper updateByQueryMapper) {
        this.nodeClient = Objects.requireNonNull(nodeClient, "nodeClient is required");
        this.threadContext = Objects.requireNonNull(threadContext, "threadContext is required");
        this.updateByQueryMapper = Objects.requireNonNull(updateByQueryMapper, "updateByQueryMapper is required");
    }

    @Override
    public SyncAuthorizationFilter.Result handle(PrivilegesEvaluationContext context, String requestedTenant, UpdateByQueryRequest request, ActionListener<?> listener) {
        this.log.debug("Handle update by query request");
        try (ThreadContext.StoredContext storedContext = this.threadContext.newStoredContext();){
            this.threadContext.putHeader("_sg_filter_level_femt_done", request.toString());
            UpdateByQueryRequest scoped = this.updateByQueryMapper.toScopedUpdateByQueryRequest(request, requestedTenant);
            TenantScopedActionListenerWrapper<BulkByScrollResponse> listenerWrapper = new TenantScopedActionListenerWrapper<BulkByScrollResponse>(listener, storedContext, this.updateByQueryMapper);
            this.nodeClient.execute((ActionType)UpdateByQueryAction.INSTANCE, (ActionRequest)scoped, listenerWrapper);
            SyncAuthorizationFilter.Result result = SyncAuthorizationFilter.Result.INTERCEPTED;
            return result;
        }
    }
}

