/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.tenants;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class TenantRepository {
    private static final Logger log = LogManager.getLogger(TenantRepository.class);
    public static final String AGGREGATION_NAME = "documents_per_tenant";
    public static final String MAIN_FRONTEND_INDEX_ALIAS = ".kibana";
    public static final String[] FRONTEND_MULTI_TENANCY_ALIASES = new String[]{".kibana", ".kibana_analytics", ".kibana_ingest", ".kibana_security_solution", ".kibana_alerting_cases"};
    private final PrivilegedConfigClient client;

    public TenantRepository(PrivilegedConfigClient client) {
        this.client = Objects.requireNonNull(client, "Config client is required");
    }

    public ImmutableSet<String> exists(String ... names) {
        Objects.requireNonNull(names, "Tenant names are required");
        if (names.length == 0) {
            return ImmutableSet.empty();
        }
        Set<String> existingTenants = this.findExistingNonGlobalTenants(names);
        if (ImmutableSet.ofArray((Object[])names).contains((Object)"SGS_GLOBAL_TENANT") && this.checkIfGlobalTenantExists()) {
            existingTenants.add("SGS_GLOBAL_TENANT");
        }
        return ImmutableSet.of(existingTenants);
    }

    private boolean checkIfGlobalTenantExists() {
        try {
            GetRequest request = new GetRequest(MAIN_FRONTEND_INDEX_ALIAS, "space:default");
            GetResponse globalTenantDefaultSpaceResponse = (GetResponse)this.client.get(request).actionGet();
            return globalTenantDefaultSpaceResponse.isExists();
        }
        catch (IndexNotFoundException ex) {
            log.debug("Main front-end index does not exist", (Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> findExistingNonGlobalTenants(String[] names) {
        HashMap<String, String> internalNameToNameMap = new HashMap<String, String>();
        for (String currentTenant : names) {
            internalNameToNameMap.put(TenantManager.toInternalTenantName((String)currentTenant), currentTenant);
        }
        SearchRequest searchRequest = TenantRepository.buildTenantsExistQuery(internalNameToNameMap);
        SearchResponse response = (SearchResponse)this.client.search(searchRequest).actionGet();
        try {
            if (!RestStatus.OK.equals((Object)response.status())) {
                log.error("Unexpected error occurred during loading information of available tenant, search response '{}'", (Object)response);
                throw new RuntimeException("Cannot retrieve information about existing frontend tenants");
            }
            StringTerms aggregation = Optional.ofNullable(response.getAggregations()).map(aggregations -> aggregations.get(AGGREGATION_NAME)).filter(StringTerms.class::isInstance).map(StringTerms.class::cast).orElse(null);
            HashSet<String> existingTenants = new HashSet<String>();
            if (Objects.nonNull(aggregation)) {
                for (StringTerms.Bucket bucket : aggregation.getBuckets()) {
                    String internalTenantName = bucket.getKeyAsString();
                    long docCount = bucket.getDocCount();
                    if (!internalNameToNameMap.containsKey(internalTenantName)) {
                        throw new RuntimeException("Unexpected internal tenant name '" + internalTenantName + "'");
                    }
                    if (docCount <= 0L) continue;
                    existingTenants.add((String)internalNameToNameMap.get(internalTenantName));
                }
            }
            HashSet<String> hashSet = existingTenants;
            return hashSet;
        }
        finally {
            response.decRef();
        }
    }

    void extendTenantsIndexMappings(DocNode mappings) {
        mappings = mappings.hasNonNull("properties") ? mappings : DocNode.of((String)"properties", (Object)mappings);
        PutMappingRequest putMappingRequest = new PutMappingRequest(FRONTEND_MULTI_TENANCY_ALIASES).source((Map)mappings).indicesOptions(IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().includeHidden(true).allowEmptyExpressions(true).build()).build());
        this.client.admin().indices().putMapping(putMappingRequest).actionGet();
    }

    private static SearchRequest buildTenantsExistQuery(Map<String, String> internalNameToNameMap) {
        SearchRequest searchRequest = new SearchRequest(FRONTEND_MULTI_TENANCY_ALIASES);
        searchRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        SearchSourceBuilder sources = SearchSourceBuilder.searchSource().size(0).query((QueryBuilder)QueryBuilders.termsQuery((String)"sg_tenant", (String[])((String[])internalNameToNameMap.keySet().toArray(String[]::new)))).aggregation((AggregationBuilder)AggregationBuilders.terms((String)AGGREGATION_NAME).size(10000).field("sg_tenant"));
        searchRequest.source(sources);
        return searchRequest;
    }
}

