/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import java.util.Optional;
import org.elasticsearch.rest.RestRequest;

public class SignalsTenantParamResolver {
    private SignalsTenantParamResolver() {
    }

    public static String getRequestedTenant(RestRequest request) {
        Optional<String> tenantFromUri = SignalsTenantParamResolver.getSignalsTenantFrom(request);
        if (tenantFromUri.isPresent()) {
            String tenantParamValue = tenantFromUri.get();
            if ("_main".equals(tenantParamValue)) {
                return null;
            }
            return tenantParamValue;
        }
        return request.header("sgtenant") != null ? request.header("sgtenant") : request.header("sg_tenant");
    }

    public static Optional<String> getSignalsTenantFrom(RestRequest request) {
        if (request.uri().startsWith("/_signals/watch/") || request.uri().startsWith("/_signals/tenant/")) {
            return Optional.of(request.uri().split("/")[3]);
        }
        return Optional.empty();
    }
}

